/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.controllerAPI.command.QueueableCommand;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public abstract class RigidBodyControlState
implements State {
    protected final YoRegistry registry;
    protected final String warningPrefix;
    protected final YoBoolean trajectoryDone;
    private final YoLong lastCommandId;
    private final YoDouble trajectoryStartTime;
    private final YoDouble yoTime;
    protected final ArrayList<YoGraphic> graphics = new ArrayList();
    private final RigidBodyControlMode controlMode;

    public RigidBodyControlState(RigidBodyControlMode controlMode, String bodyName, YoDouble yoTime, YoRegistry parentRegistry) {
        this.controlMode = controlMode;
        this.yoTime = yoTime;
        this.warningPrefix = this.getClass().getSimpleName() + " for " + bodyName + ": ";
        this.registry = new YoRegistry(RigidBodyControlState.createRegistryName(bodyName, controlMode));
        String prefix = controlMode != null ? bodyName + StringUtils.capitalize((String)controlMode.toString().toLowerCase()) : bodyName;
        this.lastCommandId = new YoLong(prefix + "LastCommandId", this.registry);
        this.lastCommandId.set(0L);
        this.trajectoryDone = new YoBoolean(prefix + "TrajectoryDone", this.registry);
        this.trajectoryStartTime = new YoDouble(prefix + "TrajectoryStartTime", this.registry);
        parentRegistry.addChild(this.registry);
    }

    protected boolean handleCommandInternal(Command<?, ?> command) {
        if (command instanceof QueueableCommand) {
            boolean previousIdMatch;
            QueueableCommand queueableCommand = (QueueableCommand)command;
            if (queueableCommand.getCommandId() == 0L) {
                LogTools.warn((String)(this.warningPrefix + "Recieved packet with invalid ID."));
                return false;
            }
            boolean wantToQueue = queueableCommand.getExecutionMode() == ExecutionMode.QUEUE;
            boolean bl = previousIdMatch = queueableCommand.getPreviousCommandId() == this.lastCommandId.getLongValue();
            if (!this.isEmpty() && wantToQueue && !previousIdMatch) {
                LogTools.warn((String)(this.warningPrefix + "Unexpected command ID. Msg previous id: " + queueableCommand.getPreviousCommandId() + " but was " + this.lastCommandId.getLongValue()));
                return false;
            }
            if (!wantToQueue || this.isEmpty()) {
                this.setTrajectoryStartTimeToCurrentTime();
            } else {
                queueableCommand.addTimeOffset(this.getLastTrajectoryPointTime());
            }
            this.lastCommandId.set(queueableCommand.getCommandId());
        } else {
            this.setTrajectoryStartTimeToCurrentTime();
        }
        this.trajectoryDone.set(false);
        return true;
    }

    protected void setTrajectoryStartTimeToCurrentTime() {
        this.trajectoryStartTime.set(this.yoTime.getDoubleValue());
    }

    public double getTimeInTrajectory() {
        return this.yoTime.getDoubleValue() - this.trajectoryStartTime.getDoubleValue();
    }

    protected void resetLastCommandId() {
        this.lastCommandId.set(0L);
    }

    public boolean abortState() {
        return false;
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return null;
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return null;
    }

    public FeedbackControlCommand<?> createFeedbackControlTemplate() {
        return this.getFeedbackControlCommand();
    }

    public abstract boolean isEmpty();

    public abstract double getLastTrajectoryPointTime();

    public boolean isDone(double timeInState) {
        return true;
    }

    public InverseDynamicsCommand<?> getTransitionOutOfStateCommand() {
        return null;
    }

    protected void updateGraphics() {
        for (int graphicsIdx = 0; graphicsIdx < this.graphics.size(); ++graphicsIdx) {
            this.graphics.get(graphicsIdx).update();
        }
    }

    protected void hideGraphics() {
        for (int graphicsIdx = 0; graphicsIdx < this.graphics.size(); ++graphicsIdx) {
            YoGraphic yoGraphic = this.graphics.get(graphicsIdx);
            if (yoGraphic instanceof YoGraphicReferenceFrame) {
                ((YoGraphicReferenceFrame)yoGraphic).hide();
                continue;
            }
            if (yoGraphic instanceof YoGraphicPosition) {
                ((YoGraphicPosition)yoGraphic).setPositionToNaN();
                continue;
            }
            if (yoGraphic instanceof YoGraphicVector) {
                ((YoGraphicVector)yoGraphic).hide();
                continue;
            }
            if (yoGraphic instanceof YoGraphicCoordinateSystem) {
                ((YoGraphicCoordinateSystem)yoGraphic).hide();
                continue;
            }
            throw new RuntimeException("Implement hiding this.");
        }
    }

    public static String createRegistryName(String bodyName, RigidBodyControlMode stateEnum) {
        String prefix = stateEnum != null ? bodyName + StringUtils.capitalize((String)stateEnum.toString().toLowerCase()) : bodyName;
        return prefix + "ControlModule";
    }

    public RigidBodyControlMode getControlMode() {
        return this.controlMode;
    }

    public Object pollStatusToReport() {
        return null;
    }
}

