/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.pelvis;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.configurations.LeapOfFaithParameters;
import us.ihmc.commonWalkingControlModules.configurations.PelvisOffsetWhileWalkingParameters;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.ControllerPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationControlState;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.UserPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisOrientationTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class PelvisOrientationManager {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final StateMachine<PelvisOrientationControlMode, PelvisOrientationControlState> stateMachine;
    private final YoEnum<PelvisOrientationControlMode> requestedState;
    private final YoBoolean enableUserPelvisControlDuringWalking = new YoBoolean("EnableUserPelvisControlDuringWalking", this.registry);
    private final YoBoolean doPrepareForLocomotion = new YoBoolean("doPreparePelvisForLocomotion", this.registry);
    private final ControllerPelvisOrientationManager walkingManager;
    private final UserPelvisOrientationManager userManager;
    private final PelvisOrientationTrajectoryCommand tempPelvisOrientationTrajectoryCommand = new PelvisOrientationTrajectoryCommand();

    public PelvisOrientationManager(PID3DGainsReadOnly gains, PelvisOffsetWhileWalkingParameters pelvisOffsetWhileWalkingParameters, LeapOfFaithParameters leapOfFaithParameters, HighLevelHumanoidControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
        YoDouble yoTime = controllerToolbox.getYoTime();
        String namePrefix = this.getClass().getSimpleName();
        this.requestedState = new YoEnum(namePrefix + "RequestedControlMode", this.registry, PelvisOrientationControlMode.class, true);
        this.walkingManager = new ControllerPelvisOrientationManager(gains, pelvisOffsetWhileWalkingParameters, leapOfFaithParameters, controllerToolbox, this.registry);
        this.userManager = new UserPelvisOrientationManager(gains, controllerToolbox, this.registry);
        this.stateMachine = this.setupStateMachine(namePrefix, (DoubleProvider)yoTime);
        this.enableUserPelvisControlDuringWalking.set(false);
    }

    private StateMachine<PelvisOrientationControlMode, PelvisOrientationControlState> setupStateMachine(String namePrefix, DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(PelvisOrientationControlMode.class);
        factory.setNamePrefix(namePrefix).setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addState((Enum)PelvisOrientationControlMode.WALKING_CONTROLLER, (State)this.walkingManager);
        factory.addState((Enum)PelvisOrientationControlMode.USER, (State)this.userManager);
        for (PelvisOrientationControlMode from : PelvisOrientationControlMode.values()) {
            factory.addRequestedTransition((Enum)from, this.requestedState);
            factory.addRequestedTransition((Enum)from, (Enum)from, this.requestedState);
        }
        return factory.build((Enum)PelvisOrientationControlMode.WALKING_CONTROLLER);
    }

    public void setWeights(Vector3DReadOnly weight) {
        this.walkingManager.setWeights(weight);
        this.userManager.setWeights(weight);
    }

    public void setPrepareForLocomotion(boolean value) {
        this.doPrepareForLocomotion.set(value);
    }

    public void compute() {
        this.stateMachine.doActionAndTransition();
    }

    public void initialize() {
        this.walkingManager.resetOrientationOffset();
        this.requestState(PelvisOrientationControlMode.WALKING_CONTROLLER);
        this.walkingManager.setToZeroInMidFeetZUpFrame();
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        if (this.stateMachine.getCurrentStateKey() == PelvisOrientationControlMode.USER) {
            this.walkingManager.setOffset(this.userManager.getDesiredOrientation());
        }
        this.requestState(PelvisOrientationControlMode.WALKING_CONTROLLER);
    }

    public void prepareForLocomotion(double trajectoryTime) {
        if (this.enableUserPelvisControlDuringWalking.getBooleanValue()) {
            return;
        }
        if (this.doPrepareForLocomotion.getValue()) {
            if (this.stateMachine.getCurrentStateKey() == PelvisOrientationControlMode.WALKING_CONTROLLER) {
                this.walkingManager.goToHomeFromCurrentDesired(trajectoryTime);
            } else {
                this.walkingManager.goToHomeFromOffset(this.userManager.getDesiredOrientation(), trajectoryTime);
            }
        } else if (this.stateMachine.getCurrentStateKey() == PelvisOrientationControlMode.USER) {
            this.walkingManager.setOffset(this.userManager.getDesiredOrientation());
        }
        this.requestState(PelvisOrientationControlMode.WALKING_CONTROLLER);
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return ((PelvisOrientationControlState)this.stateMachine.getCurrentState()).getFeedbackControlCommand();
    }

    public void goToHomeFromCurrentDesired(double trajectoryTime) {
        if (this.stateMachine.getCurrentStateKey() == PelvisOrientationControlMode.USER) {
            this.walkingManager.setOffset(this.userManager.getDesiredOrientation());
        }
        this.walkingManager.goToHomeFromCurrentDesired(trajectoryTime);
        this.requestState(PelvisOrientationControlMode.WALKING_CONTROLLER);
    }

    public void setTrajectoryTime(double trajectoryTime) {
        this.walkingManager.setTrajectoryTime(trajectoryTime);
    }

    public void moveToAverageInSupportFoot(RobotSide supportSide) {
        this.walkingManager.moveToAverageInSupportFoot(supportSide);
    }

    public void resetOrientationOffset() {
        this.walkingManager.resetOrientationOffset();
    }

    public void setToHoldCurrentDesiredInMidFeetZUpFrame() {
        this.walkingManager.setToHoldCurrentDesiredInMidFeetZUpFrame();
    }

    public void centerInMidFeetZUpFrame(double trajectoryTime) {
        this.walkingManager.centerInMidFeetZUpFrame(trajectoryTime);
    }

    public void setToHoldCurrentDesiredInSupportFoot(RobotSide supportSide) {
        this.walkingManager.setToHoldCurrentDesiredInSupportFoot(supportSide);
    }

    public void setToHoldCurrentInWorldFrame() {
        this.walkingManager.setToHoldCurrentInWorldFrame();
    }

    public void setToZeroInMidFeetZUpFrame() {
        this.walkingManager.setToZeroInMidFeetZUpFrame();
    }

    public void initializeStanding() {
        this.walkingManager.initializeStanding();
    }

    public void initializeSwing(RobotSide supportSide, double swingDuration, double nextTransferDuration, double nextSwingDuration) {
        this.walkingManager.initializeSwing(supportSide, swingDuration, nextTransferDuration, nextSwingDuration);
    }

    public void setUpcomingFootstep(Footstep upcomingFootstep) {
        this.walkingManager.setUpcomingFootstep(upcomingFootstep);
    }

    public void initializeTransfer(RobotSide transferToSide, double transferDuration, double swingDuration) {
        this.walkingManager.initializeTransfer(transferToSide, transferDuration, swingDuration);
    }

    public void initializeTrajectory() {
        this.walkingManager.updateTrajectoryFromFootstep();
    }

    public void updateTrajectoryFromFootstep() {
        this.walkingManager.updateTrajectoryFromFootstep();
    }

    public void setTrajectoryFromFootstep() {
        this.walkingManager.setTrajectoryFromFootstep();
    }

    public boolean handlePelvisOrientationTrajectoryCommands(PelvisOrientationTrajectoryCommand command) {
        if (command.getSO3Trajectory().useCustomControlFrame()) {
            LogTools.warn((String)"Can not use custom control frame with pelvis orientation.");
            return false;
        }
        this.enableUserPelvisControlDuringWalking.set(command.isEnableUserPelvisControlDuringWalking());
        if (this.userManager.handlePelvisOrientationTrajectoryCommands(command)) {
            this.requestState(PelvisOrientationControlMode.USER);
            return true;
        }
        this.walkingManager.setToHoldCurrentInWorldFrame();
        this.requestState(PelvisOrientationControlMode.WALKING_CONTROLLER);
        return false;
    }

    public boolean handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        SelectionMatrix3D angularSelectionMatrix = command.getSE3Trajectory().getSelectionMatrix().getAngularPart();
        if (angularSelectionMatrix.isXSelected() || angularSelectionMatrix.isYSelected() || angularSelectionMatrix.isZSelected()) {
            this.tempPelvisOrientationTrajectoryCommand.set(command);
            return this.handlePelvisOrientationTrajectoryCommands(this.tempPelvisOrientationTrajectoryCommand);
        }
        return true;
    }

    private void requestState(PelvisOrientationControlMode state) {
        if (this.stateMachine.getCurrentStateKey() != state) {
            this.requestedState.set((Enum)state);
        }
    }

    public void setSelectionMatrix(SelectionMatrix3D selectionMatrix) {
        this.walkingManager.setSelectionMatrix(selectionMatrix);
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.userManager.pollStatusToReport();
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (PelvisOrientationControlMode mode : PelvisOrientationControlMode.values()) {
            PelvisOrientationControlState state = (PelvisOrientationControlState)this.stateMachine.getState((Enum)mode);
            if (state == null || state.getFeedbackControlCommand() == null) continue;
            ret.addCommand(state.getFeedbackControlCommand());
        }
        return ret;
    }
}

