/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.legConfiguration;

import us.ihmc.commonWalkingControlModules.configurations.LegConfigurationParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationControlModule;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class LegConfigurationManager {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final double forwardSteppingThreshold = -0.05;
    private static final double minimumAngleForSideStepping = 45.0;
    private static final double stepDownTooFar = -0.1;
    private static final double stepHeightForCollapse = 10.0;
    private final YoBoolean attemptToStraightenLegs = new YoBoolean("attemptToStraightenLegs", this.registry);
    private final YoDouble stepHeight = new YoDouble("stepHeight", this.registry);
    private final YoDouble maxStepHeightForCollapse = new YoDouble("maxStepHeightForCollapse", this.registry);
    private final YoDouble stepHeightForForcedCollapse = new YoDouble("stepHeightForForcedCollapsing", this.registry);
    private final YoDouble minStepLengthForCollapse = new YoDouble("minStepLengthForCollapse", this.registry);
    private final SideDependentList<LegConfigurationControlModule> legConfigurationControlModules = new SideDependentList();
    private final SideDependentList<? extends ContactablePlaneBody> feet;
    private final double inPlaceWidth;
    private final double footLength;
    private final FramePoint2D tempLeadingFootPosition = new FramePoint2D();
    private final FramePoint2D tempTrailingFootPosition = new FramePoint2D();
    private final FramePoint3D tempLeadingFootPositionInWorld = new FramePoint3D();
    private final FramePoint3D tempTrailingFootPositionInWorld = new FramePoint3D();

    public LegConfigurationManager(HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        this.feet = controllerToolbox.getContactableFeet();
        LegConfigurationParameters legConfigurationParameters = walkingControllerParameters.getLegConfigurationParameters();
        for (RobotSide robotSide : RobotSide.values) {
            this.legConfigurationControlModules.put((Enum)robotSide, (Object)new LegConfigurationControlModule(robotSide, controllerToolbox, legConfigurationParameters, this.registry));
        }
        this.attemptToStraightenLegs.set(legConfigurationParameters.attemptToStraightenLegs());
        this.inPlaceWidth = walkingControllerParameters.getSteppingParameters().getInPlaceWidth();
        this.footLength = walkingControllerParameters.getSteppingParameters().getFootBackwardOffset() + walkingControllerParameters.getSteppingParameters().getFootForwardOffset();
        this.maxStepHeightForCollapse.set(10.0);
        this.stepHeightForForcedCollapse.set(-0.1);
        this.minStepLengthForCollapse.set(walkingControllerParameters.getSteppingParameters().getFootLength());
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        for (RobotSide robotSide : RobotSide.values) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).initialize();
        }
    }

    public void compute() {
        for (RobotSide robotSide : RobotSide.values) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).doControl();
        }
    }

    public void startSwing(RobotSide upcomingSwingSide) {
        if (this.attemptToStraightenLegs.getBooleanValue()) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)upcomingSwingSide)).setKneeAngleState(LegConfigurationControlModule.LegConfigurationType.BENT);
        }
    }

    public boolean isLegCollapsed(RobotSide robotSide) {
        LegConfigurationControlModule.LegConfigurationType legConfigurationControlState = ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).getCurrentKneeControlState();
        return legConfigurationControlState.equals((Object)LegConfigurationControlModule.LegConfigurationType.BENT) || legConfigurationControlState.equals((Object)LegConfigurationControlModule.LegConfigurationType.COLLAPSE);
    }

    public boolean isLegBent(RobotSide robotSide) {
        LegConfigurationControlModule.LegConfigurationType legConfigurationControlState = ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).getCurrentKneeControlState();
        return legConfigurationControlState.equals((Object)LegConfigurationControlModule.LegConfigurationType.BENT);
    }

    private boolean isLegCurrentlyStraightening(RobotSide robotSide) {
        return ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).getCurrentKneeControlState() == LegConfigurationControlModule.LegConfigurationType.STRAIGHTEN;
    }

    public void collapseLegDuringTransfer(RobotSide transferSide) {
        if (this.attemptToStraightenLegs.getBooleanValue()) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)transferSide.getOppositeSide())).setKneeAngleState(LegConfigurationControlModule.LegConfigurationType.COLLAPSE);
        }
    }

    public void collapseLegDuringSwing(RobotSide supportSide) {
        if (this.attemptToStraightenLegs.getBooleanValue()) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)supportSide)).setKneeAngleState(LegConfigurationControlModule.LegConfigurationType.COLLAPSE);
        }
    }

    public void straightenLegDuringSwing(RobotSide swingSide) {
        if (((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)swingSide)).getCurrentKneeControlState() != LegConfigurationControlModule.LegConfigurationType.STRAIGHTEN && ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)swingSide)).getCurrentKneeControlState() != LegConfigurationControlModule.LegConfigurationType.STRAIGHT) {
            boolean isNextStepTooLow;
            this.setStraight(swingSide);
            this.setFullyExtendLeg(swingSide, true);
            this.useHighWeight(swingSide);
            boolean bl = isNextStepTooLow = this.stepHeight.getDoubleValue() < this.stepHeightForForcedCollapse.getDoubleValue();
            if (isNextStepTooLow) {
                this.prepareForLegBracing(swingSide);
            } else {
                this.doNotBrace(swingSide);
            }
        }
    }

    public void setStepDuration(RobotSide supportSide, double stepDuration) {
        ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)supportSide)).setStepDuration(stepDuration);
    }

    public void setFullyExtendLeg(RobotSide robotSide, boolean fullyExtendLeg) {
        ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).setFullyExtendLeg(fullyExtendLeg);
    }

    public void prepareForLegBracing(RobotSide robotSide) {
        ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).prepareForLegBracing();
    }

    public void doNotBrace(RobotSide robotSide) {
        ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).doNotBrace();
    }

    public void useLowWeight(RobotSide robotSide) {
        if (this.attemptToStraightenLegs.getBooleanValue()) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).setLegControlWeight(LegConfigurationControlModule.LegControlWeight.LOW);
        }
    }

    public void useMediumWeight(RobotSide robotSide) {
        if (this.attemptToStraightenLegs.getBooleanValue()) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).setLegControlWeight(LegConfigurationControlModule.LegControlWeight.MEDIUM);
        }
    }

    public void useHighWeight(RobotSide robotSide) {
        if (this.attemptToStraightenLegs.getBooleanValue()) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).setLegControlWeight(LegConfigurationControlModule.LegControlWeight.HIGH);
        }
    }

    public void setStraight(RobotSide robotSide) {
        if (this.attemptToStraightenLegs.getBooleanValue() && !this.isLegCurrentlyStraightening(robotSide)) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).setKneeAngleState(LegConfigurationControlModule.LegConfigurationType.STRAIGHT);
        }
    }

    public void beginStraightening(RobotSide robotSide) {
        if (this.attemptToStraightenLegs.getBooleanValue() && !this.isLegCurrentlyStraightening(robotSide)) {
            ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).setKneeAngleState(LegConfigurationControlModule.LegConfigurationType.STRAIGHTEN);
        }
    }

    public boolean areFeetWellPositionedForCollapse(RobotSide trailingLeg) {
        ReferenceFrame frontFootFrame = ((ContactablePlaneBody)this.feet.get((Enum)trailingLeg.getOppositeSide())).getSoleFrame();
        return this.areFeetWellPositionedForCollapse(trailingLeg, frontFootFrame);
    }

    public boolean areFeetWellPositionedForCollapse(RobotSide trailingLeg, ReferenceFrame frontFootFrame) {
        boolean isSideStepping;
        boolean isNextStepTooHigh;
        boolean isForwardStepping;
        boolean isNextStepTooLow;
        ReferenceFrame trailingFootFrame = ((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getSoleFrame();
        this.tempTrailingFootPosition.setToZero(trailingFootFrame);
        this.tempLeadingFootPosition.setToZero(frontFootFrame);
        this.tempLeadingFootPosition.changeFrameAndProjectToXYPlane(trailingFootFrame);
        if (Math.abs(this.tempLeadingFootPosition.getY()) > this.inPlaceWidth) {
            this.tempLeadingFootPosition.setY(this.tempLeadingFootPosition.getY() + trailingLeg.negateIfRightSide(this.inPlaceWidth));
        } else {
            this.tempLeadingFootPosition.setY(0.0);
        }
        this.tempLeadingFootPositionInWorld.setToZero(frontFootFrame);
        this.tempTrailingFootPositionInWorld.setToZero(trailingFootFrame);
        this.tempLeadingFootPositionInWorld.changeFrame(worldFrame);
        this.tempTrailingFootPositionInWorld.changeFrame(worldFrame);
        this.stepHeight.set(this.tempLeadingFootPositionInWorld.getZ() - this.tempTrailingFootPositionInWorld.getZ());
        boolean bl = isNextStepTooLow = this.stepHeight.getDoubleValue() < this.stepHeightForForcedCollapse.getDoubleValue();
        if (isNextStepTooLow) {
            return true;
        }
        boolean bl2 = isForwardStepping = this.tempLeadingFootPositionInWorld.getX() > -0.05;
        if (!isForwardStepping) {
            return false;
        }
        boolean bl3 = isNextStepTooHigh = this.stepHeight.getDoubleValue() > this.maxStepHeightForCollapse.getDoubleValue();
        if (isNextStepTooHigh) {
            return false;
        }
        boolean bl4 = isSideStepping = Math.abs(Math.atan2(this.tempLeadingFootPosition.getY(), this.tempLeadingFootPosition.getX())) > Math.toRadians(45.0);
        if (isSideStepping) {
            return false;
        }
        boolean isStepLongEnough = this.tempLeadingFootPosition.distance((FramePoint2DReadOnly)this.tempTrailingFootPosition) > this.minStepLengthForCollapse.getDoubleValue();
        boolean isStepLongEnoughAlongX = this.tempLeadingFootPosition.getX() > this.footLength;
        return isStepLongEnough && isStepLongEnoughAlongX;
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand(RobotSide robotSide) {
        return null;
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand(RobotSide robotSide) {
        return ((LegConfigurationControlModule)this.legConfigurationControlModules.get((Enum)robotSide)).getInverseDynamicsCommand();
    }
}

