/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.leapOfFaith;

import us.ihmc.commonWalkingControlModules.configurations.LeapOfFaithParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PelvisLeapOfFaithModule {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final String yoNamePrefix = "leapOfFaith";
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoFrameYawPitchRoll orientationOffset = new YoFrameYawPitchRoll("leapOfFaithPelvisOrientationOffset", worldFrame, this.registry);
    private final YoBoolean isInSwing = new YoBoolean("leapOfFaithIsInSwing", this.registry);
    private final BooleanProvider usePelvisRotation;
    private final BooleanProvider relaxPelvisWeight;
    private final DoubleProvider reachingYawGain;
    private final DoubleProvider reachingRollGain;
    private final DoubleProvider reachingMaxYaw;
    private final DoubleProvider reachingMaxRoll;
    private final DoubleProvider reachingFractionOfSwing;
    private final YoDouble relaxationFraction = new YoDouble("leapOfFaithPelvisRelaxationFraction", this.registry);
    private final DoubleProvider weightRelaxationRate;
    private final DoubleProvider minimumWeight;
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private RobotSide supportSide;
    private Footstep upcomingFootstep;
    private double stateDuration;
    private final YoDouble timeInLeapOfFaith = new YoDouble("timeInPelvisLeapOfFaith", this.registry);
    private double phaseOutTime;
    private final FramePoint3D tempPoint = new FramePoint3D();

    public PelvisLeapOfFaithModule(SideDependentList<? extends ReferenceFrame> soleZUpFrames, LeapOfFaithParameters parameters, YoRegistry parentRegistry) {
        this.soleZUpFrames = soleZUpFrames;
        this.usePelvisRotation = new BooleanParameter("leapOfFaithUsePelvisRotationForReaching", this.registry, parameters.usePelvisRotation());
        this.relaxPelvisWeight = new BooleanParameter("leapOfFaithRelaxPelvisWeight", this.registry, parameters.relaxPelvisControl());
        this.reachingYawGain = new DoubleParameter("leapOfFaithPelvisReachingYawGain", this.registry, parameters.getPelvisReachingYawGain());
        this.reachingRollGain = new DoubleParameter("leapOfFaithPelvisReachingRollGain", this.registry, parameters.getPelvisReachingRollGain());
        this.reachingMaxYaw = new DoubleParameter("leapOfFaithPelvisReachingMaxYaw", this.registry, parameters.getPelvisReachingMaxYaw());
        this.reachingMaxRoll = new DoubleParameter("leapOfFaithPelvisReachingMaxRoll", this.registry, parameters.getPelvisReachingMaxRoll());
        this.reachingFractionOfSwing = new DoubleParameter("leapOfFaithPelvisReachingFractionOfSwing", this.registry, parameters.getPelvisReachingFractionOfSwing());
        this.weightRelaxationRate = new DoubleParameter("leapOfFaithPelvisWeightRelaxationRate", this.registry, parameters.getRelaxationRate());
        this.minimumWeight = new DoubleParameter("leapOfFaithPelvisMinimumWeight", this.registry, parameters.getMinimumPelvisWeight());
        parentRegistry.addChild(this.registry);
    }

    public void setUpcomingFootstep(Footstep upcomingFootstep) {
        this.upcomingFootstep = upcomingFootstep;
        this.supportSide = upcomingFootstep.getRobotSide().getOppositeSide();
    }

    public void initializeStanding() {
        this.isInSwing.set(false);
    }

    public void initializeTransfer(double transferDuration) {
        this.stateDuration = transferDuration;
        this.isInSwing.set(false);
    }

    public void initializeSwing(double swingDuration) {
        this.stateDuration = swingDuration;
        this.isInSwing.set(true);
    }

    public void update(double currentTimeInState) {
        if (this.isInSwing.getBooleanValue()) {
            this.timeInLeapOfFaith.set(Math.max(currentTimeInState - this.reachingFractionOfSwing.getValue() * this.stateDuration, 0.0));
        } else {
            this.phaseOutTime = Math.max(this.timeInLeapOfFaith.getDoubleValue() - currentTimeInState, 0.0);
        }
    }

    public void updateAngularOffsets() {
        double timeForReaching;
        this.orientationOffset.setToZero();
        if (!this.usePelvisRotation.getValue()) {
            return;
        }
        if (this.isInSwing.getBooleanValue()) {
            if (this.timeInLeapOfFaith.getDoubleValue() <= 0.0) {
                return;
            }
            timeForReaching = this.timeInLeapOfFaith.getDoubleValue();
        } else {
            if (this.phaseOutTime <= 0.0) {
                return;
            }
            timeForReaching = this.phaseOutTime;
        }
        this.tempPoint.setToZero(this.upcomingFootstep.getSoleReferenceFrame());
        this.tempPoint.changeFrame((ReferenceFrame)this.soleZUpFrames.get((Enum)this.supportSide));
        double stepLength = this.tempPoint.getX();
        double yawAngleOffset = this.reachingYawGain.getValue() * timeForReaching * stepLength;
        double rollAngleOffset = this.reachingRollGain.getValue() * timeForReaching;
        yawAngleOffset = MathTools.clamp((double)yawAngleOffset, (double)this.reachingMaxYaw.getValue());
        rollAngleOffset = MathTools.clamp((double)rollAngleOffset, (double)this.reachingMaxRoll.getValue());
        yawAngleOffset = this.supportSide.negateIfRightSide(yawAngleOffset);
        rollAngleOffset = this.supportSide.negateIfRightSide(rollAngleOffset);
        this.orientationOffset.setRoll(rollAngleOffset);
        this.orientationOffset.setYaw(yawAngleOffset);
    }

    public void relaxAngularWeight(Vector3DBasics angularWeightToPack) {
        double relaxationTime;
        this.relaxationFraction.set(0.0);
        if (!this.relaxPelvisWeight.getValue()) {
            return;
        }
        if (this.isInSwing.getBooleanValue()) {
            if (this.timeInLeapOfFaith.getDoubleValue() < 0.0) {
                return;
            }
            relaxationTime = this.timeInLeapOfFaith.getDoubleValue();
        } else {
            if (this.phaseOutTime < 0.0) {
                return;
            }
            relaxationTime = this.phaseOutTime;
        }
        double relaxationFraction = this.weightRelaxationRate.getValue() * relaxationTime;
        relaxationFraction = MathTools.clamp((double)relaxationFraction, (double)0.0, (double)1.0);
        this.relaxationFraction.set(relaxationFraction);
        angularWeightToPack.scale(1.0 - relaxationFraction);
        angularWeightToPack.setX(Math.max(this.minimumWeight.getValue(), angularWeightToPack.getX()));
        angularWeightToPack.setY(Math.max(this.minimumWeight.getValue(), angularWeightToPack.getY()));
        angularWeightToPack.setZ(Math.max(this.minimumWeight.getValue(), angularWeightToPack.getZ()));
    }

    public void addAngularOffset(FixedFrameQuaternionBasics orientationToPack) {
        orientationToPack.prepend((FrameOrientation3DReadOnly)this.orientationOffset);
    }
}

