/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.leapOfFaith;

import us.ihmc.commonWalkingControlModules.configurations.LeapOfFaithParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FootLeapOfFaithModule {
    private static final String yoNamePrefix = "leapOfFaith";
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble swingDuration;
    private final DoubleProvider fractionOfSwing;
    private final BooleanProvider scaleFootWeight;
    private final DoubleProvider verticalFootWeightScaleFactor;
    private final DoubleProvider horizontalFootWeightScaleFactor;
    private final YoDouble verticalFootWeightScaleFraction = new YoDouble("leapOfFaithVerticalFootWeightScaleFraction", this.registry);
    private final YoDouble horizontalFootWeightScaleFraction = new YoDouble("leapOfFaithHorizontalFootWeightScaleFraction", this.registry);
    private final DoubleProvider minimumHorizontalWeight;

    public FootLeapOfFaithModule(YoDouble swingDuration, LeapOfFaithParameters parameters, YoRegistry parentRegistry) {
        this.swingDuration = swingDuration;
        this.scaleFootWeight = new BooleanParameter("leapOfFaithScaleFootWeight", this.registry, parameters.scaleFootWeight());
        this.fractionOfSwing = new DoubleParameter("leapOfFaithFractionOfSwingToScaleFootWeight", this.registry, parameters.getFractionOfSwingToScaleFootWeight());
        this.horizontalFootWeightScaleFactor = new DoubleParameter("leapOfFaithHorizontalFootWeightScaleFactor", this.registry, parameters.getHorizontalFootWeightScaleFactor());
        this.verticalFootWeightScaleFactor = new DoubleParameter("leapOfFaithVerticalFootWeightScaleFactor", this.registry, parameters.getVerticalFootWeightScaleFactor());
        this.minimumHorizontalWeight = new DoubleParameter("leapOfFaithMinimumHorizontalFootWeight", this.registry, parameters.getMinimumHorizontalFootWeight());
        parentRegistry.addChild(this.registry);
    }

    public void compute(double currentTime) {
        this.horizontalFootWeightScaleFraction.set(1.0);
        this.verticalFootWeightScaleFraction.set(1.0);
        double exceededTime = Math.max(currentTime - this.fractionOfSwing.getValue() * this.swingDuration.getDoubleValue(), 0.0);
        if (exceededTime <= 0.0) {
            return;
        }
        if (this.scaleFootWeight.getValue()) {
            double horizontalFootWeightScaleFraction = MathTools.clamp((double)(1.0 - this.horizontalFootWeightScaleFactor.getValue() * exceededTime), (double)0.0, (double)1.0);
            double verticalFootWeightScaleFraction = Math.max(1.0, 1.0 + exceededTime * this.verticalFootWeightScaleFactor.getValue());
            this.horizontalFootWeightScaleFraction.set(horizontalFootWeightScaleFraction);
            this.verticalFootWeightScaleFraction.set(verticalFootWeightScaleFraction);
        }
    }

    public void scaleFootWeight(Vector3DReadOnly unscaledLinearWeight, Vector3DBasics scaledLinearWeightToPack) {
        scaledLinearWeightToPack.set((Tuple3DReadOnly)unscaledLinearWeight);
        if (!this.scaleFootWeight.getValue()) {
            return;
        }
        scaledLinearWeightToPack.scale(this.horizontalFootWeightScaleFraction.getDoubleValue());
        scaledLinearWeightToPack.setX(Math.max(this.minimumHorizontalWeight.getValue(), scaledLinearWeightToPack.getX()));
        scaledLinearWeightToPack.setY(Math.max(this.minimumHorizontalWeight.getValue(), scaledLinearWeightToPack.getY()));
        scaledLinearWeightToPack.setZ(unscaledLinearWeight.getZ() * this.verticalFootWeightScaleFraction.getDoubleValue());
    }
}

