/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.ToeOffParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffEnum;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.footstep.FootstepUtils;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CentroidProjectionToeOffCalculator
implements ToeOffCalculator {
    private static final boolean visualize = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final String namePrefix = "centProj";
    private final SideDependentList<List<YoContactPoint>> contactPoints = new SideDependentList();
    private final FramePoint2D toeOffContactPoint2d = new FramePoint2D();
    private final FramePoint2D closestPointOnRay = new FramePoint2D();
    private final FrameLineSegment2D toeOffContactLine2d = new FrameLineSegment2D();
    private final FramePoint3D exitCMP = new FramePoint3D();
    private final FramePoint2D exitCMP2d = new FramePoint2D();
    private final FrameVector2D exitCMPRayDirection2d = new FrameVector2D();
    private final FramePoint2D tmpPoint2d = new FramePoint2D();
    private final FramePoint2D tmpPoint2d2 = new FramePoint2D();
    private final FrameLine2D rayThroughExitCMP = new FrameLine2D();
    private final SideDependentList<ReferenceFrame> soleFrames = new SideDependentList();
    private final FrameConvexPolygon2D footPolygon = new FrameConvexPolygon2D();
    private final YoDouble toeOffContactInterpolation;
    private final YoBoolean hasComputedToeOffContactPoint;
    private final YoBoolean hasComputedToeOffContactLine;
    private final YoFramePoint2D rayOrigin;
    private final YoFramePoint2D rayEnd;
    private final FramePoint2D desiredCMP = new FramePoint2D();

    public CentroidProjectionToeOffCalculator(SideDependentList<YoPlaneContactState> contactStates, SideDependentList<? extends ContactablePlaneBody> feet, ToeOffParameters toeOffParameters, YoRegistry parentRegistry) {
        this(contactStates, feet, toeOffParameters, parentRegistry, null);
    }

    public CentroidProjectionToeOffCalculator(SideDependentList<YoPlaneContactState> contactStates, SideDependentList<? extends ContactablePlaneBody> feet, ToeOffParameters toeOffParameters, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        for (RobotSide robotSide : RobotSide.values) {
            ReferenceFrame soleFrame = ((ContactablePlaneBody)feet.get((Enum)robotSide)).getSoleFrame();
            this.soleFrames.put((Enum)robotSide, (Object)soleFrame);
            this.contactPoints.put((Enum)robotSide, ((YoPlaneContactState)contactStates.get((Enum)robotSide)).getContactPoints());
        }
        this.toeOffContactInterpolation = new YoDouble("centProjToeOffContactInterpolation", this.registry);
        this.toeOffContactInterpolation.set(toeOffParameters.getToeOffContactInterpolation());
        this.hasComputedToeOffContactPoint = new YoBoolean("centProjHasComputedToeOffContactPoint", this.registry);
        this.hasComputedToeOffContactLine = new YoBoolean("centProjHasComputedToeOffContactLine", this.registry);
        parentRegistry.addChild(this.registry);
        this.rayOrigin = null;
        this.rayEnd = null;
    }

    @Override
    public ToeOffEnum getEnum() {
        return ToeOffEnum.CENTROID_PROJECTION;
    }

    @Override
    public void clear() {
        this.exitCMP2d.setToNaN();
        this.hasComputedToeOffContactPoint.set(false);
        this.hasComputedToeOffContactLine.set(false);
    }

    @Override
    public void setExitCMP(FramePoint3DReadOnly exitCMP, RobotSide trailingLeg) {
        ReferenceFrame soleFrame = (ReferenceFrame)this.soleFrames.get((Enum)trailingLeg);
        this.exitCMP.setIncludingFrame((FrameTuple3DReadOnly)exitCMP);
        this.exitCMP.changeFrame(soleFrame);
        this.exitCMP2d.setToZero(soleFrame);
        this.exitCMP2d.setIncludingFrame((FrameTuple3DReadOnly)this.exitCMP);
    }

    @Override
    public void computeToeOffContactPoint(FramePoint2DReadOnly desiredCMP, RobotSide trailingLeg) {
        ReferenceFrame soleFrame = (ReferenceFrame)this.soleFrames.get((Enum)trailingLeg);
        this.computeFootPolygon(trailingLeg);
        FramePoint2DReadOnly rayOrigin = this.footPolygon.getCentroid();
        this.exitCMPRayDirection2d.setIncludingFrame(soleFrame, 1.0, 0.0);
        if (!this.exitCMP2d.containsNaN() && this.footPolygon.isPointInside((FramePoint2DReadOnly)this.exitCMP2d)) {
            this.exitCMPRayDirection2d.setToZero(soleFrame);
            this.exitCMPRayDirection2d.sub((FrameTuple2DReadOnly)this.exitCMP2d, (FrameTuple2DReadOnly)this.footPolygon.getCentroid());
        } else {
            this.exitCMPRayDirection2d.setIncludingFrame(soleFrame, 1.0, 0.0);
        }
        this.rayThroughExitCMP.setToZero(soleFrame);
        if (desiredCMP != null && !desiredCMP.containsNaN()) {
            this.tmpPoint2d.setToZero(soleFrame);
            this.desiredCMP.setIncludingFrame((FrameTuple2DReadOnly)desiredCMP);
            this.desiredCMP.changeFrameAndProjectToXYPlane(soleFrame);
            this.tmpPoint2d.interpolate((FrameTuple2DReadOnly)rayOrigin, (FrameTuple2DReadOnly)this.desiredCMP, this.toeOffContactInterpolation.getDoubleValue());
            if (this.footPolygon.isPointInside((FramePoint2DReadOnly)this.tmpPoint2d)) {
                this.rayThroughExitCMP.set((FramePoint2DReadOnly)this.tmpPoint2d, (FrameVector2DReadOnly)this.exitCMPRayDirection2d);
            } else {
                this.rayThroughExitCMP.set(rayOrigin, (FrameVector2DReadOnly)this.exitCMPRayDirection2d);
            }
        } else {
            this.rayThroughExitCMP.set(rayOrigin, (FrameVector2DReadOnly)this.exitCMPRayDirection2d);
        }
        this.computeToeOffContactLine(desiredCMP, trailingLeg);
        if (!this.toeOffContactLine2d.intersectionWith((FrameLine2DReadOnly)this.rayThroughExitCMP, (FramePoint2DBasics)this.toeOffContactPoint2d)) {
            this.tmpPoint2d2.setToZero(soleFrame);
            this.closestPointOnRay.setToZero(soleFrame);
            this.rayThroughExitCMP.getTwoPointsOnLine((FramePoint2DBasics)this.tmpPoint2d, (FramePoint2DBasics)this.tmpPoint2d2);
            EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds((Point2DReadOnly)this.toeOffContactLine2d.getFirstEndpoint(), (Point2DReadOnly)this.toeOffContactLine2d.getSecondEndpoint(), (Point2DReadOnly)this.tmpPoint2d, (Point2DReadOnly)this.tmpPoint2d2, (Point2DBasics)this.toeOffContactPoint2d, (Point2DBasics)this.closestPointOnRay);
        }
        if (this.rayOrigin != null) {
            this.tmpPoint2d.setIncludingFrame((FrameTuple2DReadOnly)rayOrigin);
            this.tmpPoint2d.changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
            this.rayOrigin.set((FrameTuple2DReadOnly)this.tmpPoint2d);
        }
        if (this.rayEnd != null) {
            this.tmpPoint2d.setIncludingFrame((FrameTuple2DReadOnly)this.toeOffContactPoint2d);
            this.tmpPoint2d.changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
            this.rayEnd.set((FrameTuple2DReadOnly)this.tmpPoint2d);
        }
        this.hasComputedToeOffContactPoint.set(true);
    }

    @Override
    public void getToeOffContactPoint(FramePoint2DBasics contactPointToPack, RobotSide trailingLeg) {
        if (!this.hasComputedToeOffContactPoint.getBooleanValue()) {
            this.computeToeOffContactPoint(null, trailingLeg);
        }
        contactPointToPack.set((FrameTuple2DReadOnly)this.toeOffContactPoint2d);
    }

    @Override
    public void computeToeOffContactLine(FramePoint2DReadOnly desiredCMP, RobotSide trailingLeg) {
        this.computeFootPolygon(trailingLeg);
        ReferenceFrame referenceFrame = this.footPolygon.getReferenceFrame();
        this.toeOffContactLine2d.setToZero(referenceFrame);
        this.toeOffContactLine2d.getFirstEndpoint().set(referenceFrame, Double.NEGATIVE_INFINITY, 0.0);
        this.toeOffContactLine2d.getSecondEndpoint().set(referenceFrame, Double.NEGATIVE_INFINITY, 0.0);
        for (int i = 0; i < this.footPolygon.getNumberOfVertices(); ++i) {
            this.tmpPoint2d.setIncludingFrame((FrameTuple2DReadOnly)this.footPolygon.getVertex(i));
            if (this.tmpPoint2d.getX() > this.toeOffContactLine2d.getFirstEndpoint().getX()) {
                this.toeOffContactLine2d.flipDirection();
                this.toeOffContactLine2d.getFirstEndpoint().set((FrameTuple2DReadOnly)this.tmpPoint2d);
                continue;
            }
            if (!(this.tmpPoint2d.getX() > this.toeOffContactLine2d.getSecondEndpoint().getX())) continue;
            this.toeOffContactLine2d.getSecondEndpoint().set((FrameTuple2DReadOnly)this.tmpPoint2d);
        }
        this.hasComputedToeOffContactLine.set(true);
    }

    @Override
    public void getToeOffContactLine(FrameLineSegment2DBasics contactLineToPack, RobotSide trailingLeg) {
        if (!this.hasComputedToeOffContactLine.getBooleanValue()) {
            this.computeToeOffContactLine(null, trailingLeg);
        }
        contactLineToPack.set((FrameLineSegment2DReadOnly)this.toeOffContactLine2d);
    }

    private void computeFootPolygon(RobotSide trailingLeg) {
        ReferenceFrame soleFrame = (ReferenceFrame)this.soleFrames.get((Enum)trailingLeg);
        this.footPolygon.clear(soleFrame);
        for (int i = 0; i < ((List)this.contactPoints.get((Enum)trailingLeg)).size(); ++i) {
            this.footPolygon.addVertex((FramePoint3DReadOnly)((List)this.contactPoints.get((Enum)trailingLeg)).get(i));
        }
        this.footPolygon.update();
    }
}

