/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVelocityStabilityEvaluator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.EdgeVisualizer;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.RotationEdgeCalculator;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.statistics.Line2DStatisticsCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class VelocityRotationEdgeCalculator
implements RotationEdgeCalculator {
    private final MovingReferenceFrame soleFrame;
    private final FixedFramePoint2DBasics pointOfRotation;
    private final AlphaFilteredYoFramePoint2d filteredPointOfRotation;
    private final FixedFrameVector2DBasics axisOfRotation;
    private final AlphaFilteredYoFrameVector2d filteredAxisOfRotation;
    private final FixedFrameLine2DBasics lineOfRotationInSole;
    private final Line2DStatisticsCalculator lineOfRotationStandardDeviation;
    private final EdgeVisualizer edgeVisualizer;
    private final EdgeVelocityStabilityEvaluator stabilityEvaluator;
    private final FrameVector3D tempPointOfRotation = new FrameVector3D();

    public VelocityRotationEdgeCalculator(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double dt, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this(side, soleFrame, rotationParameters.getVelocityEdgeFilterBreakFrequency(), rotationParameters.getStableRotationDirectionThreshold(), rotationParameters.getStableRotationPositionThreshold(), rotationParameters.getStableEdgeWindowSize(), dt, parentRegistry, graphicsListRegistry);
    }

    public VelocityRotationEdgeCalculator(RobotSide side, MovingReferenceFrame soleFrame, DoubleProvider velocityEdgeFilterBreakFrequency, DoubleProvider stableRotationDirectionThreshold, DoubleProvider stableRotationPositionThreshold, IntegerProvider stableEdgeWindowSize, double dt, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this.soleFrame = soleFrame;
        String namePrefix = side.getLowerCaseName() + "Velocity";
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName() + side.getPascalCaseName());
        this.pointOfRotation = new YoFramePoint2D(namePrefix + "PointOfRotation", (ReferenceFrame)soleFrame, registry);
        this.axisOfRotation = new YoFrameVector2D(namePrefix + "AxisOfRotation", (ReferenceFrame)soleFrame, registry);
        parentRegistry.addChild(registry);
        DoubleProvider alpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)velocityEdgeFilterBreakFrequency.getValue(), (double)dt);
        this.filteredPointOfRotation = new AlphaFilteredYoFramePoint2d(namePrefix + "FilteredPointOfRotation", "", registry, alpha, (FrameTuple2DReadOnly)this.pointOfRotation);
        this.filteredAxisOfRotation = new AlphaFilteredYoFrameVector2d(namePrefix + "FilteredAxisOfRotation", "", registry, alpha, (FrameTuple2DReadOnly)this.axisOfRotation);
        this.lineOfRotationInSole = new YoFrameLine2D((YoFramePoint2D)this.filteredPointOfRotation, (YoFrameVector2D)this.filteredAxisOfRotation);
        this.lineOfRotationStandardDeviation = new Line2DStatisticsCalculator(namePrefix + "LineOfRotation", (Line2DReadOnly)this.lineOfRotationInSole, registry);
        this.edgeVisualizer = graphicsListRegistry != null ? new EdgeVisualizer(namePrefix, Color.GREEN, registry, graphicsListRegistry) : null;
        this.stabilityEvaluator = new EdgeVelocityStabilityEvaluator(namePrefix, (FrameLine2DReadOnly)this.lineOfRotationInSole, stableRotationDirectionThreshold, stableRotationPositionThreshold, stableEdgeWindowSize, dt, registry);
        this.reset();
    }

    @Override
    public void reset() {
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.reset();
        }
        this.filteredPointOfRotation.reset();
        this.filteredAxisOfRotation.reset();
        this.lineOfRotationInSole.setToZero();
        this.stabilityEvaluator.reset();
        this.lineOfRotationStandardDeviation.reset();
    }

    @Override
    public boolean compute(FramePoint2DReadOnly measuredCoP) {
        TwistReadOnly soleFrameTwist = this.soleFrame.getTwistOfFrame();
        double omegaSquared = soleFrameTwist.getAngularPart().lengthSquared();
        double omega = EuclidCoreTools.fastSquareRoot((double)omegaSquared);
        this.tempPointOfRotation.setToZero((ReferenceFrame)this.soleFrame);
        this.tempPointOfRotation.cross(soleFrameTwist.getAngularPart(), soleFrameTwist.getLinearPart());
        this.tempPointOfRotation.scale(1.0 / omegaSquared);
        this.pointOfRotation.set((FrameTuple3DReadOnly)this.tempPointOfRotation);
        this.axisOfRotation.set((FrameTuple3DReadOnly)soleFrameTwist.getAngularPart());
        this.axisOfRotation.scale(1.0 / omega);
        if (this.axisOfRotation.dot((FrameVector2DReadOnly)this.filteredAxisOfRotation) < 0.0) {
            this.axisOfRotation.negate();
        }
        this.filteredPointOfRotation.update();
        this.filteredAxisOfRotation.update();
        this.lineOfRotationStandardDeviation.update();
        this.stabilityEvaluator.update();
        if (this.edgeVisualizer != null) {
            this.edgeVisualizer.visualize(true);
            this.edgeVisualizer.updateGraphics((FrameLine2DReadOnly)this.lineOfRotationInSole);
        }
        return this.isRotationEdgeTrusted();
    }

    @Override
    public FrameLine2DReadOnly getLineOfRotation() {
        return this.lineOfRotationInSole;
    }

    @Override
    public boolean isRotationEdgeTrusted() {
        return this.stabilityEvaluator.isEdgeVelocityStable();
    }
}

