/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class KinematicFootRotationDetector
implements FootRotationDetector {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FrameVector2D angularVelocity = new FrameVector2D();
    private final DoubleProvider angularVelocityFilterBreakFrequency;
    private final AlphaFilteredYoFrameVector2d footAngularVelocityFiltered;
    private final YoDouble angularVelocityMagnitude;
    private final DoubleProvider angularVelocityMagnitudeThreshold;
    private final YoBoolean isAngularVelocityPastThreshold;
    private final YoDouble footDropOrLift;
    private final DoubleProvider footDropThreshold;
    private final YoBoolean isFootDropPastThreshold;
    private final YoBoolean isFootRotating;
    private final FrameVector2D normalizedFootAngularVelocity = new FrameVector2D();
    private final FrameVector3D pointingBackwardVector = new FrameVector3D();
    private final MovingReferenceFrame soleFrame;

    public KinematicFootRotationDetector(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double controllerDt, YoRegistry parentRegistry) {
        this.soleFrame = soleFrame;
        String namePrefix = side.getLowerCaseName() + "Kinematic";
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(registry);
        this.angularVelocityFilterBreakFrequency = rotationParameters.getAngularVelocityFilterBreakFrequency();
        this.footAngularVelocityFiltered = new AlphaFilteredYoFrameVector2d(namePrefix + "AngularVelocityFiltered", "", registry, () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.angularVelocityFilterBreakFrequency.getValue(), (double)controllerDt), (ReferenceFrame)soleFrame);
        this.angularVelocityMagnitude = new YoDouble(namePrefix + "AngularVelocityMagnitude", registry);
        this.angularVelocityMagnitudeThreshold = rotationParameters.getAngularVelocityAroundLoRThreshold();
        this.isAngularVelocityPastThreshold = new YoBoolean(namePrefix + "IsAngularVelocityPastThreshold", registry);
        this.footDropOrLift = new YoDouble(namePrefix + "FootDropOrLift", registry);
        this.footDropThreshold = rotationParameters.getFootDropThreshold();
        this.isFootDropPastThreshold = new YoBoolean(namePrefix + "IsFootDropPastThreshold", registry);
        this.isFootRotating = new YoBoolean(namePrefix + "IsRotating", registry);
    }

    @Override
    public void reset() {
        this.footAngularVelocityFiltered.reset();
        this.angularVelocityMagnitude.setToNaN();
        this.footDropOrLift.setToNaN();
        this.isFootRotating.set(false);
        this.isFootDropPastThreshold.set(false);
        this.isAngularVelocityPastThreshold.set(false);
    }

    @Override
    public boolean compute() {
        this.angularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.soleFrame.getTwistOfFrame().getAngularPart());
        this.angularVelocity.changeFrameAndProjectToXYPlane((ReferenceFrame)this.soleFrame);
        this.footAngularVelocityFiltered.update((FrameTuple2DReadOnly)this.angularVelocity);
        this.normalizedFootAngularVelocity.setIncludingFrame((FrameTuple2DReadOnly)this.footAngularVelocityFiltered);
        this.normalizedFootAngularVelocity.normalize();
        this.pointingBackwardVector.setIncludingFrame((ReferenceFrame)this.soleFrame, this.normalizedFootAngularVelocity.getY(), -this.normalizedFootAngularVelocity.getX(), 0.0);
        this.pointingBackwardVector.normalize();
        this.pointingBackwardVector.scale(0.15);
        this.pointingBackwardVector.changeFrame(worldFrame);
        this.footDropOrLift.set(this.pointingBackwardVector.getZ());
        this.angularVelocityMagnitude.set(this.footAngularVelocityFiltered.length());
        this.isFootDropPastThreshold.set(Math.abs(this.footDropOrLift.getDoubleValue()) > Math.abs(this.footDropThreshold.getValue()));
        this.isAngularVelocityPastThreshold.set(this.angularVelocityMagnitude.getDoubleValue() > this.angularVelocityMagnitudeThreshold.getValue());
        this.isFootRotating.set(this.isAngularVelocityPastThreshold.getBooleanValue() && this.isFootDropPastThreshold.getBooleanValue());
        return this.isFootRotating.getBooleanValue();
    }

    @Override
    public boolean isRotating() {
        return this.isFootRotating.getBooleanValue();
    }
}

