/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootCoPHullCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootCoPOccupancyCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootDropCropper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridVisualizer;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class FootholdCropper {
    private static final double defaultThresholdForMeasuredCellActivation = 1.0;
    private static final double defaultMeasuredDecayRatePerSecond = 0.0;
    private final FootholdRotationParameters rotationParameters;
    private final FrameConvexPolygon2D defaultFootPolygon;
    private final YoFrameConvexPolygon2D shrunkenFootPolygon;
    private final YoFrameConvexPolygon2D shrunkenFootPolygonInWorld;
    private final FrameConvexPolygon2D controllerFootPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D controllerFootPolygonInWorld = new FrameConvexPolygon2D();
    private final DoubleProvider distanceFromRotationToCrop;
    private final DoubleProvider minAreaToConsider;
    private final YoBoolean hasEnoughAreaToCrop;
    private final OccupancyGrid measuredCoPOccupancy;
    private final FootCoPOccupancyCalculator footCoPOccupancyGrid;
    private final FootCoPHullCalculator footCoPHullCropper;
    private final FootDropCropper footDropCropper;
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final BooleanProvider doPartialFootholdDetection;
    private final BooleanProvider applyPartialFootholds;
    private final IntegerProvider shrinkMaxLimit;
    private final YoInteger shrinkCounter;
    private final YoEnum<RobotSide> sideOfFootToCrop;
    private final int numberOfFootCornerPoints;
    private final OccupancyGridVisualizer measuredVisualizer;
    private final FrameConvexPolygon2D tempPolygon = new FrameConvexPolygon2D();
    private final FrameLine2D cropLine = new FrameLine2D();
    private final Vector2D shiftVector = new Vector2D();

    public FootholdCropper(String namePrefix, ReferenceFrame soleFrame, List<? extends FramePoint2DReadOnly> defaultContactPoints, FootholdRotationParameters rotationParameters, double dt, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.rotationParameters = rotationParameters;
        this.defaultFootPolygon = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier(defaultContactPoints));
        this.numberOfFootCornerPoints = defaultContactPoints.size();
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        this.shrunkenFootPolygon = new YoFrameConvexPolygon2D(namePrefix + "ShrunkenFootPolygon", "", soleFrame, 20, registry);
        this.shrunkenFootPolygonInWorld = new YoFrameConvexPolygon2D(namePrefix + "ShrunkenFootPolygonInWorld", "", ReferenceFrame.getWorldFrame(), 20, registry);
        this.shrunkenFootPolygon.set((FrameVertex2DSupplier)this.defaultFootPolygon);
        this.measuredCoPOccupancy = new OccupancyGrid(namePrefix + "MeasuredCoPOccupancy", soleFrame, registry);
        double resolution = 0.005;
        this.measuredCoPOccupancy.setCellSize(resolution);
        this.measuredCoPOccupancy.setThresholdForCellOccupancy(1.0);
        this.measuredCoPOccupancy.setOccupancyDecayRate(1.0 - Math.pow(0.0, dt));
        this.footCoPOccupancyGrid = new FootCoPOccupancyCalculator(namePrefix, this.measuredCoPOccupancy, rotationParameters, registry);
        this.footCoPHullCropper = new FootCoPHullCalculator(namePrefix, this.measuredCoPOccupancy, rotationParameters, registry);
        this.footDropCropper = new FootDropCropper(namePrefix, soleFrame, rotationParameters, registry);
        this.sideOfFootToCrop = new YoEnum(namePrefix + "SideOfFootToCrop", registry, RobotSide.class, true);
        this.hasEnoughAreaToCrop = new YoBoolean(namePrefix + "HasEnoughAreaToCrop", registry);
        this.minAreaToConsider = rotationParameters.getMinimumAreaForCropping();
        this.distanceFromRotationToCrop = rotationParameters.getDistanceFromRotationToCrop();
        this.doPartialFootholdDetection = rotationParameters.getDoPartialFootholdDetection();
        this.applyPartialFootholds = rotationParameters.getApplyPartialFootholds();
        this.shrinkCounter = new YoInteger(namePrefix + "ShrinkCounter", registry);
        this.shrinkMaxLimit = rotationParameters.getShrinkMaxLimit();
        if (yoGraphicsListRegistry != null) {
            String listName = this.getClass().getSimpleName();
            YoArtifactPolygon yoShrunkPolygon = new YoArtifactPolygon(namePrefix + "ShrunkPolygon", this.shrunkenFootPolygonInWorld, Color.BLUE, false);
            yoShrunkPolygon.setVisible(true);
            yoGraphicsListRegistry.registerArtifact(listName, (Artifact)yoShrunkPolygon);
            this.measuredVisualizer = null;
        } else {
            this.measuredVisualizer = null;
        }
        parentRegistry.addChild(registry);
    }

    public void reset() {
        this.reset((FrameConvexPolygon2DReadOnly)this.defaultFootPolygon);
    }

    public void reset(FrameConvexPolygon2DReadOnly polygon) {
        this.sideOfFootToCrop.set(null);
        this.shrunkenFootPolygon.set((FrameVertex2DSupplier)polygon);
        this.shrunkenFootPolygonInWorld.clear();
        this.shrinkCounter.set(0);
        this.measuredCoPOccupancy.reset();
        this.footCoPHullCropper.reset();
        this.footCoPOccupancyGrid.reset();
        this.footDropCropper.reset();
        if (this.measuredVisualizer != null) {
            this.measuredVisualizer.update();
        }
    }

    public void update(FramePoint2DReadOnly measuredCoP) {
        this.measuredCoPOccupancy.update();
        if (!measuredCoP.containsNaN()) {
            this.measuredCoPOccupancy.registerPoint(measuredCoP);
        }
        if (this.measuredVisualizer != null) {
            this.measuredVisualizer.update();
        }
    }

    public RobotSide computeSideToCrop(FrameLine2DReadOnly lineOfRotation) {
        this.hasEnoughAreaToCrop.set(this.shrunkenFootPolygon.getArea() > this.minAreaToConsider.getValue());
        RobotSide sideOfFootToCrop = this.getSideToCrop(lineOfRotation);
        if (sideOfFootToCrop != null && this.hasEnoughAreaToCrop.getBooleanValue()) {
            this.sideOfFootToCrop.set((Enum)sideOfFootToCrop);
        } else {
            this.sideOfFootToCrop.set(null);
        }
        return (RobotSide)this.sideOfFootToCrop.getEnumValue();
    }

    private RobotSide getSideToCrop(FrameLine2DReadOnly lineOfRotation) {
        boolean sideIsntBad;
        RobotSide sideOfFootToCropFromOccupancy = this.footCoPOccupancyGrid.computeSideOfFootholdToCrop(lineOfRotation);
        RobotSide sideOfFootToCropFromHull = this.footCoPHullCropper.computeSideOfFootholdToCrop(lineOfRotation);
        RobotSide sideOfFootToCropFromDrop = this.footDropCropper.computeSideOfFootholdToCrop(lineOfRotation);
        if (!this.rotationParameters.getUseCoPOccupancyGridForCropping().getValue()) {
            return sideOfFootToCropFromDrop;
        }
        boolean sidesAreConsistent = sideOfFootToCropFromOccupancy != null && sideOfFootToCropFromHull != null;
        boolean bl = sideIsntBad = sideOfFootToCropFromDrop != null && sideOfFootToCropFromDrop == sideOfFootToCropFromOccupancy;
        if ((sidesAreConsistent &= sideOfFootToCropFromOccupancy == sideOfFootToCropFromHull) && sideIsntBad) {
            return sideOfFootToCropFromOccupancy;
        }
        return null;
    }

    public void computeShrunkenFoothold(FrameLine2DReadOnly lineOfRotation, RobotSide sideOfFootToCrop) {
        if (sideOfFootToCrop == null) {
            return;
        }
        this.tempPolygon.setIncludingFrame((FrameVertex2DSupplier)this.shrunkenFootPolygon);
        this.shiftLineNormally(lineOfRotation, (FrameLine2DBasics)this.cropLine, sideOfFootToCrop.getOppositeSide(), this.distanceFromRotationToCrop.getValue());
        this.convexPolygonTools.cutPolygonWithLine((FrameLine2DReadOnly)this.cropLine, (FixedFrameConvexPolygon2DBasics)this.tempPolygon, sideOfFootToCrop);
        this.shrunkenFootPolygon.set((FrameVertex2DSupplier)this.tempPolygon);
    }

    private void shiftLineNormally(FrameLine2DReadOnly lineToShift, FrameLine2DBasics shiftedLineToPack, RobotSide sideToShift, double distanceToShift) {
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineToShift.getDirection(), (Vector2DBasics)this.shiftVector);
        if (sideToShift == RobotSide.RIGHT) {
            this.shiftVector.negate();
        }
        this.shiftVector.scale(distanceToShift);
        shiftedLineToPack.setIncludingFrame(lineToShift);
        shiftedLineToPack.getPoint().add((Tuple2DReadOnly)this.shiftVector);
    }

    public boolean shouldApplyShrunkenFoothold() {
        if (!this.doPartialFootholdDetection.getValue()) {
            this.shrunkenFootPolygon.set((FrameVertex2DSupplier)this.defaultFootPolygon);
            return false;
        }
        return this.shrinkCounter.getIntegerValue() < this.shrinkMaxLimit.getValue();
    }

    public boolean applyShrunkenFoothold(YoPlaneContactState contactStateToModify) {
        this.controllerFootPolygon.setIncludingFrame((FrameVertex2DSupplier)this.getShrunkenFootPolygon());
        ConvexPolygonTools.limitVerticesConservative((FixedFrameConvexPolygon2DBasics)this.controllerFootPolygon, (int)this.numberOfFootCornerPoints);
        this.controllerFootPolygonInWorld.setIncludingFrame((FrameVertex2DSupplier)this.controllerFootPolygon);
        this.controllerFootPolygonInWorld.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        this.shrunkenFootPolygonInWorld.set((FrameVertex2DSupplier)this.controllerFootPolygonInWorld);
        if (this.applyPartialFootholds.getValue()) {
            int i;
            List<YoContactPoint> contactPoints = contactStateToModify.getContactPoints();
            for (i = 0; i < this.controllerFootPolygon.getNumberOfVertices(); ++i) {
                YoContactPoint contactPoint = contactPoints.get(i);
                contactPoint.set((FrameTuple2DReadOnly)this.controllerFootPolygon.getVertex(i));
                contactPoint.setInContact(true);
            }
            while (i < contactPoints.size()) {
                contactPoints.get(i).setInContact(false);
                ++i;
            }
        }
        this.shrinkCounter.increment();
        return true;
    }

    public FrameConvexPolygon2DReadOnly getShrunkenFootPolygon() {
        return this.shrunkenFootPolygon;
    }
}

