/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class FootDropCropper {
    private final YoDouble footDropOrLift;
    private final YoDouble footDropOrLiftDelta;
    private final FrameVector3D pointingBackwardVector = new FrameVector3D();
    private final DoubleProvider footDropThreshold;
    private final YoDouble dropAtStartOfMeasurement;
    private final YoEnum<RobotSide> sideOfFootToCrop;
    private final ReferenceFrame soleFrame;

    public FootDropCropper(String namePrefix, ReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, YoRegistry registry) {
        this.soleFrame = soleFrame;
        this.footDropThreshold = rotationParameters.getFootDropThresholdForCrop();
        this.dropAtStartOfMeasurement = new YoDouble(namePrefix + "CropDropAtStartOfMeasurement", registry);
        this.footDropOrLift = new YoDouble(namePrefix + "CropFootDropOrLift", registry);
        this.footDropOrLiftDelta = new YoDouble(namePrefix + "CropFootDropOrLiftDelta", registry);
        this.sideOfFootToCrop = new YoEnum(namePrefix + "CropDropSideOfFootToCrop", registry, RobotSide.class, true);
    }

    public void reset() {
        this.sideOfFootToCrop.set(null);
        this.footDropOrLift.setToNaN();
        this.dropAtStartOfMeasurement.setToNaN();
    }

    public RobotSide computeSideOfFootholdToCrop(FrameLine2DReadOnly lineOfRotation) {
        this.pointingBackwardVector.setIncludingFrame(lineOfRotation.getReferenceFrame(), lineOfRotation.getDirection().getY(), -lineOfRotation.getDirection().getX(), 0.0);
        this.pointingBackwardVector.changeFrame(this.soleFrame);
        this.pointingBackwardVector.setZ(0.0);
        this.pointingBackwardVector.normalize();
        this.pointingBackwardVector.scale(0.15);
        this.pointingBackwardVector.changeFrame(ReferenceFrame.getWorldFrame());
        if (Double.isNaN(this.dropAtStartOfMeasurement.getDoubleValue())) {
            this.dropAtStartOfMeasurement.set(this.pointingBackwardVector.getZ());
        }
        this.footDropOrLift.set(this.pointingBackwardVector.getZ());
        this.footDropOrLiftDelta.set(this.footDropOrLift.getValue() - this.dropAtStartOfMeasurement.getDoubleValue());
        if (this.footDropOrLiftDelta.getDoubleValue() < -this.footDropThreshold.getValue()) {
            this.sideOfFootToCrop.set((Enum)RobotSide.RIGHT);
        } else if (this.footDropOrLiftDelta.getDoubleValue() > this.footDropThreshold.getValue()) {
            this.sideOfFootToCrop.set((Enum)RobotSide.LEFT);
        } else {
            this.sideOfFootToCrop.set(null);
        }
        return (RobotSide)this.sideOfFootToCrop.getEnumValue();
    }
}

