/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class FootCoPHullCalculator {
    private final YoDouble areaOnRightSideOfLine;
    private final YoDouble areaOnLeftSideOfLine;
    private final DoubleProvider areaRatioThreshold;
    private final OccupancyGrid occupancyGrid;
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final YoEnum<RobotSide> sideOfFootToCrop;
    private FrameConvexPolygon2D convexHullOfCoPs = new FrameConvexPolygon2D();
    private FrameConvexPolygon2D leftSideCut = new FrameConvexPolygon2D();
    private FrameConvexPolygon2D rightSideCut = new FrameConvexPolygon2D();

    public FootCoPHullCalculator(String namePrefix, OccupancyGrid occupancyGrid, FootholdRotationParameters rotationParameters, YoRegistry parentRegistry) {
        this.occupancyGrid = occupancyGrid;
        String name = this.getClass().getSimpleName();
        YoRegistry registry = new YoRegistry(namePrefix + name);
        this.sideOfFootToCrop = new YoEnum(namePrefix + "HullSideOfFootToCrop", registry, RobotSide.class, true);
        this.areaRatioThreshold = rotationParameters.getCopHullAreaRatioThreshold();
        this.areaOnRightSideOfLine = new YoDouble(namePrefix + "AreaOnRightSideOfLine", registry);
        this.areaOnLeftSideOfLine = new YoDouble(namePrefix + "AreaOnLeftSideOfLine", registry);
        this.reset();
        parentRegistry.addChild(registry);
    }

    public RobotSide computeSideOfFootholdToCrop(FrameLine2DReadOnly lineOfRotation) {
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)this.occupancyGrid, (FrameConvexPolygon2D)this.convexHullOfCoPs);
        this.leftSideCut.setIncludingFrame((FrameVertex2DSupplier)this.convexHullOfCoPs);
        this.rightSideCut.setIncludingFrame((FrameVertex2DSupplier)this.convexHullOfCoPs);
        this.convexPolygonTools.cutPolygonWithLine(lineOfRotation, (FixedFrameConvexPolygon2DBasics)this.leftSideCut, RobotSide.LEFT);
        this.convexPolygonTools.cutPolygonWithLine(lineOfRotation, (FixedFrameConvexPolygon2DBasics)this.rightSideCut, RobotSide.RIGHT);
        this.areaOnLeftSideOfLine.set(this.rightSideCut.getArea());
        this.areaOnRightSideOfLine.set(this.leftSideCut.getArea());
        if (this.areaOnLeftSideOfLine.getDoubleValue() / this.areaOnRightSideOfLine.getDoubleValue() > this.areaRatioThreshold.getValue()) {
            this.sideOfFootToCrop.set((Enum)RobotSide.RIGHT);
        } else if (this.areaOnRightSideOfLine.getDoubleValue() / this.areaOnLeftSideOfLine.getDoubleValue() > this.areaRatioThreshold.getValue()) {
            this.sideOfFootToCrop.set((Enum)RobotSide.LEFT);
        } else {
            this.sideOfFootToCrop.set(null);
        }
        return (RobotSide)this.sideOfFootToCrop.getEnumValue();
    }

    public void reset() {
        this.sideOfFootToCrop.set(null);
        this.areaOnLeftSideOfLine.setToNaN();
        this.areaOnRightSideOfLine.setToNaN();
    }
}

