/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.awt.Color;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class EdgeVisualizer {
    private static final double LineVizWidth = 0.1;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FrameLine3DBasics tempLineOfRotationInWorld = new FrameLine3D();
    private final YoBoolean visualize;
    private final YoFramePoint2D linePointA;
    private final YoFramePoint2D linePointB;

    public EdgeVisualizer(String prefix, Color color, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.visualize = new YoBoolean(prefix + "_Visualize", registry);
        this.linePointA = new YoFramePoint2D(prefix + "_FootRotationPointA", worldFrame, registry);
        this.linePointB = new YoFramePoint2D(prefix + "_FootRotationPointB", worldFrame, registry);
        YoArtifactLineSegment2d lineArtifact = new YoArtifactLineSegment2d(prefix + "_LineOfRotation", this.linePointA, this.linePointB, color, 0.005, 0.01);
        graphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)lineArtifact);
    }

    public void visualize(boolean visualize) {
        this.visualize.set(visualize);
    }

    public void reset() {
        this.linePointA.setToNaN();
        this.linePointB.setToNaN();
    }

    public void updateGraphics(FrameLine2DReadOnly lineOfRotation) {
        if (this.visualize.getBooleanValue()) {
            this.tempLineOfRotationInWorld.setToZero(lineOfRotation.getReferenceFrame());
            this.tempLineOfRotationInWorld.set(lineOfRotation);
            this.tempLineOfRotationInWorld.changeFrame(ReferenceFrame.getWorldFrame());
            this.linePointA.set((FrameTuple3DReadOnly)this.tempLineOfRotationInWorld.getDirection());
            this.linePointA.scale(-0.05);
            this.linePointA.add(this.tempLineOfRotationInWorld.getPointX(), this.tempLineOfRotationInWorld.getPointY());
            this.linePointB.set((FrameTuple3DReadOnly)this.tempLineOfRotationInWorld.getDirection());
            this.linePointB.scale(0.05);
            this.linePointB.add(this.tempLineOfRotationInWorld.getPointX(), this.tempLineOfRotationInWorld.getPointY());
        } else {
            this.reset();
        }
    }
}

