/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridTools;
import us.ihmc.robotics.occupancyGrid.OccupancyGridVisualizer;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class CropVerifier {
    private final OccupancyGrid occupancyGrid;
    private final YoDouble perpendicularCoPError;
    private final BooleanProvider useCoPOccupancyGridForCropping;
    private final IntegerProvider numberOfCellsThreshold;
    private final DoubleProvider perpendicularCopErrorThreshold;
    private final DoubleProvider distanceFromLineToComputeDesiredCoPOccupancy;
    private final YoInteger numberOfCellsOccupiedOnCropSide;
    private final YoBoolean desiredCopOnCorrectSide;
    private final YoBoolean perpendicularCopErrorAboveThreshold;
    private final YoBoolean enoughDesiredCopOnCropSide;
    private final OccupancyGridVisualizer visualizer;
    private final YoEnum<RobotSide> previousSideToCrop;
    private final YoDouble maxFootPitch;
    private final YoDouble minFootPitch;
    private final YoDouble maxFootRoll;
    private final YoDouble minFootRoll;
    private final ReferenceFrame soleFrame;
    private final FrameQuaternion footOrientation = new FrameQuaternion();

    public CropVerifier(String namePrefix, ReferenceFrame soleFrame, double resolution, FootholdRotationParameters rotationParameters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.soleFrame = soleFrame;
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.occupancyGrid = new OccupancyGrid(namePrefix + "DesiredCoPOccupancy", soleFrame, registry);
        this.occupancyGrid.setCellSize(resolution);
        this.perpendicularCoPError = new YoDouble(namePrefix + "PerpendicularCopError", registry);
        this.perpendicularCopErrorThreshold = rotationParameters.getPerpendicularCoPErrorThreshold();
        this.distanceFromLineToComputeDesiredCoPOccupancy = rotationParameters.getDistanceFromLineToComputeDesiredCoPOccupancy();
        this.useCoPOccupancyGridForCropping = rotationParameters.getUseCoPOccupancyGridForCropping();
        this.perpendicularCopErrorAboveThreshold = new YoBoolean(namePrefix + "PerpendicularCopErrorAboveThreshold", registry);
        this.enoughDesiredCopOnCropSide = new YoBoolean(namePrefix + "EnoughDesiredCopOnCropSide", registry);
        this.numberOfCellsThreshold = rotationParameters.getNumberOfDesiredCopsOnCropSide();
        this.numberOfCellsOccupiedOnCropSide = new YoInteger(namePrefix + "NumberOfCellsOccupiedOnCropSide", registry);
        this.previousSideToCrop = new YoEnum(namePrefix + "PreviousSideToCrop", registry, RobotSide.class, true);
        this.desiredCopOnCorrectSide = new YoBoolean(namePrefix + "DesiredCopOnCorrectSide", registry);
        this.maxFootPitch = new YoDouble(namePrefix + "MaxFootPitch", registry);
        this.minFootPitch = new YoDouble(namePrefix + "MinFootPitch", registry);
        this.maxFootRoll = new YoDouble(namePrefix + "MaxFootRoll", registry);
        this.minFootRoll = new YoDouble(namePrefix + "MinFootRoll", registry);
        this.visualizer = yoGraphicsListRegistry != null ? new OccupancyGridVisualizer(namePrefix + "DesiredCoP", this.occupancyGrid, 50, YoAppearance.Blue(), registry, yoGraphicsListRegistry) : null;
        this.reset();
        parentRegistry.addChild(registry);
    }

    public void reset() {
        this.occupancyGrid.reset();
        this.previousSideToCrop.set(null);
        this.maxFootPitch.set(0.0);
        this.minFootPitch.set(0.0);
        this.maxFootRoll.set(0.0);
        this.minFootRoll.set(0.0);
        if (this.visualizer != null) {
            this.visualizer.update();
        }
    }

    public void initialize() {
        this.footOrientation.setToZero(this.soleFrame);
        this.footOrientation.changeFrame(ReferenceFrame.getWorldFrame());
        this.maxFootPitch.set(this.footOrientation.getPitch());
        this.minFootPitch.set(this.footOrientation.getPitch());
        this.maxFootPitch.set(this.footOrientation.getRoll());
        this.minFootPitch.set(this.footOrientation.getRoll());
    }

    public void update(FramePoint2DReadOnly desiredCoP) {
        if (!desiredCoP.containsNaN()) {
            this.occupancyGrid.registerPoint(desiredCoP);
        }
        if (this.visualizer != null) {
            this.visualizer.update();
        }
    }

    public boolean verifyFootholdCrop(FramePoint2DReadOnly desiredCoP, RobotSide sideToCrop, FrameLine2DReadOnly lineOfRotation) {
        boolean shouldCrop;
        this.perpendicularCoPError.set(lineOfRotation.distance(desiredCoP));
        this.perpendicularCopErrorAboveThreshold.set(this.perpendicularCoPError.getDoubleValue() > this.perpendicularCopErrorThreshold.getValue());
        this.desiredCopOnCorrectSide.set(lineOfRotation.isPointOnSideOfLine(desiredCoP, sideToCrop == RobotSide.LEFT));
        this.numberOfCellsOccupiedOnCropSide.set(OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)this.occupancyGrid, (FrameLine2DReadOnly)lineOfRotation, (RobotSide)sideToCrop, (double)this.distanceFromLineToComputeDesiredCoPOccupancy.getValue()));
        this.enoughDesiredCopOnCropSide.set(this.numberOfCellsOccupiedOnCropSide.getValue() > this.numberOfCellsThreshold.getValue());
        boolean bl = shouldCrop = this.enoughDesiredCopOnCropSide.getBooleanValue() || !this.useCoPOccupancyGridForCropping.getValue();
        if (this.perpendicularCopErrorAboveThreshold.getBooleanValue() && shouldCrop) {
            this.previousSideToCrop.set((Enum)sideToCrop);
            return true;
        }
        return false;
    }
}

