/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold;

import java.util.EnumMap;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.KinematicFootRotationDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.VelocityFootRotationDetector;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoEnum;

public class CombinedFootRotationDetector
implements FootRotationDetector {
    private final YoEnum<RotationDetectorType> rotationDetectorType;
    private final EnumMap<RotationDetectorType, FootRotationDetector> rotationDetectors = new EnumMap(RotationDetectorType.class);
    private final YoBoolean isRotating;

    public CombinedFootRotationDetector(RobotSide side, MovingReferenceFrame soleFrame, FootholdRotationParameters rotationParameters, double dt, YoRegistry registry) {
        VelocityFootRotationDetector velocityRotationDetector = new VelocityFootRotationDetector(side, soleFrame, rotationParameters, dt, registry);
        KinematicFootRotationDetector kinematicRotationDetector = new KinematicFootRotationDetector(side, soleFrame, rotationParameters, dt, registry);
        this.rotationDetectors.put(RotationDetectorType.KINEMATIC, kinematicRotationDetector);
        this.rotationDetectors.put(RotationDetectorType.VELOCITY, velocityRotationDetector);
        this.rotationDetectorType = new YoEnum(side.getCamelCaseName() + "RotationDetectorType", registry, RotationDetectorType.class);
        this.rotationDetectorType.set((Enum)RotationDetectorType.VELOCITY);
        this.isRotating = new YoBoolean(side.getLowerCaseName() + "IsRotating", registry);
    }

    @Override
    public void reset() {
        this.isRotating.set(false);
        for (RotationDetectorType type : RotationDetectorType.values) {
            this.rotationDetectors.get((Object)type).reset();
        }
    }

    @Override
    public boolean compute() {
        boolean rotationDetected;
        if (this.rotationDetectorType.getEnumValue() == RotationDetectorType.ANY) {
            rotationDetected = false;
            for (RotationDetectorType type : RotationDetectorType.values) {
                if (!this.rotationDetectors.get((Object)type).compute()) continue;
                rotationDetected = true;
            }
        } else if (this.rotationDetectorType.getEnumValue() == RotationDetectorType.KINEMATIC_AND_VELOCITY) {
            rotationDetected = this.rotationDetectors.get((Object)RotationDetectorType.KINEMATIC).compute();
            rotationDetected |= this.rotationDetectors.get((Object)RotationDetectorType.VELOCITY).compute();
        } else {
            rotationDetected = this.rotationDetectors.get(this.rotationDetectorType.getEnumValue()).compute();
        }
        this.isRotating.set(rotationDetected);
        return rotationDetected;
    }

    @Override
    public boolean isRotating() {
        return this.isRotating.getBooleanValue();
    }

    private static enum RotationDetectorType {
        GEOMETRIC,
        KINEMATIC,
        VELOCITY,
        ANY,
        KINEMATIC_AND_VELOCITY;

        static final RotationDetectorType[] values;

        static {
            values = new RotationDetectorType[]{KINEMATIC, VELOCITY};
        }
    }
}

