/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.contactPoints;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.robotSide.RobotSegment;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ContactStateRhoRamping<T extends RobotSegment> {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final List<YoContactPoint> contactPoints;
    private final YoPlaneContactState contactState;
    private final boolean[] contactPointRhoRampingActivated;
    private final YoDouble rhoInitial;
    private final YoDouble rhoFinal;
    private final YoDouble rhoCurrent;
    private final YoDouble timeInTrajectory;
    private final YoDouble duration;
    private final YoPolynomial polynomial;

    public ContactStateRhoRamping(T robotSide, YoPlaneContactState contactState, double finalRhoWeight, YoRegistry parentRegistry) {
        this.contactState = contactState;
        this.contactPoints = contactState.getContactPoints();
        this.contactPointRhoRampingActivated = new boolean[this.contactPoints.size()];
        String prefix = robotSide.getCamelCaseNameForStartOfExpression() + this.name;
        this.registry = new YoRegistry(prefix);
        this.rhoInitial = new YoDouble(prefix + "rhoInitial", this.registry);
        this.rhoFinal = new YoDouble(prefix + "rhoFinal", this.registry);
        this.rhoCurrent = new YoDouble(prefix + "rhoCurrent", this.registry);
        this.timeInTrajectory = new YoDouble(prefix + "timeInTrajectory", this.registry);
        this.duration = new YoDouble(prefix + "duration", this.registry);
        this.polynomial = new YoPolynomial(prefix + "rhoWeightTraj", 4, this.registry);
        this.rhoInitial.set(1.0);
        this.rhoFinal.set(finalRhoWeight);
        parentRegistry.addChild(this.registry);
    }

    public void initialize(double duration) {
        this.duration.set(duration);
        this.timeInTrajectory.set(0.0);
        this.polynomial.setCubicInitialPositionThreeFinalConditions(0.0, duration, this.rhoInitial.getDoubleValue(), this.rhoFinal.getDoubleValue(), 0.0, 0.0);
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            if (yoContactPoint.isInContact()) {
                this.contactPointRhoRampingActivated[i] = false;
                continue;
            }
            this.contactPointRhoRampingActivated[i] = true;
            yoContactPoint.setInContact(true);
        }
        this.contactState.updateInContact();
    }

    public void update(double time) {
        this.timeInTrajectory.set(time);
        this.polynomial.compute(this.timeInTrajectory.getDoubleValue());
        double rhoWeight = MathTools.clamp((double)this.polynomial.getValue(), (double)this.rhoFinal.getDoubleValue(), (double)this.rhoInitial.getDoubleValue());
        this.rhoCurrent.set(rhoWeight);
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            if (!this.contactPointRhoRampingActivated[i]) continue;
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            this.contactState.setRhoWeight(yoContactPoint, this.rhoCurrent.getDoubleValue());
        }
    }

    public boolean isDone() {
        return this.timeInTrajectory.getDoubleValue() >= this.duration.getDoubleValue();
    }

    public void resetContactState() {
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            this.contactState.setRhoWeight(yoContactPoint, Double.NaN);
        }
    }
}

