/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot.contactPoints;

import java.util.HashMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ContactStateInterpolator {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final List<YoContactPoint> contactPoints;
    private final FrameLineSegment2D contactLine2D = new FrameLineSegment2D();
    private final YoPlaneContactState contactState;
    private final boolean[] contactPointInterpolationActivated;
    private final HashMap<YoContactPoint, FramePoint2D> initialPositions = new HashMap();
    private final HashMap<YoContactPoint, FramePoint2D> finalPositions = new HashMap();
    private final FramePoint2D contactPointPosition = new FramePoint2D();
    private final ReferenceFrame planeFrame;
    private final YoDouble alpha;
    private final YoDouble timeInTrajectory;
    private final YoDouble duration;
    private final double dt;

    public ContactStateInterpolator(RobotSide robotSide, YoPlaneContactState contactState, double dt, YoRegistry parentRegistry) {
        this.contactState = contactState;
        this.dt = dt;
        String prefix = robotSide.getCamelCaseNameForStartOfExpression() + this.name;
        this.registry = new YoRegistry(prefix);
        this.contactPoints = contactState.getContactPoints();
        this.contactPointInterpolationActivated = new boolean[this.contactPoints.size()];
        this.planeFrame = contactState.getPlaneFrame();
        this.alpha = new YoDouble(prefix + "alpha", this.registry);
        this.timeInTrajectory = new YoDouble(prefix + "timeInTrajectory", this.registry);
        this.duration = new YoDouble(prefix + "duration", this.registry);
        for (YoContactPoint yoContactPoint : this.contactPoints) {
            this.initialPositions.put(yoContactPoint, new FramePoint2D());
            this.finalPositions.put(yoContactPoint, new FramePoint2D((FrameTuple3DReadOnly)yoContactPoint));
        }
        parentRegistry.addChild(this.registry);
    }

    public void initialize(double duration, FrameLineSegment3D contactLine) {
        contactLine.changeFrame(this.planeFrame);
        this.contactLine2D.setIncludingFrame((FrameLineSegment3DReadOnly)contactLine);
        this.duration.set(duration);
        this.timeInTrajectory.set(0.0);
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            if (yoContactPoint.isInContact()) {
                this.contactPointInterpolationActivated[i] = false;
                continue;
            }
            this.contactPointInterpolationActivated[i] = true;
            this.contactPointPosition.setIncludingFrame((FrameTuple3DReadOnly)yoContactPoint);
            this.contactPointPosition.changeFrame(this.planeFrame);
            FramePoint2D initialPositionToPack = this.initialPositions.get(yoContactPoint);
            this.contactLine2D.orthogonalProjection((FramePoint2DReadOnly)this.contactPointPosition, (FramePoint2DBasics)initialPositionToPack);
            yoContactPoint.setInContact(true);
        }
        this.contactState.updateInContact();
    }

    public void update() {
        this.timeInTrajectory.add(this.dt);
        this.alpha.set(this.timeInTrajectory.getDoubleValue() / this.duration.getDoubleValue());
        this.alpha.set(MathTools.clamp((double)this.alpha.getDoubleValue(), (double)0.0, (double)1.0));
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            if (!this.contactPointInterpolationActivated[i]) continue;
            FramePoint2D initialPosition = this.initialPositions.get(yoContactPoint);
            FramePoint2D finalPosition = this.finalPositions.get(yoContactPoint);
            this.contactPointPosition.changeFrame(this.planeFrame);
            this.contactPointPosition.interpolate((FrameTuple2DReadOnly)initialPosition, (FrameTuple2DReadOnly)finalPosition, this.alpha.getDoubleValue());
            this.contactPointPosition.changeFrame(yoContactPoint.getReferenceFrame());
            yoContactPoint.set((FrameTuple2DReadOnly)this.contactPointPosition);
        }
    }

    public boolean isDone() {
        return this.timeInTrajectory.getDoubleValue() >= this.duration.getDoubleValue();
    }

    public void resetContactState() {
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint yoContactPoint = this.contactPoints.get(i);
            FramePoint2D finalPosition = this.finalPositions.get(yoContactPoint);
            this.contactPointPosition.setIncludingFrame((FrameTuple2DReadOnly)finalPosition);
            this.contactPointPosition.changeFrame(yoContactPoint.getReferenceFrame());
            yoContactPoint.set((FrameTuple2DReadOnly)this.contactPointPosition);
        }
    }
}

