/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.configurations.AnkleIKSolver;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.ScrewTools;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class UnloadedAnkleControlModule {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final JointDesiredOutputList jointDesiredOutputList;
    private final JointspaceAccelerationCommand accelerationCommand = new JointspaceAccelerationCommand();
    private final RigidBodyBasics foot;
    private final MovingReferenceFrame shinFrame;
    private final BooleanParameter useAnkleIKModule;
    private final YoBoolean enabled = new YoBoolean("UnloadedAnkleControlModuleEnabled", this.registry);
    private final AnkleIKSolver ankleIKSolver;
    private final DMatrixRMaj jointAngles = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj jointVelocities = new DMatrixRMaj(1, 1);
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    private final FrameVector3D shinAngularVelocity = new FrameVector3D();
    private final FramePoint3D controlFramePosition = new FramePoint3D();
    private final FrameQuaternion controlFrameOrientation = new FrameQuaternion();
    private final RotationMatrix rotationMatrix = new RotationMatrix();
    private final FrameVector3D footAngularVelocityInShin = new FrameVector3D();

    public UnloadedAnkleControlModule(FullHumanoidRobotModel fullRobotModel, RobotSide robotSide, AnkleIKSolver ankleIKSolver, YoRegistry parentRegistry) {
        this.ankleIKSolver = ankleIKSolver;
        this.useAnkleIKModule = new BooleanParameter("UseAnkleIKModule" + robotSide.getPascalCaseName(), this.registry, false);
        this.foot = fullRobotModel.getFoot((Enum)robotSide);
        RigidBodyBasics shin = ScrewTools.goUpBodyChain((RigidBodyBasics)this.foot, (int)ankleIKSolver.getNumberOfJoints());
        this.shinFrame = shin.getParentJoint().getFrameAfterJoint();
        OneDoFJointBasics[] ankleJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)shin, (RigidBodyBasics)this.foot), OneDoFJointBasics.class);
        this.jointDesiredOutputList = new JointDesiredOutputList((OneDoFJointReadOnly[])ankleJoints);
        parentRegistry.addChild(this.registry);
    }

    public void compute(FootControlModule.ConstraintType currentConstraintType, AbstractFootControlState currentState) {
        boolean footIsInAir = !currentConstraintType.isLoadBearing();
        this.enabled.set(this.useAnkleIKModule.getValue() && footIsInAir);
        if (!this.enabled.getBooleanValue()) {
            this.jointDesiredOutputList.clear();
            this.accelerationCommand.clear();
            return;
        }
        SpatialFeedbackControlCommand feedbackControlCommand = currentState.getFeedbackControlCommand();
        if (feedbackControlCommand.getEndEffector().hashCode() != this.foot.hashCode()) {
            throw new RuntimeException("Something got messed up. Expecting a command for " + this.foot.getName());
        }
        feedbackControlCommand.getControlFramePoseIncludingFrame((FramePoint3DBasics)this.controlFramePosition, (FrameQuaternionBasics)this.controlFrameOrientation);
        this.controlFrameOrientation.changeFrame((ReferenceFrame)this.foot.getParentJoint().getFrameAfterJoint());
        this.rotationMatrix.set((Orientation3DReadOnly)this.controlFrameOrientation);
        if (!this.rotationMatrix.isIdentity()) {
            throw new RuntimeException("The foot control frame can not be rotated with respect to the ankle when using this module.");
        }
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)feedbackControlCommand.getReferenceOrientation());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackControlCommand.getReferenceAngularVelocity());
        this.desiredOrientation.changeFrame((ReferenceFrame)this.shinFrame);
        this.desiredAngularVelocity.changeFrame((ReferenceFrame)this.shinFrame);
        this.shinAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.shinFrame.getTwistOfFrame().getAngularPart());
        this.shinAngularVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.desiredAngularVelocity);
        this.footAngularVelocityInShin.setToZero((ReferenceFrame)this.shinFrame);
        this.footAngularVelocityInShin.sub((FrameTuple3DReadOnly)this.desiredAngularVelocity, (FrameTuple3DReadOnly)this.shinAngularVelocity);
        this.ankleIKSolver.computeAngles((QuaternionReadOnly)this.desiredOrientation, this.jointAngles);
        this.ankleIKSolver.computeVelocities((Vector3DReadOnly)this.footAngularVelocityInShin, this.jointAngles, this.jointVelocities);
        for (int jointIdx = 0; jointIdx < this.jointDesiredOutputList.getNumberOfJointsWithDesiredOutput(); ++jointIdx) {
            this.jointDesiredOutputList.getJointDesiredOutput(jointIdx).setDesiredPosition(this.jointAngles.get(jointIdx));
            this.jointDesiredOutputList.getJointDesiredOutput(jointIdx).setDesiredVelocity(this.jointVelocities.get(jointIdx));
        }
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return this.accelerationCommand;
    }

    public JointDesiredOutputList getJointDesiredOutputList() {
        return this.jointDesiredOutputList;
    }
}

