/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import us.ihmc.commonWalkingControlModules.configurations.ToeSlippingDetectorParameters;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ToeSlippingDetector {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final YoDouble alpha;
    private final AlphaFilteredYoVariable toeForceFiltered;
    private final AlphaFilteredYoFrameVector toeLinearVelocityFiltered;
    private final YoFramePoint3D initialToePosition;
    private final YoDouble toeSlippageDistance;
    private final YoDouble forceMagnitudeThreshold;
    private final YoDouble velocityThreshold;
    private final YoDouble slippageDistanceThreshold;
    private final YoBoolean isToeSlipping;
    private final double dt;
    private final RigidBodyBasics foot;
    private final FootSwitchInterface footSwitch;
    private final FramePoint3D toeContactPointPosition = new FramePoint3D();
    private final Wrench footWrench = new Wrench();
    private final Twist footTwist = new Twist();
    private final FrameVector3D toeLinearVelocity = new FrameVector3D();
    private final FramePoint3D currentToePosition = new FramePoint3D();

    public ToeSlippingDetector(String namePrefix, double controlDT, RigidBodyBasics foot, FootSwitchInterface footSwitch, YoRegistry parentRegistry) {
        this.dt = controlDT;
        this.foot = foot;
        this.footSwitch = footSwitch;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.alpha = new YoDouble(namePrefix + "AlphaFilter", this.registry);
        this.toeForceFiltered = new AlphaFilteredYoVariable(namePrefix + "ToeForceFiltered", "", this.registry, (DoubleProvider)this.alpha);
        this.toeLinearVelocityFiltered = AlphaFilteredYoFrameVector.createAlphaFilteredYoFrameVector((String)(namePrefix + "ToeLinearVelocityFiltered"), (String)"", (YoRegistry)this.registry, (DoubleProvider)this.alpha, (ReferenceFrame)worldFrame);
        this.initialToePosition = new YoFramePoint3D(namePrefix + "ToeInitial", worldFrame, this.registry);
        this.toeSlippageDistance = new YoDouble(namePrefix + "ToeSlippageDistance", this.registry);
        this.forceMagnitudeThreshold = new YoDouble(namePrefix + "ForceMagnitudeThreshold", this.registry);
        this.velocityThreshold = new YoDouble(namePrefix + "VelocityThreshold", this.registry);
        this.slippageDistanceThreshold = new YoDouble(namePrefix + "SlippageDistanceThreshold", this.registry);
        this.isToeSlipping = new YoBoolean(namePrefix + "IsToeSlipping", this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void configure(ToeSlippingDetectorParameters parameters) {
        this.forceMagnitudeThreshold.set(parameters.getForceMagnitudeThreshold());
        this.velocityThreshold.set(parameters.getVelocityThreshold());
        this.slippageDistanceThreshold.set(parameters.getSlippageDistanceThreshold());
        this.alpha.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)parameters.getFilterBreakFrequency(), (double)this.dt));
    }

    public void initialize(FramePoint3D toeContactPointPosition) {
        this.toeContactPointPosition.setIncludingFrame((FrameTuple3DReadOnly)toeContactPointPosition);
        this.toeContactPointPosition.changeFrame((ReferenceFrame)this.foot.getBodyFixedFrame());
        this.initialToePosition.setMatchingFrame((FrameTuple3DReadOnly)toeContactPointPosition);
    }

    public void clear() {
        this.toeContactPointPosition.setToNaN(worldFrame);
        this.currentToePosition.setToNaN(worldFrame);
        this.toeForceFiltered.setToNaN();
        this.toeForceFiltered.reset();
        this.toeLinearVelocityFiltered.setToNaN();
        this.toeLinearVelocityFiltered.reset();
        this.isToeSlipping.set(false);
    }

    public void update() {
        this.footSwitch.computeAndPackFootWrench(this.footWrench);
        this.toeForceFiltered.update(this.footWrench.getLinearPart().length());
        this.foot.getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.footTwist);
        this.footTwist.getLinearVelocityAt((FramePoint3DReadOnly)this.toeContactPointPosition, (FrameVector3DBasics)this.toeLinearVelocity);
        this.toeLinearVelocity.changeFrame(worldFrame);
        this.toeLinearVelocityFiltered.update((FrameTuple3DReadOnly)this.toeLinearVelocity);
        this.currentToePosition.setIncludingFrame((FrameTuple3DReadOnly)this.toeContactPointPosition);
        this.currentToePosition.changeFrame(worldFrame);
        double distance = this.initialToePosition.distance((FramePoint3DReadOnly)this.currentToePosition);
        this.toeSlippageDistance.set(distance);
        if (this.toeForceFiltered.getDoubleValue() > this.forceMagnitudeThreshold.getDoubleValue()) {
            this.isToeSlipping.set(false);
        } else if (this.toeLinearVelocityFiltered.length() < this.velocityThreshold.getDoubleValue()) {
            this.isToeSlipping.set(false);
        } else if (this.toeSlippageDistance.getDoubleValue() < this.slippageDistanceThreshold.getDoubleValue()) {
            this.isToeSlipping.set(false);
        } else {
            this.isToeSlipping.set(true);
        }
    }

    public boolean isToeSlipping() {
        return this.isToeSlipping.getBooleanValue();
    }
}

