/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.ToeOffParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.LegJointLimitsInspector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ToeOffManager {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double forwardSteppingThreshold = -0.05;
    private static final double minimumAngleForSideStepping = 45.0;
    private static final double extraCoMHeightWithToes = 0.08;
    private static final int smallGlitchWindowSize = 2;
    private final BooleanProvider doToeOffIfPossibleInDoubleSupport;
    private final BooleanProvider doToeOffIfPossibleInSingleSupport;
    private final YoBoolean doPointToeOff = new YoBoolean("doPointToeOff", this.registry);
    private final YoBoolean doLineToeOff = new YoBoolean("doLineToeOff", this.registry);
    private final BooleanProvider useToeLineContactInSwing;
    private final BooleanProvider useToeLineContactInTransfer;
    private final YoBoolean computeToeLineContact = new YoBoolean("computeToeLineContact", this.registry);
    private final YoBoolean computeToePointContact = new YoBoolean("computeToePointContact", this.registry);
    private final BooleanProvider updateLineContactDuringToeOff;
    private final BooleanProvider updatePointContactDuringToeOff;
    private final BooleanProvider checkECMPForToeOff;
    private final BooleanProvider checkCoPForToeOff;
    private final BooleanProvider lookAtTwoStepCapturabilityForToeOff;
    private final LegJointLimitsInspector legInspector;
    private final BooleanProvider forceToeOffAtJointLimit;
    private final DoubleProvider icpPercentOfStanceForDSToeOff;
    private final DoubleProvider icpPercentOfStanceForSSToeOff;
    private final DoubleProvider icpProximityForToeOff;
    private final DoubleProvider ecmpProximityForToeOff;
    private final DoubleProvider copProximityForToeOff;
    private final YoBoolean isDesiredICPOKForToeOff = new YoBoolean("isDesiredICPOKForToeOff", this.registry);
    private final YoBoolean isCurrentICPOKForToeOff = new YoBoolean("isCurrentICPOKForToeOff", this.registry);
    private final YoBoolean isDesiredECMPOKForToeOff = new YoBoolean("isDesiredECMPOKForToeOff", this.registry);
    private final YoBoolean isDesiredCoPOKForToeOff = new YoBoolean("isDesiredCoPOKForToeOff", this.registry);
    private final YoBoolean isFrontFootWellPositionedForToeOff = new YoBoolean("isFrontFootWellPositionedForToeOff", this.registry);
    private final YoBoolean icpIsInsideSupportFoot = new YoBoolean("icpIsInsideSupportFoot", this.registry);
    private final GlitchFilteredYoBoolean isDesiredICPOKForToeOffFilt = new GlitchFilteredYoBoolean("isDesiredICPOKForToeOffFilt", this.registry, this.isDesiredICPOKForToeOff, 2);
    private final GlitchFilteredYoBoolean isCurrentICPOKForToeOffFilt = new GlitchFilteredYoBoolean("isCurrentICPOKForToeOffFilt", this.registry, this.isCurrentICPOKForToeOff, 2);
    private final GlitchFilteredYoBoolean isDesiredECMPOKForToeOffFilt = new GlitchFilteredYoBoolean("isDesiredECMPOKForToeOffFilt", this.registry, this.isDesiredECMPOKForToeOff, 2);
    private final GlitchFilteredYoBoolean isDesiredCoPOKForToeOffFilt = new GlitchFilteredYoBoolean("isDesiredCoPOKForToeOffFilt", this.registry, this.isDesiredCoPOKForToeOff, 2);
    private final DoubleProvider minStepLengthForToeOff;
    private final DoubleProvider minStepForwardForToeOff;
    private final DoubleProvider minStepHeightForToeOff;
    private final DoubleProvider extraCoMMaxHeightWithToes;
    private final YoBoolean isSideStepping = new YoBoolean("isSideStepping", this.registry);
    private final YoBoolean isSteppingDown = new YoBoolean("isSteppingDown", this.registry);
    private final YoBoolean isSteppingUp = new YoBoolean("isSteppingUp", this.registry);
    private final YoBoolean isForwardStepping = new YoBoolean("isForwardStepping", this.registry);
    private final YoBoolean isStepLongEnough = new YoBoolean("isStepLongEnough", this.registry);
    private final YoBoolean isStepLongEnoughAlongX = new YoBoolean("isStepLongEnoughAlongX", this.registry);
    private final YoDouble ecmpProximityToOnToes = new YoDouble("ecmpProximityToOnToes", this.registry);
    private final YoDouble copProximityToOnToes = new YoDouble("copProximityToOnToes", this.registry);
    private final YoDouble desiredICPProximityToOnToes = new YoDouble("desiredICPProximityToOnToes", this.registry);
    private final YoDouble currentICPProximityToOnToes = new YoDouble("currentICPProximityToOnToes", this.registry);
    private final YoDouble desiredICPProximityToLeadingFoot = new YoDouble("desiredICPProximityToLeadingFoot", this.registry);
    private final YoDouble currentICPProximityToLeadingFoot = new YoDouble("currentICPProximityToLeadingFoot", this.registry);
    private final SideDependentList<YoPlaneContactState> footContactStates;
    private final List<FramePoint3D> contactStatePoints = new ArrayList<FramePoint3D>();
    private final SideDependentList<? extends ContactablePlaneBody> feet;
    private final SideDependentList<FrameConvexPolygon2D> footDefaultPolygons;
    private final FrameConvexPolygon2D leadingFootSupportPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D trailingFootSupportPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D nextFootSupportPolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D onToesSupportPolygon = new FrameConvexPolygon2D();
    private final FramePoint2D tempLeadingFootPosition = new FramePoint2D();
    private final FramePoint2D tempTrailingFootPosition = new FramePoint2D();
    private final FramePoint3D tempLeadingFootPositionInWorld = new FramePoint3D();
    private final FramePoint3D tempTrailingFootPositionInWorld = new FramePoint3D();
    private final FrameVector2D toLeadingFoot = new FrameVector2D();
    private final YoFramePoint2D leadingFootPosition = new YoFramePoint2D("leadingFootPositionForToeOff", null, this.registry);
    private final HashMap<ToeContact, AbstractToeContact> toeContacts = new HashMap();
    private Footstep nextFootstep;
    private final FullHumanoidRobotModel fullRobotModel;
    private final ToeOffCalculator toeOffCalculator;
    private final double inPlaceWidth;
    private final FramePoint2D tempPoint = new FramePoint2D();
    private final FramePoint3D nextFrontFootPosition = new FramePoint3D();

    public ToeOffManager(HighLevelHumanoidControllerToolbox controllerToolbox, ToeOffCalculator toeOffCalculator, WalkingControllerParameters walkingControllerParameters, SideDependentList<? extends ContactablePlaneBody> feet, YoRegistry parentRegistry) {
        this(controllerToolbox.getFullRobotModel(), toeOffCalculator, walkingControllerParameters, feet, ToeOffManager.createFootContactStates(controllerToolbox), parentRegistry);
    }

    public ToeOffManager(FullHumanoidRobotModel fullRobotModel, ToeOffCalculator toeOffCalculator, WalkingControllerParameters walkingControllerParameters, SideDependentList<? extends ContactablePlaneBody> feet, SideDependentList<YoPlaneContactState> footContactStates, YoRegistry parentRegistry) {
        ToeOffParameters toeOffParameters = walkingControllerParameters.getToeOffParameters();
        this.legInspector = new LegJointLimitsInspector(toeOffParameters, parentRegistry);
        this.doToeOffIfPossibleInDoubleSupport = new BooleanParameter("doToeOffIfPossibleInDoubleSupport", this.registry, toeOffParameters.doToeOffIfPossible());
        this.doToeOffIfPossibleInSingleSupport = new BooleanParameter("doToeOffIfPossibleInSingleSupport", this.registry, toeOffParameters.doToeOffIfPossibleInSingleSupport());
        this.icpPercentOfStanceForDSToeOff = new DoubleParameter("icpPercentOfStanceForDSToeOff", this.registry, toeOffParameters.getICPPercentOfStanceForDSToeOff());
        this.icpPercentOfStanceForSSToeOff = new DoubleParameter("icpPercentOfStanceForSSToeOff", this.registry, toeOffParameters.getICPPercentOfStanceForSSToeOff());
        this.icpProximityForToeOff = new DoubleParameter("icpProximityForToeOff", this.registry, toeOffParameters.getICPProximityForToeOff());
        this.ecmpProximityForToeOff = new DoubleParameter("ecmpProximityForToeOff", this.registry, toeOffParameters.getECMPProximityForToeOff());
        this.copProximityForToeOff = new DoubleParameter("copProximityForToeOff", this.registry, toeOffParameters.getCoPProximityForToeOff());
        this.checkECMPForToeOff = new BooleanParameter("checkECMPForToeOff", this.registry, toeOffParameters.checkECMPLocationToTriggerToeOff());
        this.checkCoPForToeOff = new BooleanParameter("checkCoPForToeOff", this.registry, toeOffParameters.checkCoPLocationToTriggerToeOff());
        this.forceToeOffAtJointLimit = new BooleanParameter("forceToeOffAtJointLimit", this.registry, toeOffParameters.forceToeOffAtJointLimit());
        this.lookAtTwoStepCapturabilityForToeOff = new BooleanParameter("lookAtTwoStepCapturabilityForToeOff", this.registry, toeOffParameters.lookAtTwoStepCapturabilityForToeOff());
        this.toeOffCalculator = toeOffCalculator;
        this.fullRobotModel = fullRobotModel;
        this.feet = feet;
        this.inPlaceWidth = walkingControllerParameters.getSteppingParameters().getInPlaceWidth();
        double footLength = walkingControllerParameters.getSteppingParameters().getFootBackwardOffset() + walkingControllerParameters.getSteppingParameters().getFootForwardOffset();
        this.extraCoMMaxHeightWithToes = new DoubleParameter("extraCoMMaxHeightWithToes", this.registry, 0.08);
        this.minStepLengthForToeOff = new DoubleParameter("minStepLengthForToeOff", this.registry, toeOffParameters.getMinStepLengthForToeOff());
        this.minStepForwardForToeOff = new DoubleParameter("minStepForwardForToeOff", this.registry, footLength);
        this.minStepHeightForToeOff = new DoubleParameter("minStepHeightForToeOff", this.registry, toeOffParameters.getMinStepHeightForToeOff());
        this.useToeLineContactInSwing = new BooleanParameter("useToeLineContactInSwing", this.registry, toeOffParameters.useToeOffLineContactInSwing());
        this.useToeLineContactInTransfer = new BooleanParameter("useToeLineContactInTransfer", this.registry, toeOffParameters.useToeOffLineContactInTransfer());
        this.updateLineContactDuringToeOff = new BooleanParameter("updateLineContactDuringToeOff", this.registry, toeOffParameters.updateLineContactDuringToeOff());
        this.updatePointContactDuringToeOff = new BooleanParameter("updatePointContactDuringToeOff", this.registry, toeOffParameters.updatePointContactDuringToeOff());
        this.footDefaultPolygons = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            this.footDefaultPolygons.put((Enum)robotSide, (Object)new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)((ContactablePlaneBody)feet.get((Enum)robotSide)).getContactPoints2d())));
        }
        this.footContactStates = footContactStates;
        this.toeContacts.put(ToeContact.LINE, new ToeLineContact());
        this.toeContacts.put(ToeContact.POINT, new ToePointContact());
        parentRegistry.addChild(this.registry);
    }

    private static SideDependentList<YoPlaneContactState> createFootContactStates(HighLevelHumanoidControllerToolbox controllerToolbox) {
        SideDependentList footContactStates = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            footContactStates.put((Enum)robotSide, (Object)controllerToolbox.getFootContactState(robotSide));
        }
        return footContactStates;
    }

    public void reset() {
        this.isDesiredECMPOKForToeOff.set(false);
        this.isDesiredECMPOKForToeOffFilt.set(false);
        this.isDesiredCoPOKForToeOff.set(false);
        this.isDesiredCoPOKForToeOffFilt.set(false);
        this.icpIsInsideSupportFoot.set(true);
        this.isDesiredICPOKForToeOff.set(false);
        this.isDesiredICPOKForToeOffFilt.set(false);
        this.isCurrentICPOKForToeOff.set(false);
        this.isCurrentICPOKForToeOffFilt.set(false);
        this.isFrontFootWellPositionedForToeOff.set(false);
        this.computeToeLineContact.set(true);
        this.computeToePointContact.set(true);
        this.doLineToeOff.set(false);
        this.doPointToeOff.set(false);
        this.legInspector.reset();
    }

    public void submitNextFootstep(Footstep nextFootstep) {
        this.nextFootstep = nextFootstep;
    }

    public void updateToeOffStatusSingleSupport(FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, FramePoint2DReadOnly desiredCoP, FramePoint2DReadOnly desiredICP, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly finalDesiredICP) {
        AbstractToeContact toeContact;
        RobotSide trailingLeg = this.nextFootstep.getRobotSide().getOppositeSide();
        double percentProximity = this.icpPercentOfStanceForSSToeOff.getValue();
        this.setPolygonFromNextFootstep((FrameConvexPolygon2DBasics)this.nextFootSupportPolygon);
        if (this.useToeLineContactInSwing.getValue()) {
            this.computeToePointContact.set(false);
            toeContact = this.toeContacts.get((Object)ToeContact.LINE);
        } else {
            this.computeToeLineContact.set(false);
            toeContact = this.toeContacts.get((Object)ToeContact.POINT);
        }
        toeContact.updateToeSupportPolygon(exitCMP, desiredECMP, trailingLeg, (FrameConvexPolygon2DReadOnly)this.nextFootSupportPolygon);
        if (finalDesiredICP != null && !this.onToesSupportPolygon.isPointInside(finalDesiredICP)) {
            this.onToesSupportPolygon.addVertex(finalDesiredICP);
            this.onToesSupportPolygon.update();
        }
        this.trailingFootSupportPolygon.clear(((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getSoleFrame());
        for (int i = 0; i < ((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getTotalNumberOfContactPoints(); ++i) {
            this.trailingFootSupportPolygon.addVertex((FramePoint2DReadOnly)((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getContactPoints2d().get(i));
        }
        this.trailingFootSupportPolygon.update();
        this.trailingFootSupportPolygon.changeFrameAndProjectToXYPlane(worldFrame);
        FixedFramePoint3DBasics nextFootPosition = this.nextFootstep.getFootstepPose().getPosition();
        this.checkICPLocations(trailingLeg, desiredICP, currentICP, (FramePoint2DReadOnly)toeContact.getToeOffPoint(), (FrameConvexPolygon2DReadOnly)this.nextFootSupportPolygon, (FramePoint3DReadOnly)nextFootPosition, percentProximity);
        this.checkCoPLocation(desiredCoP);
        this.checkECMPLocation(desiredECMP);
        if (!toeContact.evaluateToeOffConditions(trailingLeg)) {
            return;
        }
        if (this.doToeOffIfPossibleInSingleSupport.getValue()) {
            toeContact.isReadyToSwitchToToeOff(trailingLeg, (FramePoint3DReadOnly)nextFootPosition);
        } else {
            this.doLineToeOff.set(false);
            this.doPointToeOff.set(false);
        }
    }

    public void updateToeOffStatusDoubleSupport(RobotSide trailingLeg, FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, FramePoint2DReadOnly desiredCoP, FramePoint2DReadOnly desiredICP, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly finalDesiredICP) {
        AbstractToeContact toeContact;
        this.setPolygonFromSupportFoot(trailingLeg, (FrameConvexPolygon2DBasics)this.leadingFootSupportPolygon);
        if (this.lookAtTwoStepCapturabilityForToeOff.getValue() && this.setPolygonFromNextFootstep((FrameConvexPolygon2DBasics)this.nextFootSupportPolygon)) {
            this.leadingFootSupportPolygon.addVertices((FrameVertex2DSupplier)this.nextFootSupportPolygon);
            this.leadingFootSupportPolygon.update();
        }
        double percentProximity = this.icpPercentOfStanceForDSToeOff.getValue();
        if (this.useToeLineContactInTransfer.getValue()) {
            this.computeToePointContact.set(false);
            toeContact = this.toeContacts.get((Object)ToeContact.LINE);
        } else {
            this.computeToeLineContact.set(false);
            toeContact = this.toeContacts.get((Object)ToeContact.POINT);
        }
        toeContact.updateToeSupportPolygon(exitCMP, desiredECMP, trailingLeg, (FrameConvexPolygon2DReadOnly)this.leadingFootSupportPolygon);
        if (finalDesiredICP != null && !this.onToesSupportPolygon.isPointInside(finalDesiredICP)) {
            this.onToesSupportPolygon.addVertex(finalDesiredICP);
            this.onToesSupportPolygon.update();
        }
        this.trailingFootSupportPolygon.clear(((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getSoleFrame());
        for (int i = 0; i < ((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getTotalNumberOfContactPoints(); ++i) {
            this.trailingFootSupportPolygon.addVertex((FramePoint2DReadOnly)((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getContactPoints2d().get(i));
        }
        this.trailingFootSupportPolygon.update();
        this.trailingFootSupportPolygon.changeFrameAndProjectToXYPlane(worldFrame);
        this.nextFrontFootPosition.setToZero(((ContactablePlaneBody)this.feet.get((Enum)trailingLeg.getOppositeSide())).getSoleFrame());
        this.checkICPLocations(trailingLeg, desiredICP, currentICP, (FramePoint2DReadOnly)toeContact.getToeOffPoint(), (FrameConvexPolygon2DReadOnly)this.leadingFootSupportPolygon, (FramePoint3DReadOnly)this.nextFrontFootPosition, percentProximity);
        this.checkCoPLocation(desiredCoP);
        this.checkECMPLocation(desiredECMP);
        if (!toeContact.evaluateToeOffConditions(trailingLeg)) {
            return;
        }
        if (this.doToeOffIfPossibleInDoubleSupport.getValue()) {
            toeContact.isReadyToSwitchToToeOff(trailingLeg, (FramePoint3DReadOnly)this.nextFrontFootPosition);
        } else {
            this.doLineToeOff.set(false);
            this.doPointToeOff.set(false);
        }
    }

    private void setPolygonFromSupportFoot(RobotSide trailingLeg, FrameConvexPolygon2DBasics polygonToPack) {
        RobotSide leadingLeg = trailingLeg.getOppositeSide();
        if (this.footContactStates != null && ((YoPlaneContactState)this.footContactStates.get((Enum)leadingLeg)).getTotalNumberOfContactPoints() > 0) {
            ((YoPlaneContactState)this.footContactStates.get((Enum)leadingLeg)).getContactFramePointsInContact(this.contactStatePoints);
            polygonToPack.clear(worldFrame);
            for (int i = 0; i < this.contactStatePoints.size(); ++i) {
                polygonToPack.addVertexMatchingFrame((FramePoint3DReadOnly)this.contactStatePoints.get(i));
            }
            polygonToPack.update();
        } else {
            polygonToPack.setIncludingFrame((FrameVertex2DSupplier)this.footDefaultPolygons.get((Enum)leadingLeg));
            polygonToPack.changeFrameAndProjectToXYPlane(worldFrame);
        }
    }

    private boolean setPolygonFromNextFootstep(FrameConvexPolygon2DBasics polygonToPack) {
        if (this.nextFootstep == null || this.nextFootstep.getRobotSide() == null) {
            return false;
        }
        ReferenceFrame footstepSoleFrame = this.nextFootstep.getSoleReferenceFrame();
        List predictedContactPoints = this.nextFootstep.getPredictedContactPoints();
        if (predictedContactPoints != null && !predictedContactPoints.isEmpty()) {
            polygonToPack.clear(footstepSoleFrame);
            for (int i = 0; i < predictedContactPoints.size(); ++i) {
                polygonToPack.addVertex((Point2DReadOnly)predictedContactPoints.get(i));
            }
            polygonToPack.update();
        } else {
            ConvexPolygon2DReadOnly footPolygon = (ConvexPolygon2DReadOnly)this.footDefaultPolygons.get((Enum)this.nextFootstep.getRobotSide());
            polygonToPack.setIncludingFrame(footstepSoleFrame, (Vertex2DSupplier)footPolygon);
        }
        polygonToPack.changeFrameAndProjectToXYPlane(worldFrame);
        return true;
    }

    private void checkECMPLocation(FramePoint2DReadOnly desiredECMP) {
        this.tempPoint.setIncludingFrame((FrameTuple2DReadOnly)desiredECMP);
        this.tempPoint.changeFrameAndProjectToXYPlane(this.onToesSupportPolygon.getReferenceFrame());
        this.ecmpProximityToOnToes.set(this.onToesSupportPolygon.signedDistance((FramePoint2DReadOnly)this.tempPoint));
        if (this.checkECMPForToeOff.getValue()) {
            this.isDesiredECMPOKForToeOff.set(this.ecmpProximityToOnToes.getDoubleValue() < this.ecmpProximityForToeOff.getValue());
            this.isDesiredECMPOKForToeOffFilt.update();
        } else {
            this.isDesiredECMPOKForToeOff.set(true);
            this.isDesiredECMPOKForToeOffFilt.set(true);
        }
    }

    private void checkCoPLocation(FramePoint2DReadOnly desiredCoP) {
        this.tempPoint.setIncludingFrame((FrameTuple2DReadOnly)desiredCoP);
        this.tempPoint.changeFrameAndProjectToXYPlane(this.onToesSupportPolygon.getReferenceFrame());
        this.copProximityToOnToes.set(this.onToesSupportPolygon.signedDistance((FramePoint2DReadOnly)this.tempPoint));
        if (this.checkCoPForToeOff.getValue()) {
            this.isDesiredCoPOKForToeOff.set(this.copProximityToOnToes.getDoubleValue() < this.copProximityForToeOff.getValue());
            this.isDesiredCoPOKForToeOffFilt.update();
        } else {
            this.isDesiredCoPOKForToeOff.set(true);
            this.isDesiredCoPOKForToeOffFilt.set(true);
        }
    }

    private void checkICPLocations(RobotSide trailingLeg, FramePoint2DReadOnly desiredICP, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly toeOffPoint, FrameConvexPolygon2DReadOnly leadingFootSupportPolygon, FramePoint3DReadOnly nextFootPosition, double percentProximity) {
        this.icpIsInsideSupportFoot.set(this.trailingFootSupportPolygon.isPointInside(currentICP));
        this.desiredICPProximityToOnToes.set(this.onToesSupportPolygon.signedDistance(desiredICP));
        this.currentICPProximityToOnToes.set(this.onToesSupportPolygon.signedDistance(currentICP));
        double distanceToLeadingFoot = this.computeDistanceToLeadingFoot(trailingLeg, nextFootPosition, toeOffPoint);
        this.currentICPProximityToLeadingFoot.set(leadingFootSupportPolygon.signedDistance(currentICP) / distanceToLeadingFoot);
        this.desiredICPProximityToLeadingFoot.set(leadingFootSupportPolygon.signedDistance(desiredICP) / distanceToLeadingFoot);
        boolean isDesiredICPOKForToeOff = this.desiredICPProximityToOnToes.getDoubleValue() < this.icpProximityForToeOff.getValue();
        boolean isCurrentICPOKForToeOff = this.currentICPProximityToOnToes.getDoubleValue() < this.icpProximityForToeOff.getValue();
        this.isCurrentICPOKForToeOff.set(isCurrentICPOKForToeOff &= this.currentICPProximityToLeadingFoot.getDoubleValue() < percentProximity);
        this.isDesiredICPOKForToeOff.set(isDesiredICPOKForToeOff &= this.desiredICPProximityToLeadingFoot.getDoubleValue() < percentProximity);
        this.isCurrentICPOKForToeOffFilt.update();
        this.isDesiredICPOKForToeOffFilt.update();
    }

    private void checkAnkleLimitForToeOff(RobotSide trailingLeg) {
        OneDoFJointBasics anklePitch = this.fullRobotModel.getLegJoint((Enum)trailingLeg, LegJointName.ANKLE_PITCH);
        this.legInspector.updateTrailingAnkleLowerLimitsStatus(anklePitch);
    }

    private double computeDistanceToLeadingFoot(RobotSide trailingLeg, FramePoint3DReadOnly nextFootPosition, FramePoint2DReadOnly toeOffPoint) {
        ReferenceFrame trailingFootFrame = ((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getSoleFrame();
        this.tempLeadingFootPosition.setIncludingFrame((FrameTuple3DReadOnly)nextFootPosition);
        this.tempLeadingFootPosition.changeFrameAndProjectToXYPlane(trailingFootFrame);
        this.tempPoint.setIncludingFrame((FrameTuple2DReadOnly)toeOffPoint);
        this.tempPoint.changeFrameAndProjectToXYPlane(trailingFootFrame);
        this.toLeadingFoot.setToZero(trailingFootFrame);
        this.toLeadingFoot.set((FrameTuple2DReadOnly)this.tempLeadingFootPosition);
        this.toLeadingFoot.sub((FrameTuple2DReadOnly)this.tempPoint);
        return this.toLeadingFoot.length();
    }

    private void checkLeadingKneeUpperLimitForToeOff(RobotSide leadingLeg) {
        OneDoFJointBasics kneePitch = this.fullRobotModel.getLegJoint((Enum)leadingLeg, LegJointName.KNEE_PITCH);
        this.legInspector.updateLeadingKneeUpperLimitsStatus(kneePitch);
    }

    private void checkRearKneeLowerLimitForToeOff(RobotSide trailingLeg) {
        OneDoFJointBasics kneePitch = this.fullRobotModel.getLegJoint((Enum)trailingLeg, LegJointName.KNEE_PITCH);
        this.legInspector.updateTrailingKneeLowerLimitsStatus(kneePitch);
    }

    private boolean isFrontFootWellPositionedForToeOff(RobotSide trailingLeg, FramePoint3DReadOnly frontFootPosition) {
        ReferenceFrame trailingFootFrame = ((ContactablePlaneBody)this.feet.get((Enum)trailingLeg)).getSoleFrame();
        this.tempTrailingFootPosition.setToZero(trailingFootFrame);
        this.tempLeadingFootPosition.setIncludingFrame((FrameTuple3DReadOnly)frontFootPosition);
        this.tempLeadingFootPosition.changeFrameAndProjectToXYPlane(trailingFootFrame);
        if (Math.abs(this.tempLeadingFootPosition.getY()) > this.inPlaceWidth) {
            this.tempLeadingFootPosition.setY(this.tempLeadingFootPosition.getY() + trailingLeg.negateIfRightSide(this.inPlaceWidth));
        } else {
            this.tempLeadingFootPosition.setY(0.0);
        }
        this.leadingFootPosition.set(this.tempLeadingFootPosition.getX(), this.tempLeadingFootPosition.getY());
        this.tempLeadingFootPositionInWorld.setIncludingFrame((FrameTuple3DReadOnly)frontFootPosition);
        this.tempTrailingFootPositionInWorld.setToZero(trailingFootFrame);
        this.tempLeadingFootPositionInWorld.changeFrame(worldFrame);
        this.tempTrailingFootPositionInWorld.changeFrame(worldFrame);
        double stepHeight = this.tempLeadingFootPositionInWorld.getZ() - this.tempTrailingFootPositionInWorld.getZ();
        this.isSteppingUp.set(stepHeight > this.minStepHeightForToeOff.getValue());
        this.isForwardStepping.set(this.leadingFootPosition.getX() > -0.05);
        this.isSteppingDown.set(stepHeight < -this.minStepHeightForToeOff.getValue());
        this.isSideStepping.set(Math.abs(Math.atan2(this.leadingFootPosition.getY(), this.leadingFootPosition.getX())) > Math.toRadians(45.0));
        double scale = 1.0;
        if (this.isSteppingDown.getBooleanValue()) {
            scale = 0.5;
        }
        this.isStepLongEnough.set(this.tempLeadingFootPosition.distance((FramePoint2DReadOnly)this.tempTrailingFootPosition) > scale * this.minStepLengthForToeOff.getValue());
        this.isStepLongEnoughAlongX.set(this.leadingFootPosition.getX() > scale * this.minStepForwardForToeOff.getValue());
        if (this.isSteppingUp.getBooleanValue()) {
            return true;
        }
        return this.isForwardStepping.getBooleanValue() && this.isStepLongEnough.getValue() && this.isStepLongEnoughAlongX.getValue();
    }

    public boolean canDoSingleSupportToeOff(FramePoint3DReadOnly nextFootstepPosition, RobotSide transferToSide) {
        if (!this.doToeOffIfPossibleInSingleSupport.getValue()) {
            return false;
        }
        return this.canDoToeOff(nextFootstepPosition, transferToSide);
    }

    public boolean canDoDoubleSupportToeOff(FramePoint3DReadOnly nextFootstepPosition, RobotSide transferToSide) {
        if (!this.doToeOffIfPossibleInDoubleSupport.getValue()) {
            return false;
        }
        return this.canDoToeOff(nextFootstepPosition, transferToSide);
    }

    public boolean canDoToeOff(FramePoint3DReadOnly nextFootstepPosition, RobotSide transferToSide) {
        RobotSide nextTrailingLeg = transferToSide.getOppositeSide();
        if (nextFootstepPosition != null) {
            this.nextFrontFootPosition.setIncludingFrame((FrameTuple3DReadOnly)nextFootstepPosition);
        } else {
            this.nextFrontFootPosition.setToZero(((ContactablePlaneBody)this.feet.get((Enum)nextTrailingLeg.getOppositeSide())).getSoleFrame());
        }
        this.isFrontFootWellPositionedForToeOff.set(this.isFrontFootWellPositionedForToeOff(nextTrailingLeg, (FramePoint3DReadOnly)this.nextFrontFootPosition));
        return this.isFrontFootWellPositionedForToeOff.getBooleanValue();
    }

    public boolean doLineToeOff() {
        return this.doLineToeOff.getBooleanValue();
    }

    public boolean doPointToeOff() {
        return this.doPointToeOff.getBooleanValue();
    }

    public boolean shouldComputeToeLineContact() {
        return this.computeToeLineContact.getBooleanValue();
    }

    public boolean shouldComputeToePointContact() {
        return this.computeToePointContact.getBooleanValue();
    }

    public double getExtraCoMMaxHeightWithToes() {
        return this.extraCoMMaxHeightWithToes.getValue();
    }

    public boolean isSteppingUp() {
        return this.isSteppingUp.getValue();
    }

    public boolean useToeLineContactInTransfer() {
        return this.useToeLineContactInTransfer.getValue();
    }

    private static enum ToeContact {
        POINT,
        LINE;

    }

    private class ToeLineContact
    extends AbstractToeContact {
        private ToeLineContact() {
        }

        @Override
        public void updateToeSupportPolygon(FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, RobotSide trailingSide, FrameConvexPolygon2DReadOnly leadingSupportPolygon) {
            if (exitCMP == null) {
                this.computeToeContacts(trailingSide);
            } else {
                this.computeToeContacts(exitCMP, desiredECMP, trailingSide);
            }
            ToeOffManager.this.onToesSupportPolygon.setIncludingFrame((FrameVertex2DSupplier)leadingSupportPolygon);
            ToeOffManager.this.onToesSupportPolygon.changeFrameAndProjectToXYPlane(worldFrame);
            ToeOffManager.this.onToesSupportPolygon.addVertexMatchingFrame((FramePoint2DReadOnly)this.toeOffLine.getFirstEndpoint(), false);
            ToeOffManager.this.onToesSupportPolygon.addVertexMatchingFrame((FramePoint2DReadOnly)this.toeOffLine.getSecondEndpoint(), false);
            ToeOffManager.this.onToesSupportPolygon.update();
            this.toeOffLine.midpoint((FramePoint2DBasics)this.toeOffPoint);
        }

        @Override
        public void isReadyToSwitchToToeOff(RobotSide trailingLeg, FramePoint3DReadOnly frontFootPosition) {
            ToeOffManager.this.isFrontFootWellPositionedForToeOff.set(ToeOffManager.this.isFrontFootWellPositionedForToeOff(trailingLeg, frontFootPosition));
            if (!ToeOffManager.this.isFrontFootWellPositionedForToeOff.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(false);
                ToeOffManager.this.computeToeLineContact.set(true);
                return;
            }
            ToeOffManager.this.computeToeLineContact.set(ToeOffManager.this.updateLineContactDuringToeOff.getValue());
            ToeOffManager.this.doLineToeOff.set(true);
        }

        private void computeToeContacts(FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, RobotSide supportSide) {
            ToeOffManager.this.toeOffCalculator.setExitCMP(exitCMP, supportSide);
            ToeOffManager.this.toeOffCalculator.computeToeOffContactLine(desiredECMP, supportSide);
            this.toeOffLine.setToZero(((ContactablePlaneBody)ToeOffManager.this.feet.get((Enum)supportSide)).getSoleFrame());
            ToeOffManager.this.toeOffCalculator.getToeOffContactLine((FrameLineSegment2DBasics)this.toeOffLine, supportSide);
        }

        @Override
        public boolean evaluateToeOffConditions(RobotSide trailingLeg) {
            ToeOffManager.this.checkAnkleLimitForToeOff(trailingLeg);
            ToeOffManager.this.checkLeadingKneeUpperLimitForToeOff(trailingLeg.getOppositeSide());
            ToeOffManager.this.checkRearKneeLowerLimitForToeOff(trailingLeg);
            ToeOffManager.this.legInspector.updateSwitchToToeOffDueToJointLimits();
            if (ToeOffManager.this.forceToeOffAtJointLimit.getValue() && ToeOffManager.this.legInspector.needToSwitchToToeOffDueToJointLimit() && !ToeOffManager.this.icpIsInsideSupportFoot.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(true);
                ToeOffManager.this.computeToeLineContact.set(ToeOffManager.this.updateLineContactDuringToeOff.getValue());
                return false;
            }
            if (!ToeOffManager.this.isDesiredICPOKForToeOffFilt.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(false);
                ToeOffManager.this.computeToeLineContact.set(true);
                return false;
            }
            if (!ToeOffManager.this.forceToeOffAtJointLimit.getValue() && ToeOffManager.this.legInspector.needToSwitchToToeOffDueToJointLimit()) {
                ToeOffManager.this.doLineToeOff.set(true);
                ToeOffManager.this.computeToeLineContact.set(ToeOffManager.this.updateLineContactDuringToeOff.getValue());
                return false;
            }
            if (!ToeOffManager.this.isCurrentICPOKForToeOffFilt.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(false);
                ToeOffManager.this.computeToeLineContact.set(true);
                return false;
            }
            if (!ToeOffManager.this.isDesiredECMPOKForToeOffFilt.getBooleanValue() || !ToeOffManager.this.isDesiredCoPOKForToeOffFilt.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(false);
                ToeOffManager.this.computeToeLineContact.set(true);
                return false;
            }
            return true;
        }
    }

    private class ToePointContact
    extends AbstractToeContact {
        private ToePointContact() {
        }

        @Override
        public void updateToeSupportPolygon(FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, RobotSide trailingSide, FrameConvexPolygon2DReadOnly leadingSupportPolygon) {
            if (exitCMP == null) {
                this.computeToeContacts(trailingSide);
            } else {
                this.computeToeContacts(exitCMP, desiredECMP, trailingSide);
            }
            ToeOffManager.this.onToesSupportPolygon.setIncludingFrame((FrameVertex2DSupplier)leadingSupportPolygon);
            ToeOffManager.this.onToesSupportPolygon.changeFrameAndProjectToXYPlane(worldFrame);
            ToeOffManager.this.onToesSupportPolygon.addVertexMatchingFrame((FramePoint2DReadOnly)this.toeOffPoint, false);
            ToeOffManager.this.onToesSupportPolygon.update();
        }

        @Override
        public void isReadyToSwitchToToeOff(RobotSide trailingLeg, FramePoint3DReadOnly frontFootPosition) {
            ToeOffManager.this.isFrontFootWellPositionedForToeOff.set(ToeOffManager.this.isFrontFootWellPositionedForToeOff(trailingLeg, frontFootPosition));
            if (!ToeOffManager.this.isFrontFootWellPositionedForToeOff.getBooleanValue()) {
                ToeOffManager.this.doPointToeOff.set(false);
                ToeOffManager.this.computeToePointContact.set(true);
                return;
            }
            ToeOffManager.this.computeToePointContact.set(ToeOffManager.this.updatePointContactDuringToeOff.getValue());
            ToeOffManager.this.doPointToeOff.set(true);
        }

        private void computeToeContacts(FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, RobotSide supportSide) {
            ToeOffManager.this.toeOffCalculator.setExitCMP(exitCMP, supportSide);
            ToeOffManager.this.toeOffCalculator.computeToeOffContactPoint(desiredECMP, supportSide);
            this.toeOffPoint.setToZero(((ContactablePlaneBody)ToeOffManager.this.feet.get((Enum)supportSide)).getSoleFrame());
            ToeOffManager.this.toeOffCalculator.getToeOffContactPoint((FramePoint2DBasics)this.toeOffPoint, supportSide);
        }

        @Override
        public boolean evaluateToeOffConditions(RobotSide trailingLeg) {
            ToeOffManager.this.checkAnkleLimitForToeOff(trailingLeg);
            ToeOffManager.this.checkLeadingKneeUpperLimitForToeOff(trailingLeg.getOppositeSide());
            ToeOffManager.this.checkRearKneeLowerLimitForToeOff(trailingLeg);
            ToeOffManager.this.legInspector.updateSwitchToToeOffDueToJointLimits();
            if (ToeOffManager.this.forceToeOffAtJointLimit.getValue() && ToeOffManager.this.legInspector.needToSwitchToToeOffDueToJointLimit()) {
                ToeOffManager.this.doPointToeOff.set(true);
                ToeOffManager.this.computeToePointContact.set(ToeOffManager.this.updatePointContactDuringToeOff.getValue());
                return false;
            }
            if (!ToeOffManager.this.isDesiredICPOKForToeOffFilt.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(false);
                ToeOffManager.this.computeToePointContact.set(true);
                return false;
            }
            if (!ToeOffManager.this.forceToeOffAtJointLimit.getValue() && ToeOffManager.this.legInspector.needToSwitchToToeOffDueToJointLimit()) {
                ToeOffManager.this.doPointToeOff.set(true);
                ToeOffManager.this.computeToePointContact.set(ToeOffManager.this.updatePointContactDuringToeOff.getValue());
                return false;
            }
            if (!ToeOffManager.this.isCurrentICPOKForToeOffFilt.getBooleanValue()) {
                ToeOffManager.this.doLineToeOff.set(false);
                ToeOffManager.this.computeToePointContact.set(true);
                return false;
            }
            if (!ToeOffManager.this.isDesiredECMPOKForToeOffFilt.getBooleanValue()) {
                ToeOffManager.this.doPointToeOff.set(false);
                ToeOffManager.this.computeToePointContact.set(true);
                return false;
            }
            return true;
        }
    }

    private abstract class AbstractToeContact {
        protected final FrameLineSegment2D toeOffLine = new FrameLineSegment2D();
        protected final FramePoint2D toeOffPoint = new FramePoint2D();
        protected final FramePoint2D tmpPoint2d = new FramePoint2D();

        private AbstractToeContact() {
        }

        public abstract void updateToeSupportPolygon(FramePoint3DReadOnly var1, FramePoint2DReadOnly var2, RobotSide var3, FrameConvexPolygon2DReadOnly var4);

        public abstract void isReadyToSwitchToToeOff(RobotSide var1, FramePoint3DReadOnly var2);

        public abstract boolean evaluateToeOffConditions(RobotSide var1);

        protected void computeToeContacts(RobotSide supportSide) {
            FrameConvexPolygon2D footDefaultPolygon = (FrameConvexPolygon2D)ToeOffManager.this.footDefaultPolygons.get((Enum)supportSide);
            ReferenceFrame referenceFrame = footDefaultPolygon.getReferenceFrame();
            this.toeOffLine.getFirstEndpoint().set(referenceFrame, Double.NEGATIVE_INFINITY, 0.0);
            this.toeOffLine.getSecondEndpoint().set(referenceFrame, Double.NEGATIVE_INFINITY, 0.0);
            for (int i = 0; i < footDefaultPolygon.getNumberOfVertices(); ++i) {
                this.tmpPoint2d.setIncludingFrame((FrameTuple2DReadOnly)footDefaultPolygon.getVertex(i));
                if (this.tmpPoint2d.getX() > this.toeOffLine.getFirstEndpoint().getX()) {
                    this.toeOffLine.getSecondEndpoint().set((FrameTuple2DReadOnly)this.toeOffLine.getFirstEndpoint());
                    this.toeOffLine.getFirstEndpoint().set((FrameTuple2DReadOnly)this.tmpPoint2d);
                    continue;
                }
                if (!(this.tmpPoint2d.getX() > this.toeOffLine.getSecondEndpoint().getX())) continue;
                this.toeOffLine.getSecondEndpoint().set((FrameTuple2DReadOnly)this.tmpPoint2d);
            }
            this.toeOffPoint.setToZero(footDefaultPolygon.getReferenceFrame());
            this.toeOffLine.midpoint((FramePoint2DBasics)this.toeOffPoint);
        }

        public FramePoint2D getToeOffPoint() {
            return this.toeOffPoint;
        }
    }
}

