/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.LeapOfFaithParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.YoSwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.controlModules.SwingTrajectoryCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.LegJointLimitAvoidanceControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.leapOfFaith.FootLeapOfFaithModule;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.trajectories.SoftTouchdownPoseTrajectoryGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.math.filters.RateLimitedYoFramePose;
import us.ihmc.robotics.math.trajectories.BlendedPositionTrajectoryGeneratorVisualizer;
import us.ihmc.robotics.math.trajectories.MultipleWaypointsBlendedPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class SwingState
extends AbstractFootControlState {
    private static final boolean visualizeAdjustedSwing = false;
    private static final boolean USE_ALL_LEG_JOINT_SWING_CORRECTOR = false;
    private final YoBoolean replanTrajectory;
    private final YoBoolean footstepWasAdjusted;
    private static final double maxScalingFactor = 1.5;
    private static final double minScalingFactor = 0.1;
    private static final double exponentialScalingRate = 5.0;
    private final SwingTrajectoryCalculator swingTrajectoryCalculator;
    private final MultipleWaypointsBlendedPoseTrajectoryGenerator blendedSwingTrajectory;
    private final BlendedPositionTrajectoryGeneratorVisualizer swingVisualizer;
    private final SoftTouchdownPoseTrajectoryGenerator touchdownTrajectory;
    private double swingTrajectoryBlendDuration = 0.0;
    private final List<FixedFramePoint3DBasics> swingWaypointsForViz = new ArrayList<FixedFramePoint3DBasics>();
    private final ReferenceFrame soleFrame;
    private final YoSwingTrajectoryParameters swingTrajectoryParameters;
    private final FootLeapOfFaithModule leapOfFaithModule;
    private final YoVector3D actualDesiredTouchdownVelocity;
    private final FramePose3D initialPose = new FramePose3D();
    private final FrameVector3DReadOnly finalAngularVelocity = new FrameVector3D(worldFrame);
    private final YoDouble swingDuration;
    private final YoDouble swingTimeSpeedUpFactor;
    private final YoDouble maxSwingTimeSpeedUpFactor;
    private final YoDouble minSwingTimeForDisturbanceRecovery;
    private final YoBoolean isSwingSpeedUpEnabled;
    private final YoDouble currentTime;
    private final YoDouble currentTimeWithSwingSpeedUp;
    private final double controlDT;
    private final PoseReferenceFrame desiredSoleFrame = new PoseReferenceFrame("desiredSoleFrame", worldFrame);
    private final PoseReferenceFrame desiredControlFrame = new PoseReferenceFrame("desiredControlFrame", (ReferenceFrame)this.desiredSoleFrame);
    private final FramePose3D desiredPose = new FramePose3D();
    private final Twist desiredTwist = new Twist();
    private final SpatialAcceleration desiredSpatialAcceleration = new SpatialAcceleration();
    private final RigidBodyTransform transformFromToeToAnkle = new RigidBodyTransform();
    private final YoFrameVector3D adjustmentVelocityCorrection;
    private final FramePoint3D unadjustedPosition = new FramePoint3D(worldFrame);
    private final FramePose3D adjustedFootstepPose = new FramePose3D();
    private final RateLimitedYoFramePose rateLimitedAdjustedPose;
    private final FramePose3D footstepPose = new FramePose3D();
    private final YoInteger currentTrajectoryWaypoint;
    private final YoFramePoint3D yoDesiredSolePosition;
    private final YoFrameQuaternion yoDesiredSoleOrientation;
    private final YoFrameVector3D yoDesiredSoleLinearVelocity;
    private final YoFrameVector3D yoDesiredSoleAngularVelocity;
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private final WorkspaceLimiterControlModule workspaceLimiterControlModule;
    private final LegJointLimitAvoidanceControlModule legJointLimitAvoidanceControlModule;
    private final YoFramePoint3D yoDesiredPosition;
    private final YoFrameVector3D yoDesiredLinearVelocity;
    private final YoBoolean yoSetDesiredAccelerationToZero;
    private final YoBoolean yoSetDesiredVelocityToZero;
    private final YoBoolean scaleSecondaryJointWeights;
    private final YoDouble secondaryJointWeightScale;
    private Vector3DReadOnly nominalAngularWeight;
    private Vector3DReadOnly nominalLinearWeight;
    private final YoFrameVector3D currentAngularWeight;
    private final YoFrameVector3D currentLinearWeight;
    private final ReferenceFrame ankleFrame;
    private final PoseReferenceFrame controlFrame;
    private final PIDSE3GainsReadOnly gains;
    private final FramePoint3D desiredAnklePosition = new FramePoint3D();
    private final RigidBodyTransform oldBodyFrameDesiredTransform = new RigidBodyTransform();
    private final RigidBodyTransform newBodyFrameDesiredTransform = new RigidBodyTransform();
    private final RigidBodyTransform transformFromNewBodyFrameToOldBodyFrame = new RigidBodyTransform();
    private final YoFrameVector3D touchdownDesiredLinearAcceleration;
    private final PoseReferenceFrame footstepFrame = new PoseReferenceFrame("FootstepFrame", worldFrame);
    private final PoseReferenceFrame adjustedFootstepFrame = new PoseReferenceFrame("AdjustedFootstepFrame", worldFrame);
    private final FramePose3D adjustedWaypoint = new FramePose3D();

    public SwingState(FootControlHelper footControlHelper, PIDSE3GainsReadOnly gains, YoRegistry registry) {
        super(footControlHelper);
        this.gains = gains;
        this.workspaceLimiterControlModule = footControlHelper.getWorkspaceLimiterControlModule();
        this.swingTrajectoryParameters = footControlHelper.getSwingTrajectoryParameters();
        RigidBodyBasics foot = this.contactableFoot.getRigidBody();
        String namePrefix = this.robotSide.getCamelCaseNameForStartOfExpression() + "FootSwing";
        this.yoDesiredLinearVelocity = new YoFrameVector3D(namePrefix + "DesiredLinearVelocity", worldFrame, registry);
        this.yoDesiredLinearVelocity.setToNaN();
        this.yoDesiredPosition = new YoFramePoint3D(namePrefix + "DesiredPosition", worldFrame, registry);
        this.yoDesiredPosition.setToNaN();
        this.yoSetDesiredAccelerationToZero = new YoBoolean(namePrefix + "SetDesiredAccelerationToZero", registry);
        this.yoSetDesiredVelocityToZero = new YoBoolean(namePrefix + "SetDesiredVelocityToZero", registry);
        this.scaleSecondaryJointWeights = new YoBoolean(namePrefix + "ScaleSecondaryJointWeights", registry);
        this.secondaryJointWeightScale = new YoDouble(namePrefix + "SecondaryJointWeightScale", registry);
        this.secondaryJointWeightScale.set(1.0);
        this.currentAngularWeight = new YoFrameVector3D(namePrefix + "CurrentAngularWeight", worldFrame, registry);
        this.currentLinearWeight = new YoFrameVector3D(namePrefix + "CurrentLinearWeight", worldFrame, registry);
        this.touchdownDesiredLinearAcceleration = new YoFrameVector3D(namePrefix + "DesiredTouchdownAcceleration", worldFrame, registry);
        this.legJointLimitAvoidanceControlModule = null;
        this.ankleFrame = this.contactableFoot.getFrameAfterParentJoint();
        this.controlFrame = new PoseReferenceFrame("controlFrame", (ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.spatialFeedbackControlCommand.set(this.rootBody, foot);
        this.spatialFeedbackControlCommand.setPrimaryBase(this.pelvis);
        ReferenceFrame linearGainsFrame = footControlHelper.getHighLevelHumanoidControllerToolbox().getPelvisZUpFrame();
        this.spatialFeedbackControlCommand.setGainsFrames(null, linearGainsFrame);
        FramePose3D anklePoseInFoot = new FramePose3D(this.ankleFrame);
        anklePoseInFoot.changeFrame((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.changeControlFrame(anklePoseInFoot);
        this.actualDesiredTouchdownVelocity = new YoVector3D(namePrefix + "ActualDesiredTouchdownVelocity", registry);
        this.controlDT = footControlHelper.getHighLevelHumanoidControllerToolbox().getControlDT();
        WalkingControllerParameters walkingControllerParameters = footControlHelper.getWalkingControllerParameters();
        this.replanTrajectory = new YoBoolean(namePrefix + "ReplanTrajectory", registry);
        this.footstepWasAdjusted = new YoBoolean(namePrefix + "FootstepWasAdjusted", registry);
        this.adjustmentVelocityCorrection = new YoFrameVector3D(namePrefix + "AdjustmentVelocityCorrection", worldFrame, registry);
        this.rateLimitedAdjustedPose = new RateLimitedYoFramePose(namePrefix + "AdjustedFootstepPose", "", registry, 10.0, this.controlDT, worldFrame);
        this.soleFrame = footControlHelper.getHighLevelHumanoidControllerToolbox().getReferenceFrames().getSoleFrame((Enum)this.robotSide);
        MovingReferenceFrame footFrame = this.contactableFoot.getFrameAfterParentJoint();
        ReferenceFrame toeFrame = this.createToeFrame(this.robotSide);
        ReferenceFrame controlFrame = walkingControllerParameters.controlToeDuringSwing() ? toeFrame : footFrame;
        RigidBodyTransform soleToControlFrameTransform = new RigidBodyTransform();
        controlFrame.getTransformToDesiredFrame(soleToControlFrameTransform, this.soleFrame);
        this.desiredControlFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)soleToControlFrameTransform);
        YoGraphicsListRegistry yoGraphicsListRegistry = this.controllerToolbox.getYoGraphicsListRegistry();
        this.swingDuration = new YoDouble(namePrefix + "Duration", registry);
        this.swingTrajectoryCalculator = footControlHelper.getSwingTrajectoryCalculator();
        this.blendedSwingTrajectory = new MultipleWaypointsBlendedPoseTrajectoryGenerator(namePrefix, this.swingTrajectoryCalculator.getSwingTrajectory(), worldFrame, registry);
        this.touchdownTrajectory = new SoftTouchdownPoseTrajectoryGenerator(namePrefix + "Touchdown", registry);
        this.swingVisualizer = null;
        this.swingTimeSpeedUpFactor = new YoDouble(namePrefix + "TimeSpeedUpFactor", registry);
        this.minSwingTimeForDisturbanceRecovery = new YoDouble(namePrefix + "MinTimeForDisturbanceRecovery", registry);
        this.minSwingTimeForDisturbanceRecovery.set(walkingControllerParameters.getMinimumSwingTimeForDisturbanceRecovery());
        this.maxSwingTimeSpeedUpFactor = new YoDouble(namePrefix + "MaxTimeSpeedUpFactor", registry);
        this.currentTime = new YoDouble(namePrefix + "CurrentTime", registry);
        this.currentTimeWithSwingSpeedUp = new YoDouble(namePrefix + "CurrentTimeWithSpeedUp", registry);
        this.isSwingSpeedUpEnabled = new YoBoolean(namePrefix + "IsSpeedUpEnabled", registry);
        this.isSwingSpeedUpEnabled.set(walkingControllerParameters.allowDisturbanceRecoveryBySpeedingUpSwing());
        this.swingTimeSpeedUpFactor.setToNaN();
        this.scaleSecondaryJointWeights.set(walkingControllerParameters.applySecondaryJointScaleDuringSwing());
        LeapOfFaithParameters leapOfFaithParameters = walkingControllerParameters.getLeapOfFaithParameters();
        this.leapOfFaithModule = new FootLeapOfFaithModule(this.swingDuration, leapOfFaithParameters, registry);
        FramePose3D controlFramePose = new FramePose3D(controlFrame);
        controlFramePose.changeFrame((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.changeControlFrame(controlFramePose);
        this.footstepPose.setToNaN();
        this.footstepWasAdjusted.set(false);
        this.currentTrajectoryWaypoint = new YoInteger(namePrefix + "CurrentTrajectoryWaypoint", registry);
        this.yoDesiredSolePosition = new YoFramePoint3D(namePrefix + "DesiredSolePositionInWorld", worldFrame, registry);
        this.yoDesiredSoleOrientation = new YoFrameQuaternion(namePrefix + "DesiredSoleOrientationInWorld", worldFrame, registry);
        this.yoDesiredSoleLinearVelocity = new YoFrameVector3D(namePrefix + "DesiredSoleLinearVelocityInWorld", worldFrame, registry);
        this.yoDesiredSoleAngularVelocity = new YoFrameVector3D(namePrefix + "DesiredSoleAngularVelocityInWorld", worldFrame, registry);
        this.setupViz(yoGraphicsListRegistry, registry);
    }

    private void setupViz(YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        if (yoGraphicsListRegistry == null) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            YoFramePoint3D yoWaypoint = new YoFramePoint3D("SwingWaypoint" + this.robotSide.getPascalCaseName() + i, ReferenceFrame.getWorldFrame(), registry);
            YoGraphicPosition waypointViz = new YoGraphicPosition("SwingWaypoint" + this.robotSide.getPascalCaseName() + i, yoWaypoint, 0.01, YoAppearance.GreenYellow());
            yoWaypoint.setToNaN();
            yoGraphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)waypointViz);
            this.swingWaypointsForViz.add((FixedFramePoint3DBasics)yoWaypoint);
        }
    }

    private ReferenceFrame createToeFrame(RobotSide robotSide) {
        ContactableFoot contactableFoot = (ContactableFoot)this.controllerToolbox.getContactableFeet().get((Enum)robotSide);
        MovingReferenceFrame footFrame = this.controllerToolbox.getReferenceFrames().getFootFrame((Enum)robotSide);
        FramePoint2D toeContactPoint2d = new FramePoint2D();
        contactableFoot.getToeOffContactPoint(toeContactPoint2d);
        FramePoint3D toeContactPoint = new FramePoint3D();
        toeContactPoint.setIncludingFrame((FrameTuple2DReadOnly)toeContactPoint2d, 0.0);
        toeContactPoint.changeFrame((ReferenceFrame)footFrame);
        this.transformFromToeToAnkle.getTranslation().set((Tuple3DReadOnly)toeContactPoint);
        return ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(robotSide.getCamelCaseNameForStartOfExpression() + "ToeFrame"), (ReferenceFrame)footFrame, (RigidBodyTransformReadOnly)this.transformFromToeToAnkle);
    }

    private void initializeTrajectory() {
        this.initialPose.setToZero(this.soleFrame);
        this.swingTrajectoryCalculator.setInitialConditionsToCurrent();
        this.fillAndInitializeTrajectories(true);
    }

    @Override
    public void onEntry() {
        super.onEntry();
        this.swingTrajectoryCalculator.setShouldVisualize(true);
        this.currentTime.set(0.0);
        this.swingTimeSpeedUpFactor.set(1.0);
        this.currentTimeWithSwingSpeedUp.set(Double.NaN);
        this.replanTrajectory.set(false);
        if (this.workspaceLimiterControlModule != null) {
            this.workspaceLimiterControlModule.setCheckVelocityForSwingSingularityAvoidance(true);
        }
        YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
        contactState.notifyContactStateHasChanged();
        this.spatialFeedbackControlCommand.resetSecondaryTaskJointWeightScale();
        this.initializeTrajectory();
    }

    @Override
    public void onExit() {
        super.onExit();
        this.currentTime.set(0.0);
        this.swingTimeSpeedUpFactor.set(Double.NaN);
        this.currentTimeWithSwingSpeedUp.set(Double.NaN);
        this.swingTrajectoryCalculator.informDone();
        for (int i = 0; i < this.swingWaypointsForViz.size(); ++i) {
            this.swingWaypointsForViz.get(i).setToNaN();
        }
        this.adjustmentVelocityCorrection.setToZero();
        this.yoDesiredSolePosition.setToNaN();
        this.yoDesiredSoleOrientation.setToNaN();
        this.yoDesiredSoleLinearVelocity.setToNaN();
        this.yoDesiredSoleAngularVelocity.setToNaN();
        this.yoDesiredPosition.setToNaN();
        this.yoDesiredLinearVelocity.setToNaN();
        this.footstepWasAdjusted.set(false);
    }

    @Override
    public void doSpecificAction(double timeInState) {
        this.computeAndPackTrajectory(timeInState);
        if (this.workspaceLimiterControlModule != null) {
            this.desiredPose.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPosition, (FrameOrientation3DReadOnly)this.desiredOrientation);
            this.changeDesiredPoseBodyFrame((ReferenceFrame)this.controlFrame, this.ankleFrame, this.desiredPose);
            this.desiredAnklePosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
            this.workspaceLimiterControlModule.correctSwingFootTrajectory((FixedFramePoint3DBasics)this.desiredAnklePosition, (FixedFrameVector3DBasics)this.desiredLinearVelocity, (FixedFrameVector3DBasics)this.desiredLinearAcceleration);
            this.desiredPose.getPosition().set((FrameTuple3DReadOnly)this.desiredAnklePosition);
            this.changeDesiredPoseBodyFrame(this.ankleFrame, (ReferenceFrame)this.controlFrame, this.desiredPose);
            this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
        }
        if (this.yoSetDesiredVelocityToZero.getBooleanValue()) {
            this.desiredLinearVelocity.setToZero();
        }
        if (this.yoSetDesiredAccelerationToZero.getBooleanValue()) {
            this.desiredLinearAcceleration.setToZero();
        }
        this.computeCurrentWeights(this.nominalAngularWeight, this.nominalLinearWeight, (Vector3DBasics)this.currentAngularWeight, (Vector3DBasics)this.currentLinearWeight);
        this.spatialFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.spatialFeedbackControlCommand.setWeightsForSolver((Vector3DReadOnly)this.currentAngularWeight, (Vector3DReadOnly)this.currentLinearWeight);
        this.spatialFeedbackControlCommand.setScaleSecondaryTaskJointWeight(this.scaleSecondaryJointWeights.getBooleanValue(), this.secondaryJointWeightScale.getDoubleValue());
        this.spatialFeedbackControlCommand.setGains(this.gains);
        this.yoDesiredPosition.setMatchingFrame((FrameTuple3DReadOnly)this.desiredPosition);
        this.yoDesiredLinearVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
    }

    private void computeAndPackTrajectory(double timeInState) {
        double time;
        this.currentTime.set(timeInState);
        if (this.footstepWasAdjusted.getBooleanValue()) {
            if (!this.rateLimitedAdjustedPose.geometricallyEquals((FramePose3DReadOnly)this.adjustedFootstepPose, 1.0E-7)) {
                this.replanTrajectory.set(true);
            }
            this.rateLimitedAdjustedPose.update((FramePose3DReadOnly)this.adjustedFootstepPose);
        }
        if (!this.isSwingSpeedUpEnabled.getBooleanValue() || this.currentTimeWithSwingSpeedUp.isNaN()) {
            time = this.currentTime.getDoubleValue();
        } else {
            this.currentTimeWithSwingSpeedUp.add(this.swingTimeSpeedUpFactor.getDoubleValue() * this.controlDT);
            time = this.currentTimeWithSwingSpeedUp.getDoubleValue();
        }
        SoftTouchdownPoseTrajectoryGenerator activeTrajectory = time > this.swingDuration.getDoubleValue() ? this.touchdownTrajectory : this.blendedSwingTrajectory;
        boolean footstepWasAdjusted = false;
        if (this.replanTrajectory.getBooleanValue()) {
            activeTrajectory.compute(time);
            this.unadjustedPosition.setIncludingFrame((FrameTuple3DReadOnly)activeTrajectory.getPosition());
            footstepWasAdjusted = true;
        }
        if (this.swingTrajectoryCalculator.getActiveTrajectoryType() != TrajectoryType.WAYPOINTS && this.swingTrajectoryCalculator.doOptimizationUpdate()) {
            this.fillAndInitializeTrajectories(false);
            if (this.swingVisualizer != null) {
                this.swingVisualizer.visualize();
            }
        } else if (this.replanTrajectory.getBooleanValue()) {
            this.fillAndInitializeBlendedTrajectories();
        }
        this.replanTrajectory.set(false);
        activeTrajectory.compute(time);
        activeTrajectory.getLinearData((FramePoint3DBasics)this.desiredPosition, (FrameVector3DBasics)this.desiredLinearVelocity, (FrameVector3DBasics)this.desiredLinearAcceleration);
        activeTrajectory.getAngularData((FrameOrientation3DBasics)this.desiredOrientation, (FrameVector3DBasics)this.desiredAngularVelocity, (FrameVector3DBasics)this.desiredAngularAcceleration);
        this.leapOfFaithModule.compute(time);
        if (this.isSwingSpeedUpEnabled.getBooleanValue() && !this.currentTimeWithSwingSpeedUp.isNaN()) {
            this.desiredLinearVelocity.scale(this.swingTimeSpeedUpFactor.getDoubleValue());
            this.desiredAngularVelocity.scale(this.swingTimeSpeedUpFactor.getDoubleValue());
            double speedUpFactorSquared = this.swingTimeSpeedUpFactor.getDoubleValue() * this.swingTimeSpeedUpFactor.getDoubleValue();
            this.desiredLinearAcceleration.scale(speedUpFactorSquared);
            this.desiredAngularAcceleration.scale(speedUpFactorSquared);
        }
        if (footstepWasAdjusted) {
            this.adjustmentVelocityCorrection.set((FrameTuple3DReadOnly)this.desiredPosition);
            this.adjustmentVelocityCorrection.sub((FrameTuple3DReadOnly)this.unadjustedPosition);
            this.adjustmentVelocityCorrection.scale(1.0 / this.controlDT);
            this.adjustmentVelocityCorrection.setZ(0.0);
            this.adjustmentVelocityCorrection.scale(this.swingTrajectoryParameters.getSwingFootVelocityAdjustmentDamping());
            this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.adjustmentVelocityCorrection);
        } else {
            this.adjustmentVelocityCorrection.setToZero();
        }
        this.yoDesiredSolePosition.setMatchingFrame((FrameTuple3DReadOnly)this.desiredPosition);
        this.yoDesiredSoleOrientation.setMatchingFrame((FrameQuaternionReadOnly)this.desiredOrientation);
        this.yoDesiredSoleLinearVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoDesiredSoleAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.desiredAngularVelocity);
        this.currentTrajectoryWaypoint.set(this.blendedSwingTrajectory.getCurrentPositionWaypointIndex());
        this.transformDesiredsFromSoleFrameToControlFrame();
        this.secondaryJointWeightScale.set(this.computeSecondaryJointWeightScale(time));
    }

    public void setFootstep(Footstep footstep, double swingTime) {
        this.setFootstep(footstep, swingTime, null, null);
    }

    public void setFootstep(Footstep footstep, double swingTime, FrameVector3DReadOnly finalCoMVelocity, FrameVector3DReadOnly finalCoMAcceleration) {
        this.swingTrajectoryCalculator.setFootstep(footstep);
        if (finalCoMVelocity != null) {
            this.swingTrajectoryCalculator.setFinalCoMVelocity(finalCoMVelocity);
        }
        if (finalCoMAcceleration != null) {
            this.touchdownDesiredLinearAcceleration.set((FrameTuple3DReadOnly)this.swingTrajectoryParameters.getDesiredTouchdownAcceleration());
            this.touchdownDesiredLinearAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)finalCoMAcceleration);
            double injectionRatio = this.swingTrajectoryParameters.getFinalCoMAccelerationInjectionRatio();
            this.touchdownDesiredLinearAcceleration.addX(injectionRatio * finalCoMAcceleration.getX());
            this.touchdownDesiredLinearAcceleration.addY(injectionRatio * finalCoMAcceleration.getY());
        }
        this.setFootstepInternal(footstep);
        this.setFootstepDurationInternal(swingTime);
        this.adjustedFootstepPose.set(this.footstepPose);
        this.rateLimitedAdjustedPose.set((FramePose3DReadOnly)this.footstepPose);
    }

    public double requestSwingSpeedUp(double speedUpFactor) {
        if (this.isSwingSpeedUpEnabled.getBooleanValue() && speedUpFactor > 1.1 && speedUpFactor > this.swingTimeSpeedUpFactor.getDoubleValue()) {
            speedUpFactor = MathTools.clamp((double)speedUpFactor, (double)this.swingTimeSpeedUpFactor.getDoubleValue(), (double)this.maxSwingTimeSpeedUpFactor.getDoubleValue());
            this.swingTimeSpeedUpFactor.set(speedUpFactor);
            if (this.currentTimeWithSwingSpeedUp.isNaN()) {
                this.currentTimeWithSwingSpeedUp.set(this.currentTime.getDoubleValue());
            }
        }
        return this.computeSwingTimeRemaining(this.currentTime.getDoubleValue());
    }

    public void setAdjustedFootstepAndTime(Footstep adjustedFootstep, double swingTime) {
        this.replanTrajectory.set(true);
        this.footstepWasAdjusted.set(true);
        this.adjustedFootstepPose.setIncludingFrame((FramePose3DReadOnly)adjustedFootstep.getFootstepPose());
        this.setFootstepDurationInternal(swingTime);
    }

    private void fillAndInitializeTrajectories(boolean initializeOptimizer) {
        this.swingTrajectoryCalculator.initializeTrajectoryWaypoints(initializeOptimizer);
        this.actualDesiredTouchdownVelocity.set((Tuple3DReadOnly)this.swingTrajectoryCalculator.getFinalLinearVelocity());
        this.touchdownTrajectory.setLinearTrajectory(this.swingDuration.getDoubleValue(), (FramePoint3DReadOnly)this.footstepPose.getPosition(), this.swingTrajectoryCalculator.getFinalLinearVelocity(), (FrameVector3DReadOnly)this.touchdownDesiredLinearAcceleration);
        this.touchdownTrajectory.setOrientation((FrameQuaternionReadOnly)this.footstepPose.getOrientation(), this.finalAngularVelocity);
        this.fillAndInitializeBlendedTrajectories();
    }

    private void fillAndInitializeBlendedTrajectories() {
        double swingDuration = this.swingDuration.getDoubleValue();
        this.blendedSwingTrajectory.clear();
        if (this.swingVisualizer != null) {
            this.swingVisualizer.hideVisualization();
        }
        if (this.swingTrajectoryBlendDuration > 0.0) {
            this.initialPose.changeFrame(worldFrame);
            this.blendedSwingTrajectory.blendInitialConstraint((FramePose3DReadOnly)this.initialPose, 0.0, this.swingTrajectoryBlendDuration);
        }
        if (this.footstepWasAdjusted.getBooleanValue()) {
            FrameSE3TrajectoryPointBasics lastSwingWaypoint = this.swingTrajectoryCalculator.getLastSwingWaypoint();
            if (this.swingTrajectoryCalculator.getActiveTrajectoryType() == TrajectoryType.WAYPOINTS && Precision.equals((double)lastSwingWaypoint.getTime(), (double)swingDuration)) {
                this.footstepFrame.setPoseAndUpdate((FramePose3DReadOnly)this.footstepPose);
                this.adjustedFootstepFrame.setPoseAndUpdate((FramePose3DReadOnly)this.rateLimitedAdjustedPose);
                lastSwingWaypoint.getPose((FixedFramePose3DBasics)this.adjustedWaypoint);
                this.adjustedWaypoint.changeFrame((ReferenceFrame)this.footstepFrame);
                this.adjustedWaypoint.setReferenceFrame((ReferenceFrame)this.adjustedFootstepFrame);
                this.adjustedWaypoint.changeFrame(worldFrame);
                this.blendedSwingTrajectory.blendFinalConstraint((FramePose3DReadOnly)this.adjustedWaypoint, swingDuration, swingDuration);
                this.touchdownTrajectory.setLinearTrajectory(swingDuration, (FramePoint3DReadOnly)this.adjustedWaypoint.getPosition(), this.swingTrajectoryCalculator.getFinalLinearVelocity(), (FrameVector3DReadOnly)this.touchdownDesiredLinearAcceleration);
                this.touchdownTrajectory.setOrientation((FrameQuaternionReadOnly)this.adjustedWaypoint.getOrientation());
            } else {
                this.blendedSwingTrajectory.blendFinalConstraint((FramePose3DReadOnly)this.rateLimitedAdjustedPose, swingDuration, swingDuration);
                this.touchdownTrajectory.setLinearTrajectory(swingDuration, (FramePoint3DReadOnly)this.rateLimitedAdjustedPose.getPosition(), this.swingTrajectoryCalculator.getFinalLinearVelocity(), (FrameVector3DReadOnly)this.touchdownDesiredLinearAcceleration);
                this.touchdownTrajectory.setOrientation((FrameQuaternionReadOnly)this.rateLimitedAdjustedPose.getOrientation());
            }
        }
        this.blendedSwingTrajectory.initialize();
        this.touchdownTrajectory.initialize();
        if (this.swingVisualizer != null) {
            this.swingVisualizer.visualize();
        }
        if (!this.swingWaypointsForViz.isEmpty() && this.swingTrajectoryCalculator.getActiveTrajectoryType() == TrajectoryType.WAYPOINTS) {
            for (int i = 0; i < this.swingTrajectoryCalculator.getNumberOfSwingWaypoints(); ++i) {
                this.blendedSwingTrajectory.compute(this.swingTrajectoryCalculator.getSwingWaypoint(i).getTime());
                this.swingWaypointsForViz.get(i).setMatchingFrame((FrameTuple3DReadOnly)this.blendedSwingTrajectory.getPosition());
            }
        }
    }

    private void computeCurrentWeights(Vector3DReadOnly nominalAngularWeight, Vector3DReadOnly nominalLinearWeight, Vector3DBasics currentAngularWeightToPack, Vector3DBasics currentLinearWeightToPack) {
        currentAngularWeightToPack.set((Tuple3DReadOnly)nominalAngularWeight);
        this.leapOfFaithModule.scaleFootWeight(nominalLinearWeight, currentLinearWeightToPack);
    }

    private void transformDesiredsFromSoleFrameToControlFrame() {
        this.desiredSoleFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.desiredPosition, (FrameOrientation3DReadOnly)this.desiredOrientation);
        this.desiredPose.setToZero((ReferenceFrame)this.desiredControlFrame);
        this.desiredPose.changeFrame(worldFrame);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPose.getOrientation());
        this.desiredLinearVelocity.changeFrame((ReferenceFrame)this.desiredSoleFrame);
        this.desiredAngularVelocity.changeFrame((ReferenceFrame)this.desiredSoleFrame);
        this.desiredTwist.setIncludingFrame((ReferenceFrame)this.desiredSoleFrame, worldFrame, (ReferenceFrame)this.desiredSoleFrame, (Vector3DReadOnly)this.desiredAngularVelocity, (Vector3DReadOnly)this.desiredLinearVelocity);
        this.desiredTwist.changeFrame((ReferenceFrame)this.desiredControlFrame);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredTwist.getLinearPart());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredTwist.getAngularPart());
        this.desiredLinearVelocity.changeFrame(worldFrame);
        this.desiredAngularVelocity.changeFrame(worldFrame);
        this.desiredLinearAcceleration.changeFrame((ReferenceFrame)this.desiredSoleFrame);
        this.desiredAngularAcceleration.changeFrame((ReferenceFrame)this.desiredSoleFrame);
        this.desiredSpatialAcceleration.setIncludingFrame((ReferenceFrame)this.desiredSoleFrame, worldFrame, (ReferenceFrame)this.desiredSoleFrame, (Vector3DReadOnly)this.desiredAngularAcceleration, (Vector3DReadOnly)this.desiredLinearAcceleration);
        this.desiredSpatialAcceleration.changeFrame((ReferenceFrame)this.desiredControlFrame);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredSpatialAcceleration.getLinearPart());
        this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredSpatialAcceleration.getAngularPart());
        this.desiredLinearAcceleration.changeFrame(worldFrame);
        this.desiredAngularAcceleration.changeFrame(worldFrame);
    }

    private void setFootstepDurationInternal(double swingTime) {
        this.swingDuration.set(swingTime);
        this.swingTrajectoryCalculator.setSwingDuration(swingTime);
        this.maxSwingTimeSpeedUpFactor.set(Math.max(swingTime / this.minSwingTimeForDisturbanceRecovery.getDoubleValue(), 1.0));
    }

    private void setFootstepInternal(Footstep footstep) {
        footstep.getPose(this.footstepPose);
        this.footstepPose.changeFrame(worldFrame);
        this.footstepPose.setZ(this.footstepPose.getZ() + this.swingTrajectoryParameters.getDesiredTouchdownHeightOffset());
        this.swingTrajectoryBlendDuration = this.swingTrajectoryCalculator.getActiveTrajectoryType() == TrajectoryType.WAYPOINTS ? footstep.getSwingTrajectoryBlendDuration() : 0.0;
    }

    public double getSwingTimeRemaining() {
        return this.computeSwingTimeRemaining(this.currentTime.getValue());
    }

    public double getFractionThroughSwing() {
        if (!this.currentTimeWithSwingSpeedUp.isNaN()) {
            return this.currentTimeWithSwingSpeedUp.getDoubleValue() / this.swingDuration.getValue();
        }
        return this.currentTime.getDoubleValue() / this.swingDuration.getValue();
    }

    private double computeSwingTimeRemaining(double timeInState) {
        double swingDuration = this.swingDuration.getDoubleValue();
        if (!this.currentTimeWithSwingSpeedUp.isNaN()) {
            double swingTimeRemaining = (swingDuration - this.currentTimeWithSwingSpeedUp.getDoubleValue()) / this.swingTimeSpeedUpFactor.getDoubleValue();
            return swingTimeRemaining;
        }
        return swingDuration - timeInState;
    }

    private double computeSecondaryJointWeightScale(double timeInState) {
        double phaseInSwingState = timeInState / this.swingDuration.getDoubleValue();
        double scaleFactor = timeInState < this.swingDuration.getDoubleValue() ? 1.4 * (1.0 - Math.exp(-5.0 * phaseInSwingState)) + 0.1 : (1.0 + 0.1 * (timeInState - this.swingDuration.getDoubleValue())) * 1.5;
        return scaleFactor;
    }

    private void changeControlFrame(FramePose3D controlFramePoseInEndEffector) {
        controlFramePoseInEndEffector.checkReferenceFrameMatch((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.spatialFeedbackControlCommand.setControlFrameFixedInEndEffector((FramePose3DReadOnly)controlFramePoseInEndEffector);
        this.controlFrame.setPoseAndUpdate((FramePose3DReadOnly)controlFramePoseInEndEffector);
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.nominalAngularWeight = angularWeight;
        this.nominalLinearWeight = linearWeight;
    }

    private void changeDesiredPoseBodyFrame(ReferenceFrame oldBodyFrame, ReferenceFrame newBodyFrame, FramePose3D framePoseToModify) {
        if (oldBodyFrame == newBodyFrame) {
            return;
        }
        framePoseToModify.get((RigidBodyTransformBasics)this.oldBodyFrameDesiredTransform);
        newBodyFrame.getTransformToDesiredFrame(this.transformFromNewBodyFrameToOldBodyFrame, oldBodyFrame);
        this.newBodyFrameDesiredTransform.set(this.oldBodyFrameDesiredTransform);
        this.newBodyFrameDesiredTransform.multiply((RigidBodyTransformReadOnly)this.transformFromNewBodyFrameToOldBodyFrame);
        framePoseToModify.set((RigidBodyTransformReadOnly)this.newBodyFrameDesiredTransform);
    }

    public MultipleWaypointsPoseTrajectoryGenerator getSwingTrajectory() {
        return this.swingTrajectoryCalculator.getSwingTrajectory();
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return null;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return this.spatialFeedbackControlCommand;
    }
}

