/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ToeSlippingDetector;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.math.filters.RateLimitedYoFramePoint2D;
import us.ihmc.robotics.referenceFrames.TranslationReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class OnToesState
extends AbstractFootControlState {
    private final SpatialFeedbackControlCommand feedbackControlCommand = new SpatialFeedbackControlCommand();
    private final SpatialAccelerationCommand zeroAccelerationCommand = new SpatialAccelerationCommand();
    private final FramePoint3D desiredContactPointPosition = new FramePoint3D();
    private final ToeOffCalculator toeOffCalculator;
    private final Twist footTwist = new Twist();
    private final FrameQuaternion startOrientation = new FrameQuaternion();
    private final YawPitchRoll tempYawPitchRoll = new YawPitchRoll();
    private final FramePoint3D contactPointPosition = new FramePoint3D();
    private final List<YoContactPoint> contactPoints = this.controllerToolbox.getFootContactState(this.robotSide).getContactPoints();
    private final List<RateLimitedYoFramePoint2D> contactPointLocations = new ArrayList<RateLimitedYoFramePoint2D>();
    private final DoubleParameter maxContactPointRate;
    private final YoBoolean usePointContact;
    private final YoDouble toeOffDesiredPitchAngle;
    private final YoDouble toeOffDesiredPitchVelocity;
    private final YoDouble toeOffDesiredPitchAcceleration;
    private final YoDouble toeOffCurrentPitchAngle;
    private final YoDouble toeOffCurrentPitchVelocity;
    private final FramePoint2D toeOffContactPoint2d = new FramePoint2D();
    private final FrameLineSegment2D toeOffContactLine2d = new FrameLineSegment2D();
    private final TranslationReferenceFrame toeOffFrame;
    private final ReferenceFrame soleZUpFrame;
    private Vector3DReadOnly angularWeight;
    private Vector3DReadOnly linearWeight;
    private final PIDSE3GainsReadOnly gains;
    private final FramePoint2D tmpCurrentLocation = new FramePoint2D();

    public OnToesState(FootControlHelper footControlHelper, ToeOffCalculator toeOffCalculator, PIDSE3GainsReadOnly gains, YoRegistry registry) {
        super(footControlHelper);
        this.toeOffCalculator = toeOffCalculator;
        this.gains = gains;
        String namePrefix = this.contactableFoot.getName();
        this.contactableFoot.getToeOffContactPoint(this.toeOffContactPoint2d);
        this.contactableFoot.getToeOffContactLine(this.toeOffContactLine2d);
        this.usePointContact = new YoBoolean(namePrefix + "UsePointContact", registry);
        this.toeOffDesiredPitchAngle = new YoDouble(namePrefix + "ToeOffDesiredPitchAngle", registry);
        this.toeOffDesiredPitchVelocity = new YoDouble(namePrefix + "ToeOffDesiredPitchVelocity", registry);
        this.toeOffDesiredPitchAcceleration = new YoDouble(namePrefix + "ToeOffDesiredPitchAcceleration", registry);
        this.toeOffCurrentPitchAngle = new YoDouble(namePrefix + "ToeOffCurrentPitchAngle", registry);
        this.toeOffCurrentPitchVelocity = new YoDouble(namePrefix + "ToeOffCurrentPitchVelocity", registry);
        this.maxContactPointRate = new DoubleParameter("maxContactPointRate", registry, Double.POSITIVE_INFINITY);
        for (YoContactPoint contactPoint : this.contactPoints) {
            this.contactPointLocations.add(new RateLimitedYoFramePoint2D(contactPoint.getNamePrefix(), contactPoint.getNameSuffix() + "Limited", registry, (DoubleProvider)this.maxContactPointRate, this.controllerToolbox.getControlDT(), contactPoint.getReferenceFrame()));
        }
        this.toeOffDesiredPitchAngle.set(Double.NaN);
        this.toeOffDesiredPitchVelocity.set(Double.NaN);
        this.toeOffDesiredPitchAcceleration.set(Double.NaN);
        this.toeOffCurrentPitchAngle.set(Double.NaN);
        this.toeOffCurrentPitchVelocity.set(Double.NaN);
        this.toeOffFrame = new TranslationReferenceFrame(namePrefix + "ToeOffFrame", (ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.soleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)this.robotSide);
        this.feedbackControlCommand.setWeightForSolver(10.0);
        this.feedbackControlCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.feedbackControlCommand.setPrimaryBase(this.pelvis);
        this.zeroAccelerationCommand.setWeight(10.0);
        this.zeroAccelerationCommand.set(this.rootBody, this.contactableFoot.getRigidBody());
        this.zeroAccelerationCommand.setPrimaryBase(this.pelvis);
        SelectionMatrix6D feedbackControlSelectionMatrix = new SelectionMatrix6D();
        feedbackControlSelectionMatrix.setSelectionFrames(this.contactableFoot.getSoleFrame(), worldFrame);
        feedbackControlSelectionMatrix.selectLinearZ(false);
        feedbackControlSelectionMatrix.selectAngularY(false);
        this.feedbackControlCommand.setSelectionMatrix(feedbackControlSelectionMatrix);
        SelectionMatrix6D zeroAccelerationSelectionMatrix = new SelectionMatrix6D();
        zeroAccelerationSelectionMatrix.clearSelection();
        zeroAccelerationSelectionMatrix.setSelectionFrames(worldFrame, worldFrame);
        zeroAccelerationSelectionMatrix.selectLinearZ(true);
        this.zeroAccelerationCommand.setSelectionMatrix(zeroAccelerationSelectionMatrix);
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.angularWeight = angularWeight;
        this.linearWeight = linearWeight;
    }

    public void setUsePointContact(boolean usePointContact) {
        this.usePointContact.set(usePointContact);
    }

    public boolean isUsingPointContact() {
        return this.usePointContact.getBooleanValue();
    }

    @Override
    public void doSpecificAction(double timeInState) {
        this.updateCurrentYoVariables();
        this.updateToeSlippingDetector();
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.startOrientation);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredContactPointPosition);
        this.desiredOrientation.changeFrame(worldFrame);
        this.desiredAngularVelocity.setToZero(worldFrame);
        this.desiredAngularAcceleration.setToZero(worldFrame);
        this.desiredPosition.changeFrame(worldFrame);
        this.desiredLinearVelocity.setToZero(worldFrame);
        this.desiredLinearAcceleration.setToZero(worldFrame);
        this.feedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.zeroAccelerationCommand.setSpatialAccelerationToZero((ReferenceFrame)this.toeOffFrame);
        this.feedbackControlCommand.setGains(this.gains);
        this.feedbackControlCommand.setWeightsForSolver(this.angularWeight, this.linearWeight);
        this.zeroAccelerationCommand.setWeights((Tuple3DReadOnly)this.angularWeight, (Tuple3DReadOnly)this.linearWeight);
        if (this.usePointContact.getBooleanValue()) {
            this.setupSingleContactPoint();
        } else {
            this.setupContactLine();
        }
    }

    private void updateCurrentYoVariables() {
        this.desiredOrientation.setToZero((ReferenceFrame)this.contactableFoot.getFrameAfterParentJoint());
        this.desiredOrientation.changeFrame(this.soleZUpFrame);
        this.tempYawPitchRoll.set((Orientation3DReadOnly)this.desiredOrientation);
        double currentPitch = this.tempYawPitchRoll.getPitch();
        if (!Double.isNaN(currentPitch)) {
            this.toeOffCurrentPitchAngle.set(this.tempYawPitchRoll.getPitch());
        }
        this.contactableFoot.getFrameAfterParentJoint().getTwistOfFrame((TwistBasics)this.footTwist);
        this.toeOffCurrentPitchVelocity.set(this.footTwist.getAngularPartY());
    }

    private void updateToeSlippingDetector() {
        ToeSlippingDetector toeSlippingDetector = this.footControlHelper.getToeSlippingDetector();
        if (toeSlippingDetector != null) {
            toeSlippingDetector.update();
        }
    }

    public void getDesireds(FrameQuaternion desiredOrientationToPack, FrameVector3D desiredAngularVelocityToPack) {
        desiredOrientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.desiredOrientation);
        desiredAngularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.desiredAngularVelocity);
    }

    private void setupSingleContactPoint() {
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            this.contactPointLocations.get(i).update((FrameTuple2DReadOnly)this.toeOffContactPoint2d);
            this.contactPoints.get(i).set((FrameTuple2DReadOnly)this.contactPointLocations.get(i));
        }
    }

    private void setupContactLine() {
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            YoContactPoint contactPointInContact = this.contactPoints.get(i);
            RateLimitedYoFramePoint2D contactPointLocation = this.contactPointLocations.get(i);
            this.tmpCurrentLocation.setIncludingFrame((FrameTuple3DReadOnly)contactPointInContact);
            if (this.toeOffContactLine2d.getFirstEndpoint().distance((FramePoint2DReadOnly)this.tmpCurrentLocation) < this.toeOffContactLine2d.getSecondEndpoint().distance((FramePoint2DReadOnly)this.tmpCurrentLocation)) {
                contactPointLocation.update((FrameTuple2DReadOnly)this.toeOffContactLine2d.getFirstEndpoint());
            } else {
                contactPointLocation.update((FrameTuple2DReadOnly)this.toeOffContactLine2d.getSecondEndpoint());
            }
            contactPointInContact.set((FrameTuple2DReadOnly)contactPointLocation);
        }
    }

    private void setControlPointPositionFromContactPoint() {
        this.toeOffCalculator.getToeOffContactPoint((FramePoint2DBasics)this.toeOffContactPoint2d, this.robotSide);
        this.contactPointPosition.setIncludingFrame((FrameTuple2DReadOnly)this.toeOffContactPoint2d, 0.0);
        this.contactPointPosition.changeFrame((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.feedbackControlCommand.setControlFrameFixedInEndEffector((FramePoint3DReadOnly)this.contactPointPosition);
        this.toeOffFrame.updateTranslation((FrameTuple3DReadOnly)this.contactPointPosition);
        this.desiredContactPointPosition.setIncludingFrame((FrameTuple2DReadOnly)this.toeOffContactPoint2d, 0.0);
        this.desiredContactPointPosition.changeFrame(worldFrame);
    }

    private void setControlPointPositionFromContactLine() {
        this.toeOffCalculator.getToeOffContactLine((FrameLineSegment2DBasics)this.toeOffContactLine2d, this.robotSide);
        this.toeOffContactLine2d.midpoint((FramePoint2DBasics)this.toeOffContactPoint2d);
        this.contactPointPosition.setIncludingFrame((FrameTuple2DReadOnly)this.toeOffContactPoint2d, 0.0);
        this.contactPointPosition.changeFrame((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.toeOffFrame.updateTranslation((FrameTuple3DReadOnly)this.contactPointPosition);
        this.feedbackControlCommand.setControlFrameFixedInEndEffector((FramePoint3DReadOnly)this.contactPointPosition);
        this.desiredContactPointPosition.setIncludingFrame((FrameTuple2DReadOnly)this.toeOffContactPoint2d, 0.0);
        this.desiredContactPointPosition.changeFrame(worldFrame);
    }

    @Override
    public void onEntry() {
        super.onEntry();
        for (int contactIndex = 0; contactIndex < this.contactPoints.size(); ++contactIndex) {
            this.contactPointLocations.get(contactIndex).setAndUpdate((FramePoint3DReadOnly)this.contactPoints.get(contactIndex));
        }
        if (this.usePointContact.getBooleanValue()) {
            this.setControlPointPositionFromContactPoint();
        } else {
            this.setControlPointPositionFromContactLine();
        }
        YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
        contactState.notifyContactStateHasChanged();
        this.startOrientation.setToZero((ReferenceFrame)this.contactableFoot.getFrameAfterParentJoint());
        this.startOrientation.changeFrame(worldFrame);
        ToeSlippingDetector toeSlippingDetector = this.footControlHelper.getToeSlippingDetector();
        if (toeSlippingDetector != null) {
            toeSlippingDetector.initialize(this.contactPointPosition);
        }
    }

    @Override
    public void onExit() {
        super.onExit();
        this.toeOffDesiredPitchAngle.set(Double.NaN);
        this.toeOffDesiredPitchVelocity.set(Double.NaN);
        this.toeOffDesiredPitchAcceleration.set(Double.NaN);
        this.toeOffCurrentPitchAngle.set(Double.NaN);
        this.toeOffCurrentPitchVelocity.set(Double.NaN);
        this.toeOffCalculator.clear();
        ToeSlippingDetector toeSlippingDetector = this.footControlHelper.getToeSlippingDetector();
        if (toeSlippingDetector != null) {
            toeSlippingDetector.clear();
        }
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return this.zeroAccelerationCommand;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return this.feedbackControlCommand;
    }
}

