/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.foot.AbstractFootControlState;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyPoseController;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.trajectories.SoftTouchdownPositionTrajectoryGenerator;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class MoveViaWaypointsState
extends AbstractFootControlState {
    private final YoBoolean isPerformingTouchdown;
    private final SoftTouchdownPositionTrajectoryGenerator positionTrajectoryForDisturbanceRecovery;
    private final RigidBodyPoseController poseController;
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private Vector3DReadOnly angularWeight;
    private Vector3DReadOnly linearWeight;
    private final FrameVector3DReadOnly touchdownVelocity;
    private final FrameVector3DReadOnly touchdownAcceleration;
    private ReferenceFrame controlFrame;
    private final ReferenceFrame ankleFrame;
    private final WorkspaceLimiterControlModule workspaceLimiterControlModule;
    private final PIDSE3GainsReadOnly gains;
    private final FramePoint3D desiredAnklePosition = new FramePoint3D();
    private final FramePose3D desiredPose = new FramePose3D();
    private final RigidBodyTransform oldBodyFrameDesiredTransform = new RigidBodyTransform();
    private final RigidBodyTransform newBodyFrameDesiredTransform = new RigidBodyTransform();
    private final RigidBodyTransform transformFromNewBodyFrameToOldBodyFrame = new RigidBodyTransform();

    public MoveViaWaypointsState(FootControlHelper footControlHelper, PIDSE3GainsReadOnly gains, YoRegistry registry) {
        super(footControlHelper);
        this.gains = gains;
        this.touchdownVelocity = footControlHelper.getSwingTrajectoryParameters().getDesiredTouchdownVelocity();
        this.touchdownAcceleration = footControlHelper.getSwingTrajectoryParameters().getDesiredTouchdownAcceleration();
        RigidBodyBasics foot = this.controllerToolbox.getFullRobotModel().getFoot((Enum)this.robotSide);
        String namePrefix = foot.getName() + "MoveViaWaypoints";
        this.isPerformingTouchdown = new YoBoolean(namePrefix + "IsPerformingTouchdown", registry);
        this.positionTrajectoryForDisturbanceRecovery = new SoftTouchdownPositionTrajectoryGenerator(namePrefix + "Touchdown", registry);
        YoDouble yoTime = this.controllerToolbox.getYoTime();
        YoGraphicsListRegistry graphicsListRegistry = this.controllerToolbox.getYoGraphicsListRegistry();
        MovingReferenceFrame pelvisFrame = this.pelvis.getBodyFixedFrame();
        this.controlFrame = this.ankleFrame = foot.getParentJoint().getFrameAfterJoint();
        this.poseController = new RigidBodyPoseController(foot, this.pelvis, this.rootBody, this.controlFrame, (ReferenceFrame)pelvisFrame, yoTime, null, graphicsListRegistry, registry);
        this.poseController.setGains(gains.getOrientationGains(), gains.getPositionGains());
        this.spatialFeedbackControlCommand.set(this.rootBody, foot);
        this.spatialFeedbackControlCommand.setPrimaryBase(this.pelvis);
        this.workspaceLimiterControlModule = footControlHelper.getWorkspaceLimiterControlModule();
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.angularWeight = angularWeight;
        this.linearWeight = linearWeight;
        this.poseController.setWeights(angularWeight, linearWeight);
    }

    public void holdCurrentPosition() {
        this.poseController.holdCurrent();
    }

    public void handleFootTrajectoryCommand(FootTrajectoryCommand command) {
        SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
        se3Trajectory.setSequenceId(command.getSequenceId());
        if (!this.poseController.handleTrajectoryCommand(se3Trajectory)) {
            this.poseController.holdCurrent();
        }
    }

    @Override
    public void onEntry() {
        this.poseController.onEntry();
        this.isPerformingTouchdown.set(false);
        if (this.workspaceLimiterControlModule != null) {
            this.workspaceLimiterControlModule.setCheckVelocityForSwingSingularityAvoidance(false);
        }
    }

    @Override
    public void doSpecificAction(double timeInState) {
        if (this.isPerformingTouchdown.getBooleanValue()) {
            this.positionTrajectoryForDisturbanceRecovery.compute(timeInState);
            this.positionTrajectoryForDisturbanceRecovery.getLinearData((FramePoint3DBasics)this.desiredPosition, (FrameVector3DBasics)this.desiredLinearVelocity, (FrameVector3DBasics)this.desiredLinearAcceleration);
            this.desiredAngularVelocity.setToZero();
            this.desiredAngularAcceleration.setToZero();
            this.packCommandForTouchdown();
        } else {
            this.poseController.doAction(timeInState);
            this.spatialFeedbackControlCommand.set((SpatialFeedbackControlCommand)this.poseController.getFeedbackControlCommand());
            if (this.poseController.abortState()) {
                this.requestTouchdownForDisturbanceRecovery(timeInState);
            }
        }
        this.doSingularityAvoidance(this.spatialFeedbackControlCommand);
    }

    private void packCommandForTouchdown() {
        this.spatialFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.spatialFeedbackControlCommand.setWeightsForSolver(this.angularWeight, this.linearWeight);
        this.spatialFeedbackControlCommand.setGains(this.gains);
    }

    public void requestTouchdownForDisturbanceRecovery(double timeInState) {
        if (this.isPerformingTouchdown.getBooleanValue()) {
            return;
        }
        this.desiredPosition.setToZero(this.controlFrame);
        this.desiredOrientation.setToZero(this.controlFrame);
        this.desiredPosition.changeFrame(worldFrame);
        this.desiredOrientation.changeFrame(worldFrame);
        this.positionTrajectoryForDisturbanceRecovery.setLinearTrajectory(timeInState, (FramePoint3DReadOnly)this.desiredAnklePosition, this.touchdownVelocity, this.touchdownAcceleration);
        this.positionTrajectoryForDisturbanceRecovery.initialize();
        this.isPerformingTouchdown.set(true);
    }

    private void doSingularityAvoidance(SpatialFeedbackControlCommand spatialFeedbackControlCommand) {
        if (this.workspaceLimiterControlModule != null) {
            this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)spatialFeedbackControlCommand.getReferencePosition());
            this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)spatialFeedbackControlCommand.getReferenceOrientation());
            this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)spatialFeedbackControlCommand.getReferenceLinearVelocity());
            this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)spatialFeedbackControlCommand.getReferenceAngularVelocity());
            this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)spatialFeedbackControlCommand.getReferenceLinearAcceleration());
            this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)spatialFeedbackControlCommand.getReferenceAngularAcceleration());
            this.desiredPose.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPosition, (FrameOrientation3DReadOnly)this.desiredOrientation);
            this.changeDesiredPoseBodyFrame(this.controlFrame, this.ankleFrame, this.desiredPose);
            this.desiredAnklePosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
            this.workspaceLimiterControlModule.update();
            this.workspaceLimiterControlModule.correctSwingFootTrajectory((FixedFramePoint3DBasics)this.desiredAnklePosition, (FixedFrameVector3DBasics)this.desiredLinearVelocity, (FixedFrameVector3DBasics)this.desiredLinearAcceleration);
            this.desiredPose.getPosition().set((FrameTuple3DReadOnly)this.desiredAnklePosition);
            this.changeDesiredPoseBodyFrame(this.ankleFrame, this.controlFrame, this.desiredPose);
            this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
        }
        spatialFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
    }

    private void changeDesiredPoseBodyFrame(ReferenceFrame oldBodyFrame, ReferenceFrame newBodyFrame, FramePose3D framePoseToModify) {
        if (oldBodyFrame == newBodyFrame) {
            return;
        }
        framePoseToModify.get((RigidBodyTransformBasics)this.oldBodyFrameDesiredTransform);
        newBodyFrame.getTransformToDesiredFrame(this.transformFromNewBodyFrameToOldBodyFrame, oldBodyFrame);
        this.newBodyFrameDesiredTransform.set(this.oldBodyFrameDesiredTransform);
        this.newBodyFrameDesiredTransform.multiply((RigidBodyTransformReadOnly)this.transformFromNewBodyFrameToOldBodyFrame);
        framePoseToModify.set((RigidBodyTransformReadOnly)this.newBodyFrameDesiredTransform);
    }

    public void requestStopTrajectory() {
        this.poseController.holdCurrent();
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return null;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return this.spatialFeedbackControlCommand;
    }

    public void onExit(double timeInState) {
        this.poseController.onExit(timeInState);
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.poseController.pollStatusToReport();
    }
}

