/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class FootCoPOccupancyGrid {
    private static final boolean VISUALIZE = false;
    private static final double defaultThresholdForCellActivation = 1.0;
    private static final double defaultDecayRate = 1.0;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final YoInteger nLengthSubdivisions;
    private final YoInteger nWidthSubdivisions;
    private final YoDouble thresholdForCellActivation;
    private final YoInteger currentXIndex;
    private final YoInteger currentYIndex;
    private final YoBoolean areCurrentCoPIndicesValid;
    private final YoFramePoint3D[][] cellViz;
    private final YoFrameVector2D cellSize;
    private final YoDouble cellArea;
    private final ReferenceFrame soleFrame;
    private final Point2D tempPoint = new Point2D();
    private final FramePoint2D gridOrigin = new FramePoint2D();
    private final FrameConvexPolygon2D gridBoundaries = new FrameConvexPolygon2D();
    private final double footLength;
    private final double footWidth;
    private final DMatrixRMaj counterGrid = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj occupancyGrid = new DMatrixRMaj(1, 1);
    private final YoDouble decayRate;
    private final YoBoolean resetGridToEmpty;
    private final FramePoint3D cellPosition = new FramePoint3D();
    private final FrameLine2D shiftedLine = new FrameLine2D();
    private final FrameVector2D shiftedLineVector = new FrameVector2D();
    private final FramePoint2D shiftedLinePoint = new FramePoint2D();
    private final FrameVector2D shiftingVector = new FrameVector2D();
    private final FramePoint2D cellCenter = new FramePoint2D();
    private final FramePoint2D tempCellCenter = new FramePoint2D();
    private final PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
    private final DMatrixRMaj pointCloud = new DMatrixRMaj(0, 0);
    private final Point3D tempPoint3d = new Point3D();
    private final FramePoint2D lineOrigin = new FramePoint2D();
    private final Vector3D tempVector3d = new Vector3D();
    private final FrameVector2D lineDirection = new FrameVector2D();
    private final FramePoint2D pointA = new FramePoint2D();
    private final FramePoint2D pointB = new FramePoint2D();

    public FootCoPOccupancyGrid(String namePrefix, ReferenceFrame soleFrame, int nLengthSubdivisions, int nWidthSubdivisions, WalkingControllerParameters walkingControllerParameters, ExplorationParameters explorationParameters, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.footLength = walkingControllerParameters.getSteppingParameters().getFootLength();
        this.footWidth = walkingControllerParameters.getSteppingParameters().getFootWidth();
        this.soleFrame = soleFrame;
        this.gridOrigin.setIncludingFrame(soleFrame, -this.footLength, -this.footWidth);
        this.gridOrigin.scale(0.5);
        this.gridBoundaries.clear(soleFrame);
        this.gridBoundaries.addVertex((FramePoint2DReadOnly)new FramePoint2D(soleFrame, -this.footLength / 2.0, -this.footWidth / 2.0));
        this.gridBoundaries.addVertex((FramePoint2DReadOnly)new FramePoint2D(soleFrame, -this.footLength / 2.0, this.footWidth / 2.0));
        this.gridBoundaries.addVertex((FramePoint2DReadOnly)new FramePoint2D(soleFrame, this.footLength / 2.0, -this.footWidth / 2.0));
        this.gridBoundaries.addVertex((FramePoint2DReadOnly)new FramePoint2D(soleFrame, this.footLength / 2.0, this.footWidth / 2.0));
        this.gridBoundaries.update();
        this.registry = new YoRegistry(namePrefix + this.name);
        this.nLengthSubdivisions = new YoInteger(namePrefix + "NLengthSubdivisions", this.registry);
        this.nLengthSubdivisions.set(nLengthSubdivisions);
        this.nWidthSubdivisions = new YoInteger(namePrefix + "NWidthSubdivisions", this.registry);
        this.nWidthSubdivisions.set(nWidthSubdivisions);
        if (explorationParameters != null) {
            this.thresholdForCellActivation = explorationParameters.getCopGridThresholdForOccupancy();
            this.decayRate = explorationParameters.getCopGridDecayAlpha();
        } else {
            this.thresholdForCellActivation = new YoDouble(namePrefix + "ThresholdForCellActivation", this.registry);
            this.thresholdForCellActivation.set(1.0);
            this.decayRate = new YoDouble(namePrefix + "DecayRate", this.registry);
            this.decayRate.set(1.0);
        }
        this.resetGridToEmpty = new YoBoolean(namePrefix + this.name + "Reset", this.registry);
        this.resetGridToEmpty.set(false);
        this.currentXIndex = new YoInteger(namePrefix + "CurrentXIndex", this.registry);
        this.currentYIndex = new YoInteger(namePrefix + "CurrentYIndex", this.registry);
        this.areCurrentCoPIndicesValid = new YoBoolean(namePrefix + "IsCurrentCoPIndicesValid", this.registry);
        this.cellSize = new YoFrameVector2D(namePrefix + "CellSize", soleFrame, this.registry);
        this.cellArea = new YoDouble(namePrefix + "CellArea", this.registry);
        this.setupChangedGridParameterListeners();
        this.cellViz = null;
        parentRegistry.addChild(this.registry);
    }

    private void setupChangedGridParameterListeners() {
        YoVariableChangedListener changedGridSizeListener = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                FootCoPOccupancyGrid.this.counterGrid.reshape(FootCoPOccupancyGrid.this.nLengthSubdivisions.getIntegerValue(), FootCoPOccupancyGrid.this.nWidthSubdivisions.getIntegerValue());
                FootCoPOccupancyGrid.this.occupancyGrid.reshape(FootCoPOccupancyGrid.this.nLengthSubdivisions.getIntegerValue(), FootCoPOccupancyGrid.this.nWidthSubdivisions.getIntegerValue());
                FootCoPOccupancyGrid.this.cellSize.setX(FootCoPOccupancyGrid.this.footLength / (double)FootCoPOccupancyGrid.this.nLengthSubdivisions.getIntegerValue());
                FootCoPOccupancyGrid.this.cellSize.setY(FootCoPOccupancyGrid.this.footWidth / (double)FootCoPOccupancyGrid.this.nWidthSubdivisions.getIntegerValue());
                FootCoPOccupancyGrid.this.cellArea.set(FootCoPOccupancyGrid.this.cellSize.getX() * FootCoPOccupancyGrid.this.cellSize.getY());
            }
        };
        this.nLengthSubdivisions.addListener(changedGridSizeListener);
        this.nWidthSubdivisions.addListener(changedGridSizeListener);
        changedGridSizeListener.changed(null);
        YoVariableChangedListener changedThresholdForCellActivationListener = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                for (int i = 0; i < FootCoPOccupancyGrid.this.nLengthSubdivisions.getIntegerValue(); ++i) {
                    for (int j = 0; j < FootCoPOccupancyGrid.this.nWidthSubdivisions.getIntegerValue(); ++j) {
                        if (FootCoPOccupancyGrid.this.counterGrid.get(i, j) >= FootCoPOccupancyGrid.this.thresholdForCellActivation.getDoubleValue()) {
                            FootCoPOccupancyGrid.this.occupancyGrid.set(i, j, 1.0);
                            continue;
                        }
                        FootCoPOccupancyGrid.this.occupancyGrid.set(i, j, 0.0);
                    }
                }
            }
        };
        this.thresholdForCellActivation.addListener(changedThresholdForCellActivationListener);
        changedThresholdForCellActivationListener.changed(null);
        YoVariableChangedListener resetGridListener = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (FootCoPOccupancyGrid.this.resetGridToEmpty.getBooleanValue()) {
                    FootCoPOccupancyGrid.this.reset();
                }
                FootCoPOccupancyGrid.this.resetGridToEmpty.set(false);
            }
        };
        this.resetGridToEmpty.addListener(resetGridListener);
        resetGridListener.changed(null);
    }

    public void registerCenterOfPressureLocation(FramePoint2DReadOnly copToRegister) {
        copToRegister.checkReferenceFrameMatch(this.soleFrame);
        this.tempPoint.sub((Tuple2DReadOnly)copToRegister, (Tuple2DReadOnly)this.gridOrigin);
        int xIndex = this.findXIndex(this.tempPoint.getX());
        int yIndex = this.findYIndex(this.tempPoint.getY());
        this.currentXIndex.set(xIndex);
        this.currentYIndex.set(yIndex);
        this.areCurrentCoPIndicesValid.set(this.checkIfIndicesAreValid(xIndex, yIndex));
        if (this.areCurrentCoPIndicesValid.getBooleanValue()) {
            this.counterGrid.add(xIndex, yIndex, 1.0);
            if (this.counterGrid.get(xIndex, yIndex) >= this.thresholdForCellActivation.getDoubleValue()) {
                this.occupancyGrid.set(xIndex, yIndex, 1.0);
            } else {
                this.occupancyGrid.set(xIndex, yIndex, 0.0);
            }
        }
    }

    private boolean checkIfIndicesAreValid(int xIndex, int yIndex) {
        boolean isXIndexValid = xIndex < this.nLengthSubdivisions.getIntegerValue() && xIndex >= 0;
        boolean isYIndexValid = yIndex < this.nWidthSubdivisions.getIntegerValue() && yIndex >= 0;
        return isXIndexValid && isYIndexValid;
    }

    private int findXIndex(double x) {
        return (int)Math.floor(x / this.cellSize.getX());
    }

    private int findYIndex(double y) {
        return (int)Math.floor(y / this.cellSize.getY());
    }

    public boolean isCellOccupied(int xIndex, int yIndex) {
        return this.occupancyGrid.get(xIndex, yIndex) > 0.9;
    }

    public boolean isCellAtLocationOccupied(FramePoint2D location) {
        location.checkReferenceFrameMatch(this.soleFrame);
        this.tempPoint.sub((Tuple2DReadOnly)location, (Tuple2DReadOnly)this.gridOrigin);
        int xIndex = this.findXIndex(this.tempPoint.getX());
        int yIndex = this.findYIndex(this.tempPoint.getY());
        if (this.checkIfIndicesAreValid(xIndex, yIndex)) {
            return this.occupancyGrid.get(xIndex, yIndex) > 0.9;
        }
        return false;
    }

    public void getCellCenter(FramePoint2D cellCenter, int xIndex, int yIndex) {
        double x = this.getXCoordinateInSoleFrame(xIndex);
        double y = this.getYCoordinateInSoleFrame(yIndex);
        cellCenter.setIncludingFrame(this.soleFrame, x, y);
    }

    private double getXCoordinateInSoleFrame(int xIndex) {
        return ((double)xIndex + 0.5) * this.cellSize.getX() + this.gridOrigin.getX();
    }

    private double getYCoordinateInSoleFrame(int yIndex) {
        return ((double)yIndex + 0.5) * this.cellSize.getY() + this.gridOrigin.getY();
    }

    public boolean findCenterOfClosestCell(FramePoint2D centerOfClosestCellToPack, FramePoint2D closestToPoint) {
        int yIndex;
        int xIndex = this.findXIndex(closestToPoint.getX());
        if (!this.checkIfIndicesAreValid(xIndex, yIndex = this.findYIndex(closestToPoint.getY()))) {
            return false;
        }
        this.getCellCenter(centerOfClosestCellToPack, xIndex, yIndex);
        return true;
    }

    public int computeNumberOfCellsOccupiedOnSideOfLine(FrameLine2D frameLine, RobotSide sideToLookAt) {
        return this.computeNumberOfCellsOccupiedOnSideOfLine((FrameLine2DReadOnly)frameLine, sideToLookAt, 0.0);
    }

    public int computeNumberOfCellsOccupiedOnSideOfLine(FrameLine2DReadOnly frameLine, RobotSide sideToLookAt, double minDistanceFromLine) {
        frameLine.checkReferenceFrameMatch(this.soleFrame);
        this.shiftingVector.setIncludingFrame((FrameTuple2DReadOnly)frameLine.getDirection());
        this.shiftedLinePoint.setIncludingFrame((FrameTuple2DReadOnly)frameLine.getPoint());
        this.shiftedLineVector.setIncludingFrame((FrameTuple2DReadOnly)frameLine.getDirection());
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)this.shiftingVector, (Vector2DBasics)this.shiftingVector);
        if (sideToLookAt == RobotSide.RIGHT) {
            this.shiftingVector.negate();
        }
        double theta = Math.atan2(this.shiftedLineVector.getY(), this.shiftedLineVector.getX());
        double distanceToMoveAwayFromLine = Math.max(minDistanceFromLine, Math.abs(this.cellSize.getX() * Math.cos(theta) + this.cellSize.getY() * Math.sin(theta)));
        this.shiftingVector.scale(distanceToMoveAwayFromLine);
        this.shiftedLinePoint.add((FrameTuple2DReadOnly)this.shiftingVector);
        this.shiftedLine.setIncludingFrame((FramePoint2DReadOnly)this.shiftedLinePoint, (FrameVector2DReadOnly)this.shiftedLineVector);
        int numberOfCellsActivatedOnSideToLookAt = 0;
        for (int xIndex = 0; xIndex < this.nLengthSubdivisions.getIntegerValue(); ++xIndex) {
            for (int yIndex = 0; yIndex < this.nWidthSubdivisions.getIntegerValue(); ++yIndex) {
                this.getCellCenter(this.cellCenter, xIndex, yIndex);
                if (!this.shiftedLine.isPointOnSideOfLine((FramePoint2DReadOnly)this.cellCenter, sideToLookAt == RobotSide.LEFT)) continue;
                numberOfCellsActivatedOnSideToLookAt = (int)((double)numberOfCellsActivatedOnSideToLookAt + this.occupancyGrid.get(xIndex, yIndex));
            }
        }
        return numberOfCellsActivatedOnSideToLookAt;
    }

    public int computeNumberOfCellsOccupiedOnSideOfLineSmarter(FrameLine2D frameLine, RobotSide sideToLookAt) {
        int returnFailure = -1;
        frameLine.checkReferenceFrameMatch(this.soleFrame);
        this.shiftingVector.setIncludingFrame((FrameTuple2DReadOnly)frameLine.getDirection());
        this.shiftedLinePoint.setIncludingFrame((FrameTuple2DReadOnly)frameLine.getPoint());
        this.shiftedLineVector.setIncludingFrame((FrameTuple2DReadOnly)frameLine.getDirection());
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)this.shiftingVector, (Vector2DBasics)this.shiftingVector);
        if (sideToLookAt == RobotSide.RIGHT) {
            this.shiftingVector.negate();
        }
        double theta = Math.atan2(this.shiftedLineVector.getY(), this.shiftedLineVector.getX());
        this.shiftingVector.scale(this.cellSize.getX() * Math.cos(theta) + this.cellSize.getY() * Math.sin(theta));
        this.shiftedLinePoint.add((FrameTuple2DReadOnly)this.shiftingVector);
        this.shiftedLine.setIncludingFrame((FramePoint2DReadOnly)this.shiftedLinePoint, (FrameVector2DReadOnly)this.shiftedLineVector);
        FramePoint2DBasics[] intersections = this.gridBoundaries.intersectionWith((FrameLine2DReadOnly)this.shiftedLine);
        if (intersections == null || intersections.length == 1) {
            return returnFailure;
        }
        FrameVector2D intersectionsVector = new FrameVector2D(this.soleFrame);
        intersectionsVector.sub((FrameTuple2DReadOnly)intersections[1], (FrameTuple2DReadOnly)intersections[0]);
        FramePoint2D temp = new FramePoint2D(this.soleFrame);
        FramePoint2D cellCenter = new FramePoint2D();
        int xIndex = -1;
        int yIndex = -1;
        if (intersectionsVector.dot((FrameVector2DReadOnly)this.shiftedLineVector) > 0.5) {
            temp.setIncludingFrame((FrameTuple2DReadOnly)intersections[0]);
        } else {
            temp.setIncludingFrame((FrameTuple2DReadOnly)intersections[1]);
        }
        this.getCellCenter(cellCenter, xIndex, yIndex);
        double xDirection = Math.signum(this.shiftingVector.getX());
        double yDirection = Math.signum(this.shiftingVector.getY());
        this.shiftedLineVector.normalize();
        if (Math.abs(theta % Math.PI / 2.0) > 0.1) {
            this.shiftedLineVector.scale(this.cellSize.getX() / Math.cos(theta));
            int cellActivatedNumber = 0;
            while (xIndex < this.nLengthSubdivisions.getIntegerValue()) {
                while (yIndex < this.nWidthSubdivisions.getIntegerValue()) {
                    cellActivatedNumber += (int)this.occupancyGrid.get(xIndex, yIndex);
                    yIndex += (int)yDirection;
                }
                temp.add((FrameTuple2DReadOnly)this.shiftedLineVector);
                xIndex = this.findXIndex(temp.getX());
                yIndex = this.findYIndex(temp.getY());
            }
            return cellActivatedNumber;
        }
        this.shiftedLineVector.scale(this.cellSize.getY() / Math.sin(theta));
        int cellActivatedNumber = 0;
        while (yIndex < this.nWidthSubdivisions.getIntegerValue()) {
            while (xIndex < this.nLengthSubdivisions.getIntegerValue()) {
                cellActivatedNumber += (int)this.occupancyGrid.get(xIndex, yIndex);
                xIndex += (int)xDirection;
            }
            temp.add((FrameTuple2DReadOnly)this.shiftedLineVector);
            xIndex = this.findXIndex(temp.getX());
            yIndex = this.findYIndex(temp.getY());
        }
        return cellActivatedNumber;
    }

    public void reset() {
        this.counterGrid.zero();
        this.occupancyGrid.zero();
    }

    public void update() {
        double decay = this.decayRate.getDoubleValue();
        if (decay == 1.0) {
            return;
        }
        for (int xIndex = 0; xIndex < this.nLengthSubdivisions.getIntegerValue(); ++xIndex) {
            for (int yIndex = 0; yIndex < this.nWidthSubdivisions.getIntegerValue(); ++yIndex) {
                double value = this.counterGrid.get(xIndex, yIndex);
                this.counterGrid.set(xIndex, yIndex, value * decay);
                if (value >= this.thresholdForCellActivation.getDoubleValue()) {
                    this.occupancyGrid.set(xIndex, yIndex, 1.0);
                    continue;
                }
                this.occupancyGrid.set(xIndex, yIndex, 0.0);
            }
        }
    }

    public void computeConvexHull(FrameConvexPolygon2D convexHullToPack) {
        convexHullToPack.clear(this.soleFrame);
        this.tempCellCenter.setToZero(this.soleFrame);
        for (int xIndex = 0; xIndex < this.nLengthSubdivisions.getIntegerValue(); ++xIndex) {
            for (int yIndex = 0; yIndex < this.nWidthSubdivisions.getIntegerValue(); ++yIndex) {
                if (!this.isCellOccupied(xIndex, yIndex)) continue;
                this.getCellCenter(this.tempCellCenter, xIndex, yIndex);
                convexHullToPack.addVertex((FramePoint2DReadOnly)this.tempCellCenter);
            }
        }
        convexHullToPack.update();
    }

    public boolean fitLineToData(FrameLine2D lineToPack) {
        int yIndex;
        int xIndex;
        int numberOfPoints = 0;
        for (xIndex = 0; xIndex < this.nLengthSubdivisions.getIntegerValue(); ++xIndex) {
            for (yIndex = 0; yIndex < this.nWidthSubdivisions.getIntegerValue(); ++yIndex) {
                if (!this.isCellOccupied(xIndex, yIndex)) continue;
                ++numberOfPoints;
            }
        }
        if (numberOfPoints < 2) {
            return false;
        }
        if (numberOfPoints == 2) {
            for (xIndex = 0; xIndex < this.nLengthSubdivisions.getIntegerValue(); ++xIndex) {
                for (yIndex = 0; yIndex < this.nWidthSubdivisions.getIntegerValue(); ++yIndex) {
                    if (!this.isCellOccupied(xIndex, yIndex)) continue;
                    this.getCellCenter(this.tempCellCenter, xIndex, yIndex);
                    this.pointB.setIncludingFrame((FrameTuple2DReadOnly)this.pointA);
                    this.pointA.setIncludingFrame((FrameTuple2DReadOnly)this.tempCellCenter);
                }
            }
            lineToPack.setIncludingFrame((FramePoint2DReadOnly)this.pointA, (FramePoint2DReadOnly)this.pointB);
            return true;
        }
        this.pointCloud.reshape(3, numberOfPoints);
        int counter = 0;
        for (int xIndex2 = 0; xIndex2 < this.nLengthSubdivisions.getIntegerValue(); ++xIndex2) {
            for (int yIndex2 = 0; yIndex2 < this.nWidthSubdivisions.getIntegerValue(); ++yIndex2) {
                if (!this.isCellOccupied(xIndex2, yIndex2)) continue;
                this.getCellCenter(this.tempCellCenter, xIndex2, yIndex2);
                this.pointCloud.set(0, counter, this.tempCellCenter.getX());
                this.pointCloud.set(1, counter, this.tempCellCenter.getY());
                this.pointCloud.set(2, counter, 0.0);
                ++counter;
            }
        }
        this.pca.setPointCloud(this.pointCloud);
        this.pca.compute();
        this.pca.getMean(this.tempPoint3d);
        this.pca.getPrincipalVector(this.tempVector3d);
        this.lineOrigin.setIncludingFrame(this.soleFrame, this.tempPoint3d.getX(), this.tempPoint3d.getY());
        this.lineDirection.setIncludingFrame(this.soleFrame, this.tempVector3d.getX(), this.tempVector3d.getY());
        if (this.lineDirection.containsNaN()) {
            return false;
        }
        lineToPack.setToZero(this.soleFrame);
        lineToPack.getPoint().set((FrameTuple2DReadOnly)this.lineOrigin);
        lineToPack.getDirection().set((FrameTuple2DReadOnly)this.lineDirection);
        return true;
    }
}

