/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.util.EnumMap;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.YoSwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.SupportStateParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ToeOffManager;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.WorkspaceLimiterReconciler;
import us.ihmc.commonWalkingControlModules.controlModules.foot.partialFoothold.FootholdRotationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.CentroidProjectionToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ICPPlanToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.SimpleToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffCalculator;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.ToeOffEnum;
import us.ihmc.commonWalkingControlModules.controlModules.foot.toeOffCalculator.WrapperForMultipleToeOffCalculators;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTimeDerivativesData;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTimeDerivativesDataBasics;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FeetManager {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final BooleanParameter useWorldSurfaceNormalWhenFullyConstrained = new BooleanParameter("useWorldSurfaceNormalWhenFullyConstrained", this.registry, true);
    private final SideDependentList<FootControlModule> footControlModules = new SideDependentList();
    private final ToeOffCalculator toeOffCalculator;
    private final ToeOffManager toeOffManager;
    private final SideDependentList<ContactableFoot> feet;
    private final ReferenceFrame pelvisZUpFrame;
    private final SideDependentList<MovingReferenceFrame> soleZUpFrames;
    private final SideDependentList<FootSwitchInterface> footSwitches;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final FramePoint3D tempSolePosition = new FramePoint3D();
    private final DoubleParameter blindFootstepsHeightOffset;
    private final CoMHeightTimeDerivativesDataBasics leftLegCoMHeightData = new CoMHeightTimeDerivativesData();
    private final CoMHeightTimeDerivativesDataBasics rightLegCoMHeightData = new CoMHeightTimeDerivativesData();
    private final SideDependentList<CoMHeightTimeDerivativesDataBasics> legComHeightData = new SideDependentList((Object)this.leftLegCoMHeightData, (Object)this.rightLegCoMHeightData);
    private final FrameVector3D footNormalContactVector = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);

    public FeetManager(HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, PIDSE3GainsReadOnly swingFootGains, PIDSE3GainsReadOnly holdFootGains, PIDSE3GainsReadOnly toeOffFootGains, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this.controllerToolbox = controllerToolbox;
        this.feet = controllerToolbox.getContactableFeet();
        SideDependentList contactStates = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            contactStates.put((Enum)robotSide, (Object)controllerToolbox.getFootContactState(robotSide));
        }
        CentroidProjectionToeOffCalculator centroidProjectionCalculator = new CentroidProjectionToeOffCalculator((SideDependentList<YoPlaneContactState>)contactStates, this.feet, walkingControllerParameters.getToeOffParameters(), this.registry, graphicsListRegistry);
        ICPPlanToeOffCalculator icpPlanCalculator = new ICPPlanToeOffCalculator((SideDependentList<YoPlaneContactState>)contactStates, this.feet, this.registry);
        SimpleToeOffCalculator simpleCalculator = new SimpleToeOffCalculator(this.feet, this.registry);
        EnumMap<ToeOffEnum, ToeOffCalculator> toeOffCalculators = new EnumMap<ToeOffEnum, ToeOffCalculator>(ToeOffEnum.class);
        toeOffCalculators.put(centroidProjectionCalculator.getEnum(), centroidProjectionCalculator);
        toeOffCalculators.put(icpPlanCalculator.getEnum(), icpPlanCalculator);
        toeOffCalculators.put(simpleCalculator.getEnum(), simpleCalculator);
        this.toeOffCalculator = new WrapperForMultipleToeOffCalculators(toeOffCalculators, this.registry);
        this.toeOffManager = new ToeOffManager(controllerToolbox, this.toeOffCalculator, walkingControllerParameters, this.feet, this.registry);
        this.footSwitches = controllerToolbox.getFootSwitches();
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        this.pelvisZUpFrame = referenceFrames.getPelvisZUpFrame();
        this.soleZUpFrames = referenceFrames.getSoleZUpFrames();
        ExplorationParameters explorationParameters = null;
        if (walkingControllerParameters.createFootholdExplorationTools()) {
            explorationParameters = new ExplorationParameters(this.registry);
        }
        FootholdRotationParameters footholdRotationParameters = new FootholdRotationParameters(this.registry);
        SupportStateParameters supportStateParameters = new SupportStateParameters(walkingControllerParameters, this.registry);
        boolean enableSmoothUnloading = walkingControllerParameters.enforceSmoothFootUnloading();
        DoubleParameter minWeightFractionPerFoot = enableSmoothUnloading ? new DoubleParameter("minWeightFractionPerFoot", this.registry, 0.0) : null;
        DoubleParameter maxWeightFractionPerFoot = enableSmoothUnloading ? new DoubleParameter("maxWeightFractionPerFoot", this.registry, 2.0) : null;
        WorkspaceLimiterParameters workspaceLimiterParameters = new WorkspaceLimiterParameters(this.registry);
        YoSwingTrajectoryParameters swingTrajectoryParameters = new YoSwingTrajectoryParameters("FootSwing", walkingControllerParameters, this.registry);
        for (RobotSide robotSide : RobotSide.values) {
            FootControlModule footControlModule = new FootControlModule(robotSide, this.toeOffCalculator, walkingControllerParameters, swingTrajectoryParameters, workspaceLimiterParameters, swingFootGains, holdFootGains, toeOffFootGains, controllerToolbox, explorationParameters, footholdRotationParameters, supportStateParameters, (DoubleProvider)minWeightFractionPerFoot, (DoubleProvider)maxWeightFractionPerFoot, this.registry);
            this.footControlModules.put((Enum)robotSide, (Object)footControlModule);
        }
        double defaultBlindFootstepsHeightOffset = walkingControllerParameters.getSwingTrajectoryParameters().getBlindFootstepsHeightOffset();
        this.blindFootstepsHeightOffset = new DoubleParameter("blindFootstepsHeightOffset", this.registry, defaultBlindFootstepsHeightOffset);
        parentRegistry.addChild(this.registry);
    }

    public void setWeights(Vector3DReadOnly loadedFootAngularWeight, Vector3DReadOnly loadedFootLinearWeight, Vector3DReadOnly footAngularWeight, Vector3DReadOnly footLinearWeight) {
        for (RobotSide robotSide : RobotSide.values) {
            FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
            footControlModule.setWeights(loadedFootAngularWeight, loadedFootLinearWeight, footAngularWeight, footLinearWeight);
        }
    }

    public void initialize() {
        for (RobotSide robotSide : RobotSide.values) {
            ((FootControlModule)this.footControlModules.get((Enum)robotSide)).initialize();
        }
    }

    public void compute() {
        for (RobotSide robotSide : RobotSide.values) {
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).hasFootHitGround();
            ((FootControlModule)this.footControlModules.get((Enum)robotSide)).doControl();
        }
    }

    public boolean adjustHeightIfNeeded(Footstep footstep) {
        if (!footstep.getTrustHeight()) {
            this.tempSolePosition.setToZero((ReferenceFrame)this.soleZUpFrames.get((Enum)footstep.getRobotSide().getOppositeSide()));
            this.tempSolePosition.changeFrame(footstep.getFootstepPose().getReferenceFrame());
            footstep.setZ(this.tempSolePosition.getZ() + this.blindFootstepsHeightOffset.getValue());
            return true;
        }
        return false;
    }

    public void requestSwing(RobotSide upcomingSwingSide, Footstep footstep, double swingTime) {
        this.requestSwing(upcomingSwingSide, footstep, swingTime, null, null);
    }

    public void requestSwing(RobotSide upcomingSwingSide, Footstep footstep, double swingTime, FrameVector3DReadOnly finalCoMVelocity, FrameVector3DReadOnly finalCoMAcceleration) {
        FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)upcomingSwingSide);
        footControlModule.setFootstep(footstep, swingTime, finalCoMVelocity, finalCoMAcceleration);
        this.setContactStateForSwing(upcomingSwingSide);
    }

    public void initializeSwingTrajectoryPreview(RobotSide upcomingSwingSide, Footstep footstep, double swingTime) {
        ((FootControlModule)this.footControlModules.get((Enum)upcomingSwingSide)).initializeSwingTrajectoryPreview(footstep, swingTime);
    }

    public void updateSwingTrajectoryPreview(RobotSide upcomingSwingSide) {
        ((FootControlModule)this.footControlModules.get((Enum)upcomingSwingSide)).updateSwingTrajectoryPreview();
    }

    public void saveCurrentPositionsAsLastFootstepPositions() {
        for (RobotSide robotSide : RobotSide.values) {
            ((FootControlModule)this.footControlModules.get((Enum)robotSide)).saveCurrentPositionAsLastFootstepPosition();
        }
    }

    public void handleFootTrajectoryCommand(FootTrajectoryCommand command) {
        RobotSide robotSide = command.getRobotSide();
        FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
        footControlModule.handleFootTrajectoryCommand(command);
        if (footControlModule.getCurrentConstraintType() != FootControlModule.ConstraintType.MOVE_VIA_WAYPOINTS) {
            this.setContactStateForMoveViaWaypoints(robotSide);
        }
    }

    public FootControlModule.ConstraintType getCurrentConstraintType(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).getCurrentConstraintType();
    }

    public void adjustSwingTrajectory(RobotSide swingSide, Footstep adjustedFootstep, double swingTime) {
        ((FootControlModule)this.footControlModules.get((Enum)swingSide)).setAdjustedFootstepAndTime(adjustedFootstep, swingTime);
    }

    public void requestMoveStraightTouchdownForDisturbanceRecovery(RobotSide swingSide) {
        ((FootControlModule)this.footControlModules.get((Enum)swingSide)).requestTouchdownForDisturbanceRecovery();
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        if (!command.isStopAllTrajectory()) {
            return;
        }
        for (RobotSide robotSide : RobotSide.values) {
            FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
            footControlModule.requestStopTrajectoryIfPossible();
        }
    }

    public void correctCoMHeightForSupportSingularityAvoidance(double zCurrent, CoMHeightTimeDerivativesDataBasics comHeightData) {
        boolean leftCorrectionApplied = false;
        boolean rightCorrectionApplied = false;
        for (RobotSide robotSide : RobotSide.values) {
            CoMHeightTimeDerivativesDataBasics sidedCoMHeightData = (CoMHeightTimeDerivativesDataBasics)this.legComHeightData.get((Enum)robotSide);
            sidedCoMHeightData.set(comHeightData);
            FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
            footControlModule.updateLegSingularityModule();
            boolean correctionApplied = footControlModule.correctCoMHeightTrajectoryForSupportSingularityAvoidance(sidedCoMHeightData, zCurrent, this.pelvisZUpFrame);
            if (robotSide == RobotSide.LEFT) {
                leftCorrectionApplied = correctionApplied;
                continue;
            }
            rightCorrectionApplied = correctionApplied;
        }
        if (leftCorrectionApplied != rightCorrectionApplied) {
            if (leftCorrectionApplied) {
                comHeightData.set(this.leftLegCoMHeightData);
            } else {
                comHeightData.set(this.rightLegCoMHeightData);
            }
        } else {
            WorkspaceLimiterReconciler.reconcileWorkspaceLimitedData(this.legComHeightData, comHeightData);
        }
    }

    public void correctCoMHeightForUnreachableFootstep(CoMHeightTimeDerivativesDataBasics comHeightData) {
        boolean leftCorrectionApplied = false;
        boolean rightCorrectionApplied = false;
        for (RobotSide robotSide : RobotSide.values) {
            CoMHeightTimeDerivativesDataBasics sidedCoMHeightData = (CoMHeightTimeDerivativesDataBasics)this.legComHeightData.get((Enum)robotSide);
            sidedCoMHeightData.set(comHeightData);
            FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
            footControlModule.updateLegSingularityModule();
            boolean correctionApplied = footControlModule.correctCoMHeightTrajectoryForUnreachableFootStep(sidedCoMHeightData);
            if (robotSide == RobotSide.LEFT) {
                leftCorrectionApplied = correctionApplied;
                continue;
            }
            rightCorrectionApplied = correctionApplied;
        }
        if (leftCorrectionApplied != rightCorrectionApplied) {
            if (leftCorrectionApplied) {
                comHeightData.set(this.leftLegCoMHeightData);
            } else {
                comHeightData.set(this.rightLegCoMHeightData);
            }
        } else {
            WorkspaceLimiterReconciler.reconcileWorkspaceLimitedData(this.legComHeightData, comHeightData);
        }
    }

    public void initializeContactStatesForDoubleSupport(RobotSide transferToSide) {
        if (transferToSide == null) {
            for (RobotSide robotSide : RobotSide.values) {
                this.setFlatFootContactState(robotSide);
            }
        } else {
            if (this.getCurrentConstraintType(transferToSide.getOppositeSide()) == FootControlModule.ConstraintType.SWING) {
                this.setFlatFootContactState(transferToSide.getOppositeSide());
            }
            this.setFlatFootContactState(transferToSide);
        }
        this.reset();
    }

    public void updateContactStatesInDoubleSupport(RobotSide transferToSide) {
        if (transferToSide == null) {
            for (RobotSide robotSide : RobotSide.values) {
                if (this.getCurrentConstraintType(robotSide) != FootControlModule.ConstraintType.TOES) continue;
                this.setFlatFootContactState(robotSide);
            }
        } else if (this.getCurrentConstraintType(transferToSide) == FootControlModule.ConstraintType.TOES) {
            this.setFlatFootContactState(transferToSide);
        }
    }

    public void setOnToesContactState(RobotSide robotSide) {
        FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
        if (footControlModule.isInFlatSupportState()) {
            this.footNormalContactVector.setIncludingFrame(((ContactableFoot)this.feet.get((Enum)robotSide)).getSoleFrame(), 0.0, 0.0, 1.0);
            this.footNormalContactVector.changeFrame(worldFrame);
        } else {
            this.footNormalContactVector.setIncludingFrame(worldFrame, 0.0, 0.0, 1.0);
        }
        footControlModule.setContactState(FootControlModule.ConstraintType.TOES, this.footNormalContactVector);
    }

    public void setFlatFootContactState(RobotSide robotSide) {
        if (this.useWorldSurfaceNormalWhenFullyConstrained.getValue()) {
            this.footNormalContactVector.setIncludingFrame(worldFrame, 0.0, 0.0, 1.0);
        } else {
            this.footNormalContactVector.setIncludingFrame(((ContactableFoot)this.feet.get((Enum)robotSide)).getSoleFrame(), 0.0, 0.0, 1.0);
        }
        ((FootControlModule)this.footControlModules.get((Enum)robotSide)).setContactState(FootControlModule.ConstraintType.FULL, this.footNormalContactVector);
        if (((FootControlModule)this.footControlModules.get((Enum)robotSide)).getCurrentConstraintType() == FootControlModule.ConstraintType.TOES) {
            this.controllerToolbox.restorePreviousFootContactPoints(robotSide);
        }
    }

    public void setContactStateForSwing(RobotSide robotSide) {
        FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
        footControlModule.setContactState(FootControlModule.ConstraintType.SWING);
    }

    private void setContactStateForMoveViaWaypoints(RobotSide robotSide) {
        FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSide);
        footControlModule.setContactState(FootControlModule.ConstraintType.MOVE_VIA_WAYPOINTS);
    }

    public ToeOffManager getToeOffManager() {
        return this.toeOffManager;
    }

    public boolean canDoDoubleSupportToeOff(FramePoint3DReadOnly nextFootstep, RobotSide transferToSide) {
        return this.toeOffManager.canDoDoubleSupportToeOff(nextFootstep, transferToSide);
    }

    public boolean canDoSingleSupportToeOff(FramePoint3DReadOnly nextFootstep, RobotSide transferToSide) {
        return this.toeOffManager.canDoSingleSupportToeOff(nextFootstep, transferToSide);
    }

    public void updateToeOffStatusSingleSupport(Footstep nextFootstep, FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, FramePoint2DReadOnly desiredCoP, FramePoint2DReadOnly desiredICP, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly finalDesiredICP) {
        this.toeOffManager.submitNextFootstep(nextFootstep);
        this.toeOffManager.updateToeOffStatusSingleSupport(exitCMP, desiredECMP, desiredCoP, desiredICP, currentICP, finalDesiredICP);
    }

    public void updateToeOffStatusDoubleSupport(RobotSide trailingLeg, Footstep nextFootstep, FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredECMP, FramePoint2DReadOnly desiredCoP, FramePoint2DReadOnly desiredICP, FramePoint2DReadOnly currentICP, FramePoint2DReadOnly finalDesiredICP) {
        this.toeOffManager.submitNextFootstep(nextFootstep);
        this.toeOffManager.updateToeOffStatusDoubleSupport(trailingLeg, exitCMP, desiredECMP, desiredCoP, desiredICP, currentICP, finalDesiredICP);
    }

    public boolean okForPointToeOff() {
        return this.toeOffManager.doPointToeOff();
    }

    public boolean okForLineToeOff() {
        return this.toeOffManager.doLineToeOff();
    }

    public boolean useToeLineContactInTransfer() {
        return this.toeOffManager.useToeLineContactInTransfer();
    }

    public boolean isUsingPointContactInToeOff(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).isUsingPointContactInToeOff();
    }

    public void requestPointToeOff(RobotSide trailingLeg, FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredCMP) {
        this.toeOffCalculator.setExitCMP(exitCMP, trailingLeg);
        this.toeOffCalculator.computeToeOffContactPoint(desiredCMP, trailingLeg);
        ((FootControlModule)this.footControlModules.get((Enum)trailingLeg)).setUsePointContactInToeOff(true);
        this.requestToeOff(trailingLeg);
        this.controllerToolbox.updateBipedSupportPolygons();
    }

    public void requestLineToeOff(RobotSide trailingLeg, FramePoint3DReadOnly exitCMP, FramePoint2DReadOnly desiredCMP) {
        this.toeOffCalculator.setExitCMP(exitCMP, trailingLeg);
        this.toeOffCalculator.computeToeOffContactLine(desiredCMP, trailingLeg);
        ((FootControlModule)this.footControlModules.get((Enum)trailingLeg)).setUsePointContactInToeOff(false);
        this.requestToeOff(trailingLeg);
        this.controllerToolbox.updateBipedSupportPolygons();
    }

    private void requestToeOff(RobotSide trailingLeg) {
        if (((FootControlModule)this.footControlModules.get((Enum)trailingLeg)).isInToeOff()) {
            return;
        }
        this.setOnToesContactState(trailingLeg);
    }

    public boolean shouldComputeToeLineContact() {
        return this.toeOffManager.shouldComputeToeLineContact();
    }

    public boolean shouldComputeToePointContact() {
        return this.toeOffManager.shouldComputeToePointContact();
    }

    public void reset() {
        this.toeOffManager.reset();
    }

    public void resetHeightCorrectionParametersForSingularityAvoidance() {
        for (RobotSide robotSide : RobotSide.values) {
            ((FootControlModule)this.footControlModules.get((Enum)robotSide)).resetHeightCorrectionParametersForSingularityAvoidance();
        }
    }

    public double requestSwingSpeedUp(RobotSide robotSide, double speedUpFactor) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).requestSwingSpeedUp(speedUpFactor);
    }

    public double getFractionThroughSwing(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).getFractionThroughSwing();
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).getInverseDynamicsCommand();
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).getFeedbackControlCommand();
    }

    public JointDesiredOutputListReadOnly getJointDesiredData(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).getJointDesiredData();
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (RobotSide robotSide : RobotSide.values) {
            FeedbackControlCommandList template = ((FootControlModule)this.footControlModules.get((Enum)robotSide)).createFeedbackControlTemplate();
            for (int i = 0; i < template.getNumberOfCommands(); ++i) {
                ret.addCommand(template.getCommand(i));
            }
        }
        return ret;
    }

    public void initializeFootExploration(RobotSide robotSideToExplore) {
        if (robotSideToExplore == null) {
            return;
        }
        FootControlModule footControlModule = (FootControlModule)this.footControlModules.get((Enum)robotSideToExplore);
        footControlModule.initializeFootExploration();
    }

    public boolean isFootToeingOffSlipping(RobotSide robotSideToCheck) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSideToCheck)).isFootToeingOffSlipping();
    }

    public void unload(RobotSide sideToUnload, double percentInUnloading, double rhoMin) {
        ((FootControlModule)this.footControlModules.get((Enum)sideToUnload)).unload(percentInUnloading, rhoMin);
    }

    public void resetLoadConstraints(RobotSide sideToUnload) {
        ((FootControlModule)this.footControlModules.get((Enum)sideToUnload)).resetLoadConstraints();
    }

    public Object pollStatusToReport(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).pollStatusToReport();
    }

    public void liftOff(RobotSide side, double pitch, double pitchVelocity, double duration) {
        ((FootControlModule)this.footControlModules.get((Enum)side)).liftOff(pitch, pitchVelocity, duration);
    }

    public void touchDown(RobotSide side, double initialPitch, double initialPitchVelocity, double pitch, double duration) {
        this.setFlatFootContactState(side);
        ((FootControlModule)this.footControlModules.get((Enum)side)).touchDown(initialPitch, initialPitchVelocity, pitch, duration);
    }

    public MultipleWaypointsPoseTrajectoryGenerator getSwingTrajectory(RobotSide robotSide) {
        return ((FootControlModule)this.footControlModules.get((Enum)robotSide)).getSwingTrajectory();
    }
}

