/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.foot;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.controlModules.foot.ExplorationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.foot.PartialFootholdControlModule;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class ExplorationHelper {
    private final YoBoolean footholdExplorationActive;
    private final ExplorationParameters explorationParameters;
    private final ReferenceFrame soleFrame;
    private final FramePoint2D desiredCenterOfPressure = new FramePoint2D();
    private final YoDouble copCommandWeight;
    private final FrameVector2D commandWeight = new FrameVector2D();
    private final CenterOfPressureCommand centerOfPressureCommand = new CenterOfPressureCommand();
    private final YoDouble startTime;
    private final YoDouble timeExploring;
    private final PartialFootholdControlModule partialFootholdControlModule;
    private int currentCornerIdx = 0;
    private int lastCornerCropped = 0;
    private double lastShrunkTime = 0.0;
    private final FrameConvexPolygon2D supportPolygon = new FrameConvexPolygon2D();
    private final FramePoint2D currentCorner = new FramePoint2D();
    private final YoInteger yoCurrentCorner;
    private final FramePoint2D desiredCopInWorld = new FramePoint2D();
    private final YoFramePoint2D yoDesiredCop;
    private final FramePoint2D centroid = new FramePoint2D();

    public ExplorationHelper(ContactableFoot contactableFoot, FootControlHelper footControlHelper, String prefix, YoRegistry registry) {
        this.footholdExplorationActive = new YoBoolean(prefix + "FootholdExplorationActive", registry);
        this.timeExploring = new YoDouble(prefix + "TimeExploring", registry);
        this.startTime = new YoDouble(prefix + "StartTime", registry);
        this.yoCurrentCorner = new YoInteger(prefix + "CurrentCornerExplored", registry);
        this.centerOfPressureCommand.setContactingRigidBody(contactableFoot.getRigidBody());
        this.explorationParameters = footControlHelper.getExplorationParameters();
        this.copCommandWeight = this.explorationParameters != null ? this.explorationParameters.getCopCommandWeight() : null;
        this.soleFrame = footControlHelper.getContactableFoot().getSoleFrame();
        this.partialFootholdControlModule = footControlHelper.getPartialFootholdControlModule();
        this.commandWeight.setToZero(this.soleFrame);
        YoGraphicsListRegistry graphicObjectsListRegistry = footControlHelper.getHighLevelHumanoidControllerToolbox().getYoGraphicsListRegistry();
        if (graphicObjectsListRegistry != null) {
            this.yoDesiredCop = new YoFramePoint2D(prefix + "DesiredExplorationCop", ReferenceFrame.getWorldFrame(), registry);
            String name = prefix + "Desired Center of Pressure for Exploration";
            YoArtifactPosition artifact = new YoArtifactPosition(name, this.yoDesiredCop.getYoX(), this.yoDesiredCop.getYoY(), YoGraphicPosition.GraphicType.BALL, Color.BLUE, 0.003);
            graphicObjectsListRegistry.registerArtifact(prefix + this.getClass().getSimpleName(), (Artifact)artifact);
        } else {
            this.yoDesiredCop = null;
        }
    }

    public void compute(double time, boolean footholdWasUpdated) {
        if (!this.footholdExplorationActive.getBooleanValue() || this.partialFootholdControlModule == null) {
            this.reset();
            return;
        }
        if (this.timeExploring.isNaN()) {
            this.startTime.set(time);
        }
        this.timeExploring.set(time - this.startTime.getDoubleValue());
        this.computeDesiredCenterOfPressure(time, footholdWasUpdated);
        this.desiredCopInWorld.setIncludingFrame((FrameTuple2DReadOnly)this.desiredCenterOfPressure);
        this.desiredCopInWorld.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        if (this.yoDesiredCop != null) {
            this.yoDesiredCop.set((FrameTuple2DReadOnly)this.desiredCopInWorld);
        }
        this.centerOfPressureCommand.setDesiredCoP((FramePoint2DReadOnly)this.desiredCenterOfPressure);
        this.commandWeight.set(this.copCommandWeight.getDoubleValue(), this.copCommandWeight.getDoubleValue());
        this.centerOfPressureCommand.setWeight((FrameVector2DReadOnly)this.commandWeight);
    }

    private void reset() {
        if (this.yoDesiredCop != null) {
            this.yoDesiredCop.setToNaN();
        }
        this.commandWeight.set(0.0, 0.0);
        this.centerOfPressureCommand.setWeight((FrameVector2DReadOnly)this.commandWeight);
        this.lastCornerCropped = 0;
        this.yoCurrentCorner.set(0);
        this.timeExploring.set(Double.NaN);
        this.lastShrunkTime = 0.0;
    }

    private void computeDesiredCenterOfPressure(double time, boolean footholdWasUpdated) {
        if (footholdWasUpdated) {
            this.lastCornerCropped = this.currentCornerIdx + 1;
            this.lastShrunkTime = time;
        }
        double timeToGoToCorner = this.explorationParameters.getTimeToGoToCorner().getDoubleValue();
        double timeToStayAtCorner = this.explorationParameters.getTimeToStayInCorner().getDoubleValue();
        double timeToExploreCorner = timeToGoToCorner + timeToStayAtCorner;
        double timeExploring = time - this.lastShrunkTime + (double)this.lastCornerCropped * timeToExploreCorner;
        this.partialFootholdControlModule.getSupportPolygon(this.supportPolygon);
        int corners = this.supportPolygon.getNumberOfVertices();
        this.currentCornerIdx = (int)(timeExploring / timeToExploreCorner);
        int corner = this.currentCornerIdx % corners;
        this.yoCurrentCorner.set(corner);
        this.currentCorner.setIncludingFrame((FrameTuple2DReadOnly)this.supportPolygon.getVertex(corner));
        this.centroid.setIncludingFrame((FrameTuple2DReadOnly)this.supportPolygon.getCentroid());
        this.currentCorner.changeFrame(this.soleFrame);
        this.centroid.changeFrame(this.soleFrame);
        this.desiredCenterOfPressure.setToZero(this.soleFrame);
        double timeExploringCurrentCorner = timeExploring - (double)this.currentCornerIdx * timeToExploreCorner;
        if (timeExploringCurrentCorner <= timeToGoToCorner) {
            double percent = timeExploringCurrentCorner / timeToGoToCorner;
            percent = MathTools.clamp((double)percent, (double)0.0, (double)1.0);
            this.desiredCenterOfPressure.interpolate((FrameTuple2DReadOnly)this.centroid, (FrameTuple2DReadOnly)this.currentCorner, percent);
        } else {
            this.desiredCenterOfPressure.set(this.currentCorner);
        }
        if (time - this.lastShrunkTime > 2.0 * timeToExploreCorner * (double)corners) {
            this.footholdExplorationActive.set(false);
            this.partialFootholdControlModule.informExplorationDone();
        }
    }

    public boolean isExploring() {
        return this.footholdExplorationActive.getBooleanValue();
    }

    public void startExploring() {
        this.footholdExplorationActive.set(true);
    }

    public void stopExploring() {
        this.footholdExplorationActive.set(false);
    }

    public InverseDynamicsCommand<?> getCommand() {
        if (this.isExploring()) {
            return this.centerOfPressureCommand;
        }
        return null;
    }
}

