/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSE3OffsetFrame
extends MovingReferenceFrame {
    private final YoFrameVector3D translationToParent;
    private final YoFrameQuaternion rotationToParent;

    public YoSE3OffsetFrame(String frameName, ReferenceFrame parentFrame, YoRegistry registry) {
        super(frameName, parentFrame);
        this.translationToParent = new YoFrameVector3D(frameName, parentFrame, registry);
        this.rotationToParent = new YoFrameQuaternion(frameName, parentFrame, registry);
    }

    public void setOffsetToParentToTranslationOnly(FrameTuple3DReadOnly translationToParent) {
        this.translationToParent.set(translationToParent);
        this.rotationToParent.setToZero();
        this.update();
    }

    public void setOffsetToParent(FrameTuple3DReadOnly translationToParent, FrameQuaternionReadOnly rotationToParent) {
        this.translationToParent.set(translationToParent);
        this.rotationToParent.set(rotationToParent);
        this.update();
    }

    public void setToZero() {
        this.translationToParent.setToZero();
        this.rotationToParent.setToZero();
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        transformToParent.set((Orientation3DReadOnly)this.rotationToParent, (Tuple3DReadOnly)this.translationToParent);
    }

    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        twistRelativeToParentToPack.setToZero((ReferenceFrame)this, this.getParent(), (ReferenceFrame)this);
    }
}

