/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.humanoidRobotics.communication.packets.TrajectoryExecutionStatus;

public abstract class TrajectoryStatusMessageHelper<M> {
    public static final long NULL_SEQUENCE_ID = -1L;
    private final RecyclingArrayList<TrajectoryTimeInfo> inputs = new RecyclingArrayList(TrajectoryTimeInfo.class);
    private final TrajectoryStatus currentTrajectoryStatus = new TrajectoryStatus();

    public void clear() {
        this.inputs.clear();
        this.currentTrajectoryStatus.sequenceID = -1L;
        this.currentTrajectoryStatus.timeInTrajectory = 0.0;
        this.currentTrajectoryStatus.status = null;
    }

    public void registerNewTrajectory(long trajectorySequenceID, double trajectoryStartTime, double trajectoryEndTime) {
        ((TrajectoryTimeInfo)this.inputs.add()).set(trajectorySequenceID, trajectoryStartTime, trajectoryEndTime);
    }

    public void updateWithTimeInTrajectory(double timeInTrajectory) {
        if (this.inputs.isEmpty()) {
            this.currentTrajectoryStatus.sequenceID = -1L;
            this.currentTrajectoryStatus.status = null;
            return;
        }
        TrajectoryTimeInfo currentTrajectory = (TrajectoryTimeInfo)this.inputs.get(0);
        this.currentTrajectoryStatus.sequenceID = currentTrajectory.sequenceID;
        this.currentTrajectoryStatus.timeInTrajectory = timeInTrajectory;
        if (!currentTrajectory.hasAlreadyStarted && timeInTrajectory >= currentTrajectory.startTime) {
            this.currentTrajectoryStatus.status = TrajectoryExecutionStatus.STARTED;
            currentTrajectory.hasAlreadyStarted = true;
        } else if (timeInTrajectory >= currentTrajectory.endTime) {
            this.currentTrajectoryStatus.status = TrajectoryExecutionStatus.COMPLETED;
        } else {
            this.currentTrajectoryStatus.status = null;
        }
    }

    protected TrajectoryStatus pollStatus() {
        if (!this.inputs.isEmpty() && this.currentTrajectoryStatus.status != null) {
            if (this.currentTrajectoryStatus.status == TrajectoryExecutionStatus.COMPLETED) {
                this.inputs.remove(0);
            }
            return this.currentTrajectoryStatus;
        }
        return null;
    }

    public static class TrajectoryTimeInfo {
        private long sequenceID;
        private double startTime;
        private double endTime;
        private boolean hasAlreadyStarted;

        public void set(long sequenceID, double startTime, double endTime) {
            this.sequenceID = sequenceID;
            this.startTime = startTime;
            this.endTime = endTime;
            this.hasAlreadyStarted = false;
        }
    }

    protected static class TrajectoryStatus {
        private long sequenceID = -1L;
        private double timeInTrajectory = 0.0;
        private TrajectoryExecutionStatus status = null;

        protected TrajectoryStatus() {
        }

        public long getSequenceID() {
            return this.sequenceID;
        }

        public double getTimeInTrajectory() {
            return this.timeInTrajectory;
        }

        public TrajectoryExecutionStatus getStatus() {
            return this.status;
        }
    }
}

