/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import java.util.List;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.YoSwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.trajectories.TwoWaypointSwingGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.robotics.trajectories.providers.CurrentRigidBodyStateProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class SwingTrajectoryCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final TwoWaypointSwingGenerator swingTrajectoryOptimizer;
    private final MovingReferenceFrame soleFrame;
    private final ReferenceFrame oppositeSoleFrame;
    private final ReferenceFrame oppositeSoleZUpFrame;
    private final CurrentRigidBodyStateProvider currentStateProvider;
    private final YoEnum<TrajectoryType> activeTrajectoryType;
    private final RecyclingArrayList<FramePoint3D> positionWaypointsForSole = new RecyclingArrayList(12, FramePoint3D.class);
    private final RecyclingArrayList<FrameSE3TrajectoryPoint> swingWaypoints = new RecyclingArrayList(12, FrameSE3TrajectoryPoint.class);
    private final YoDouble swingDuration;
    private final YoDouble swingHeight;
    private final YoSwingTrajectoryParameters swingTrajectoryParameters;
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialLinearVelocity = new FrameVector3D();
    private final FrameQuaternion initialOrientation = new FrameQuaternion();
    private final FrameVector3D initialAngularVelocity = new FrameVector3D();
    private final FramePoint3D finalPosition = new FramePoint3D();
    private final FrameVector3D finalLinearVelocity = new FrameVector3D();
    private final FrameQuaternion finalOrientation = new FrameQuaternion();
    private final FrameVector3D finalAngularVelocity = new FrameVector3D();
    private final FrameVector3D finalCoMVelocity = new FrameVector3D();
    private final FramePoint3D stanceFootPosition = new FramePoint3D();
    private final FrameQuaternion tmpOrientation = new FrameQuaternion();
    private final FrameVector3D tmpVector = new FrameVector3D();
    private final FramePoint3D lastFootstepPosition = new FramePoint3D();
    private final MultipleWaypointsPoseTrajectoryGenerator swingTrajectory;
    private final double[] waypointProportions = new double[2];
    private final FrameEuclideanTrajectoryPoint tempPositionTrajectoryPoint = new FrameEuclideanTrajectoryPoint();

    public SwingTrajectoryCalculator(String namePrefix, RobotSide robotSide, HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, YoSwingTrajectoryParameters swingTrajectoryParameters, YoRegistry parentRegistry) {
        this.swingTrajectoryParameters = swingTrajectoryParameters;
        double maxSwingHeightFromStanceFoot = walkingControllerParameters.getSteppingParameters().getMaxSwingHeightFromStanceFoot();
        double minSwingHeightFromStanceFoot = walkingControllerParameters.getSteppingParameters().getMinSwingHeightFromStanceFoot();
        double defaultSwingHeightFromStanceFoot = walkingControllerParameters.getSteppingParameters().getDefaultSwingHeightFromStanceFoot();
        double customWaypointAngleThreshold = walkingControllerParameters.getSteppingParameters().getCustomWaypointAngleThreshold();
        this.soleFrame = controllerToolbox.getReferenceFrames().getSoleFrame((Enum)robotSide);
        this.oppositeSoleFrame = controllerToolbox.getReferenceFrames().getSoleFrame((Enum)robotSide.getOppositeSide());
        this.oppositeSoleZUpFrame = controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)robotSide.getOppositeSide());
        this.currentStateProvider = new CurrentRigidBodyStateProvider(this.soleFrame);
        namePrefix = namePrefix + "FootSwing";
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.activeTrajectoryType = new YoEnum(namePrefix + TrajectoryType.class.getSimpleName(), registry, TrajectoryType.class);
        this.swingHeight = new YoDouble(namePrefix + "Height", registry);
        this.swingDuration = new YoDouble(namePrefix + "Duration", registry);
        this.swingTrajectory = new MultipleWaypointsPoseTrajectoryGenerator(namePrefix, 14, registry);
        this.swingTrajectoryOptimizer = new TwoWaypointSwingGenerator(namePrefix, minSwingHeightFromStanceFoot, maxSwingHeightFromStanceFoot, defaultSwingHeightFromStanceFoot, customWaypointAngleThreshold, registry, controllerToolbox.getYoGraphicsListRegistry());
        double minDistanceToStance = walkingControllerParameters.getMinSwingTrajectoryClearanceFromStanceFoot();
        this.swingTrajectoryOptimizer.enableStanceCollisionAvoidance(robotSide, this.oppositeSoleZUpFrame, minDistanceToStance);
        this.lastFootstepPosition.setToNaN();
        this.finalPosition.setToNaN();
        this.finalOrientation.setToNaN();
        parentRegistry.addChild(registry);
    }

    public void setShouldVisualize(boolean visualize) {
        this.swingTrajectoryOptimizer.setShouldVisualize(visualize);
    }

    public void informDone() {
        this.saveFinalPositionAsLastFootstep();
        this.swingTrajectoryOptimizer.informDone();
    }

    public TrajectoryType getActiveTrajectoryType() {
        return (TrajectoryType)this.activeTrajectoryType.getEnumValue();
    }

    public FrameVector3DReadOnly getFinalLinearVelocity() {
        return this.finalLinearVelocity;
    }

    public boolean doOptimizationUpdate() {
        return this.swingTrajectoryOptimizer.doOptimizationUpdate();
    }

    public void saveFinalPositionAsLastFootstep() {
        this.lastFootstepPosition.setIncludingFrame((FrameTuple3DReadOnly)this.finalPosition);
        if (this.lastFootstepPosition.containsNaN()) {
            this.lastFootstepPosition.setToZero((ReferenceFrame)this.soleFrame);
        }
    }

    public void saveCurrentPositionAsLastFootstepPosition() {
        this.lastFootstepPosition.setToZero((ReferenceFrame)this.soleFrame);
    }

    public void setFootstep(Footstep footstep) {
        this.finalPosition.setIncludingFrame((FrameTuple3DReadOnly)footstep.getFootstepPose().getPosition());
        this.finalOrientation.setIncludingFrame((FrameQuaternionReadOnly)footstep.getFootstepPose().getOrientation());
        this.finalPosition.changeFrame(worldFrame);
        this.finalOrientation.changeFrame(worldFrame);
        this.finalPosition.addZ(this.swingTrajectoryParameters.getDesiredTouchdownHeightOffset());
        this.finalCoMVelocity.setToNaN();
        if (footstep.getTrajectoryType() == null) {
            this.activeTrajectoryType.set((Enum)TrajectoryType.DEFAULT);
        } else {
            this.activeTrajectoryType.set((Enum)footstep.getTrajectoryType());
        }
        this.positionWaypointsForSole.clear();
        this.swingWaypoints.clear();
        this.lastFootstepPosition.changeFrame(worldFrame);
        if (this.activeTrajectoryType.getEnumValue() == TrajectoryType.CUSTOM) {
            this.setWaypointsFromCustomMidpoints(footstep.getCustomPositionWaypoints());
        } else if (this.activeTrajectoryType.getEnumValue() == TrajectoryType.WAYPOINTS) {
            this.setWaypointsFromExternal((List<FrameSE3TrajectoryPoint>)footstep.getSwingTrajectory());
        } else {
            this.setWaypointsFromStepPosition(footstep);
        }
    }

    public void setFinalCoMVelocity(FrameVector3DReadOnly finalCoMVelocity) {
        this.finalCoMVelocity.set((FrameTuple3DReadOnly)finalCoMVelocity);
    }

    public void setSwingDuration(double swingDuration) {
        this.swingDuration.set(swingDuration);
    }

    public void setInitialConditionsToCurrent() {
        this.currentStateProvider.getPosition((FixedFramePoint3DBasics)this.initialPosition);
        this.currentStateProvider.getLinearVelocity((FixedFrameVector3DBasics)this.initialLinearVelocity);
        this.currentStateProvider.getOrientation((FixedFrameQuaternionBasics)this.initialOrientation);
        this.currentStateProvider.getAngularVelocity((FixedFrameVector3DBasics)this.initialAngularVelocity);
        if (this.swingTrajectoryParameters.ignoreSwingInitialAngularVelocityZ()) {
            this.initialAngularVelocity.changeFrame(worldFrame);
            this.initialAngularVelocity.setZ(0.0);
        }
        this.initialLinearVelocity.clipToMaxLength(this.swingTrajectoryParameters.getMaxSwingInitialLinearVelocityMagnitude());
        this.initialAngularVelocity.clipToMaxLength(this.swingTrajectoryParameters.getMaxSwingInitialAngularVelocityMagnitude());
        this.stanceFootPosition.setToZero(this.oppositeSoleFrame);
    }

    public void initializeTrajectoryWaypoints(boolean initializeOptimizer) {
        this.finalLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.swingTrajectoryParameters.getDesiredTouchdownVelocity());
        this.finalAngularVelocity.setToZero(worldFrame);
        if (!this.finalCoMVelocity.containsNaN()) {
            double injectionRatio = this.swingTrajectoryParameters.getFinalCoMVelocityInjectionRatio();
            this.finalLinearVelocity.setX(injectionRatio * this.finalCoMVelocity.getX());
            this.finalLinearVelocity.setY(injectionRatio * this.finalCoMVelocity.getY());
        }
        this.swingTrajectory.clear(worldFrame);
        if (this.activeTrajectoryType.getEnumValue() == TrajectoryType.WAYPOINTS) {
            this.setTrajectoryFromWaypoints();
        } else {
            this.setTrajectoryFromOptimizer(initializeOptimizer);
        }
        this.swingTrajectory.initialize();
    }

    public MultipleWaypointsPoseTrajectoryGenerator getSwingTrajectory() {
        return this.swingTrajectory;
    }

    public int getNumberOfSwingWaypoints() {
        return this.swingWaypoints.size();
    }

    public FrameSE3TrajectoryPointBasics getSwingWaypoint(int index) {
        return (FrameSE3TrajectoryPointBasics)this.swingWaypoints.get(index);
    }

    public FrameSE3TrajectoryPointBasics getLastSwingWaypoint() {
        return (FrameSE3TrajectoryPointBasics)this.swingWaypoints.getLast();
    }

    private void initializeTrajectoryOptimizer() {
        this.swingTrajectoryOptimizer.setInitialConditions((FramePoint3DReadOnly)this.initialPosition, (FrameVector3DReadOnly)this.initialLinearVelocity);
        this.swingTrajectoryOptimizer.setFinalConditions((FramePoint3DReadOnly)this.finalPosition, (FrameVector3DReadOnly)this.finalLinearVelocity);
        this.swingTrajectoryOptimizer.setFinalConditionWeights(null, this.swingTrajectoryParameters.getTouchdownVelocityWeight());
        this.swingTrajectoryOptimizer.setStepTime(this.swingDuration.getValue());
        this.swingTrajectoryOptimizer.setTrajectoryType((TrajectoryType)this.activeTrajectoryType.getEnumValue(), this.positionWaypointsForSole);
        this.swingTrajectoryOptimizer.setSwingHeight(this.swingHeight.getDoubleValue());
        this.swingTrajectoryOptimizer.setStanceFootPosition((FramePoint3DReadOnly)this.stanceFootPosition);
        this.swingTrajectoryOptimizer.setWaypointProportions(this.waypointProportions);
        this.swingTrajectoryOptimizer.initialize();
    }

    private boolean checkStepUpOrDown(FramePoint3DReadOnly footstepPosition) {
        double zDifference = Math.abs(footstepPosition.getZ() - this.lastFootstepPosition.getZ());
        return zDifference > this.swingTrajectoryParameters.getMinHeightDifferenceForStepUpOrDown();
    }

    private void modifyFinalOrientationForTouchdown(FrameQuaternion finalOrientationToPack) {
        double footstepPitchModification;
        this.finalPosition.changeFrame(this.oppositeSoleZUpFrame);
        this.stanceFootPosition.changeFrame(this.oppositeSoleZUpFrame);
        double stepHeight = this.finalPosition.getZ() - this.stanceFootPosition.getZ();
        double initialFootstepPitch = finalOrientationToPack.getPitch();
        if (MathTools.intervalContains((double)stepHeight, (double)this.swingTrajectoryParameters.getStepDownHeightForToeTouchdown(), (double)this.swingTrajectoryParameters.getMaximumHeightForHeelTouchdown()) && this.swingTrajectoryParameters.doHeelTouchdownIfPossible()) {
            double stepLength = this.finalPosition.getX() - this.stanceFootPosition.getX();
            double heelTouchdownAngle = MathTools.clamp((double)(-stepLength * this.swingTrajectoryParameters.getHeelTouchdownLengthRatio()), (double)(-this.swingTrajectoryParameters.getHeelTouchdownAngle()));
            footstepPitchModification = Math.max(initialFootstepPitch, heelTouchdownAngle);
            footstepPitchModification = Math.min(footstepPitchModification, heelTouchdownAngle + initialFootstepPitch);
            footstepPitchModification -= initialFootstepPitch;
        } else if (stepHeight < this.swingTrajectoryParameters.getStepDownHeightForToeTouchdown() && this.swingTrajectoryParameters.doToeTouchdownIfPossible()) {
            double toeTouchdownAngle = MathTools.clamp((double)(-this.swingTrajectoryParameters.getToeTouchdownDepthRatio() * (stepHeight - this.swingTrajectoryParameters.getStepDownHeightForToeTouchdown())), (double)this.swingTrajectoryParameters.getToeTouchdownAngle());
            footstepPitchModification = Math.max(toeTouchdownAngle, initialFootstepPitch);
            footstepPitchModification -= initialFootstepPitch;
        } else {
            footstepPitchModification = 0.0;
        }
        finalOrientationToPack.appendPitchRotation(footstepPitchModification);
    }

    private void setWaypointsFromStepPosition(Footstep footstep) {
        RecyclingArrayList customWaypointProportions;
        this.swingHeight.set(footstep.getSwingHeight());
        if (this.checkStepUpOrDown((FramePoint3DReadOnly)this.finalPosition)) {
            this.activeTrajectoryType.set((Enum)TrajectoryType.OBSTACLE_CLEARANCE);
        }
        if ((customWaypointProportions = footstep.getCustomWaypointProportions()).size() != 2) {
            if (!customWaypointProportions.isEmpty()) {
                LogTools.warn((String)("Ignoring custom waypoint proportions. Expected 2, got: " + customWaypointProportions.size()));
            }
            List<DoubleProvider> waypointProportions = this.activeTrajectoryType.getEnumValue() == TrajectoryType.OBSTACLE_CLEARANCE ? this.swingTrajectoryParameters.getObstacleClearanceProportions() : this.swingTrajectoryParameters.getSwingWaypointProportions();
            this.waypointProportions[0] = waypointProportions.get(0).getValue();
            this.waypointProportions[1] = waypointProportions.get(1).getValue();
        } else {
            this.waypointProportions[0] = ((MutableDouble)customWaypointProportions.get(0)).getValue();
            this.waypointProportions[1] = ((MutableDouble)customWaypointProportions.get(1)).getValue();
        }
    }

    private void setWaypointsFromCustomMidpoints(List<FramePoint3D> positionWaypointsForSole) {
        for (int i = 0; i < positionWaypointsForSole.size(); ++i) {
            ((FramePoint3D)this.positionWaypointsForSole.add()).setIncludingFrame((FrameTuple3DReadOnly)positionWaypointsForSole.get(i));
        }
    }

    private void setWaypointsFromExternal(List<FrameSE3TrajectoryPoint> swingWaypoints) {
        for (int i = 0; i < swingWaypoints.size(); ++i) {
            ((FrameSE3TrajectoryPoint)this.swingWaypoints.add()).set((FrameSE3TrajectoryPointBasics)swingWaypoints.get(i));
        }
    }

    private void setTrajectoryFromWaypoints() {
        boolean appendFootstepPose;
        if (((FrameSE3TrajectoryPoint)this.swingWaypoints.get(0)).getTime() > 1.0E-5) {
            this.swingTrajectory.appendPositionWaypoint(0.0, this.initialPosition, this.initialLinearVelocity);
            this.swingTrajectory.appendOrientationWaypoint(0.0, this.initialOrientation, this.initialAngularVelocity);
        }
        for (int i = 0; i < this.swingWaypoints.size(); ++i) {
            this.swingTrajectory.appendPoseWaypoint((FrameSE3TrajectoryPoint)this.swingWaypoints.get(i));
        }
        boolean bl = appendFootstepPose = !Precision.equals((double)((FrameSE3TrajectoryPoint)this.swingWaypoints.getLast()).getTime(), (double)this.swingDuration.getDoubleValue());
        if (appendFootstepPose) {
            this.modifyFinalOrientationForTouchdown(this.finalOrientation);
            this.swingTrajectory.appendPositionWaypoint(this.swingDuration.getDoubleValue(), this.finalPosition, this.finalLinearVelocity);
            this.swingTrajectory.appendOrientationWaypoint(this.swingDuration.getDoubleValue(), this.finalOrientation, this.finalAngularVelocity);
        } else {
            FrameSE3TrajectoryPoint lastPoint = (FrameSE3TrajectoryPoint)this.swingWaypoints.getLast();
            lastPoint.getPositionIncludingFrame((FramePoint3DBasics)this.finalPosition);
            lastPoint.getLinearVelocityIncludingFrame((FrameVector3DBasics)this.finalLinearVelocity);
            lastPoint.getOrientationIncludingFrame((FrameQuaternionBasics)this.finalOrientation);
            lastPoint.getAngularVelocity((FixedFrameVector3DBasics)this.finalAngularVelocity);
        }
    }

    private void setTrajectoryFromOptimizer(boolean initializeOptimizer) {
        if (initializeOptimizer) {
            this.initializeTrajectoryOptimizer();
        }
        this.swingTrajectory.appendPositionWaypoint(0.0, this.initialPosition, this.initialLinearVelocity);
        this.swingTrajectory.appendOrientationWaypoint(0.0, this.initialOrientation, this.initialAngularVelocity);
        for (int i = 0; i < this.swingTrajectoryOptimizer.getNumberOfWaypoints(); ++i) {
            this.swingTrajectoryOptimizer.getWaypointData(i, this.tempPositionTrajectoryPoint);
            this.swingTrajectory.appendPositionWaypoint(this.tempPositionTrajectoryPoint);
        }
        if (this.swingTrajectoryParameters.addOrientationMidpointForObstacleClearance() && this.activeTrajectoryType.getEnumValue() == TrajectoryType.OBSTACLE_CLEARANCE) {
            this.tmpOrientation.setToZero(worldFrame);
            this.tmpVector.setToZero(worldFrame);
            this.tmpOrientation.interpolate((FrameQuaternionReadOnly)this.initialOrientation, (FrameQuaternionReadOnly)this.finalOrientation, this.swingTrajectoryParameters.getMidpointOrientationInterpolationForObstacleClearance());
            this.swingTrajectory.appendOrientationWaypoint(0.5 * this.swingDuration.getDoubleValue(), this.tmpOrientation, this.tmpVector);
        }
        this.modifyFinalOrientationForTouchdown(this.finalOrientation);
        this.swingTrajectoryOptimizer.getFinalVelocity((FrameVector3DBasics)this.finalLinearVelocity);
        this.swingTrajectory.appendPositionWaypoint(this.swingDuration.getDoubleValue(), this.finalPosition, this.finalLinearVelocity);
        this.swingTrajectory.appendOrientationWaypoint(this.swingDuration.getDoubleValue(), this.finalOrientation, this.finalAngularVelocity);
    }
}

