/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.controlModules.TaskspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector2D;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class PelvisICPBasedTranslationManager {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble supportPolygonSafeMargin = new YoDouble("supportPolygonSafeMargin", this.registry);
    private final DoubleProvider frozenOffsetDecayBreakFrequency = new DoubleParameter("frozenOffsetDecayBreakFrequency", this.registry, 0.0531);
    private final double dt;
    private final YoFramePoint2D desiredPelvisPosition = new YoFramePoint2D("desiredPelvis", worldFrame, this.registry);
    private final YoFramePoint2D currentPelvisPosition = new YoFramePoint2D("currentPelvis", worldFrame, this.registry);
    private final YoDouble initialPelvisPositionTime = new YoDouble("initialPelvisPositionTime", this.registry);
    private final MultipleWaypointsPositionTrajectoryGenerator positionTrajectoryGenerator;
    private final YoFrameVector2D pelvisPositionError = new YoFrameVector2D("pelvisPositionError", worldFrame, this.registry);
    private final YoDouble proportionalGain = new YoDouble("pelvisPositionProportionalGain", this.registry);
    private final YoFrameVector2D proportionalTerm = new YoFrameVector2D("pelvisPositionProportionalTerm", worldFrame, this.registry);
    private final YoFrameVector2D pelvisPositionCumulatedError = new YoFrameVector2D("pelvisPositionCumulatedError", worldFrame, this.registry);
    private final YoDouble integralGain = new YoDouble("pelvisPositionIntegralGain", this.registry);
    private final YoFrameVector2D integralTerm = new YoFrameVector2D("pelvisPositionIntegralTerm", worldFrame, this.registry);
    private final YoDouble maximumIntegralError = new YoDouble("maximumPelvisPositionIntegralError", this.registry);
    private final YoFrameVector2D desiredICPOffset = new YoFrameVector2D("desiredICPOffset", worldFrame, this.registry);
    private final Vector2DReadOnly userOffset = new ParameterVector2D("userDesiredICPOffset", (Vector2DReadOnly)new Vector2D(), this.registry);
    private final YoBoolean isEnabled = new YoBoolean("isPelvisTranslationManagerEnabled", this.registry);
    private final YoBoolean isRunning = new YoBoolean("isPelvisTranslationManagerRunning", this.registry);
    private final YoBoolean isFrozen = new YoBoolean("isPelvisTranslationManagerFrozen", this.registry);
    private final BooleanParameter manualMode = new BooleanParameter("manualModeICPOffset", this.registry, false);
    private final YoDouble yoTime;
    private final double controlDT;
    private final YoBoolean isTrajectoryStopped = new YoBoolean("isPelvisTranslationalTrajectoryStopped", this.registry);
    private ReferenceFrame supportFrame;
    private final ReferenceFrame pelvisZUpFrame;
    private final ReferenceFrame midFeetZUpFrame;
    private final SideDependentList<MovingReferenceFrame> soleZUpFrames;
    private final BipedSupportPolygons bipedSupportPolygons;
    private FrameConvexPolygon2DReadOnly supportPolygon;
    private final FramePoint3D tempPosition = new FramePoint3D();
    private final FrameVector3D tempVelocity = new FrameVector3D();
    private final FramePoint2D tempPosition2d = new FramePoint2D();
    private final FrameVector2D tempError2d = new FrameVector2D();
    private final FrameVector2D tempICPOffset = new FrameVector2D();
    private final FrameVector2D icpOffsetForFreezing = new FrameVector2D();
    private final YoLong lastCommandId;
    private final YoBoolean isReadyToHandleQueuedCommands;
    private final YoLong numberOfQueuedCommands;
    private final PelvisTrajectoryCommand commandBeingProcessed = new PelvisTrajectoryCommand();
    private final RecyclingArrayDeque<PelvisTrajectoryCommand> commandQueue = new RecyclingArrayDeque(PelvisTrajectoryCommand.class, PelvisTrajectoryCommand::set);
    private final YoDouble streamTimestampOffset = new YoDouble("pelvisTranslationStreamTimestampOffset", this.registry);
    private final YoDouble streamTimestampSource = new YoDouble("pelvisTranslationStreamTimestampSource", this.registry);
    private final TaskspaceTrajectoryStatusMessageHelper statusHelper = new TaskspaceTrajectoryStatusMessageHelper("pelvisXY");
    private final FrameSE3TrajectoryPoint trajectoryPointLocal = new FrameSE3TrajectoryPoint();
    private final ConvexPolygonScaler convexPolygonShrinker = new ConvexPolygonScaler();
    private final FrameConvexPolygon2D safeSupportPolygonToConstrainICPOffset = new FrameConvexPolygon2D();
    private final FramePoint2D originalICPToModify = new FramePoint2D();

    public PelvisICPBasedTranslationManager(HighLevelHumanoidControllerToolbox controllerToolbox, double pelvisTranslationICPSupportPolygonSafeMargin, BipedSupportPolygons bipedSupportPolygons, YoRegistry parentRegistry) {
        this.dt = controllerToolbox.getControlDT();
        this.supportPolygonSafeMargin.set(pelvisTranslationICPSupportPolygonSafeMargin);
        this.yoTime = controllerToolbox.getYoTime();
        this.controlDT = controllerToolbox.getControlDT();
        this.pelvisZUpFrame = controllerToolbox.getPelvisZUpFrame();
        this.midFeetZUpFrame = controllerToolbox.getReferenceFrames().getMidFeetZUpFrame();
        this.soleZUpFrames = controllerToolbox.getReferenceFrames().getSoleZUpFrames();
        this.bipedSupportPolygons = bipedSupportPolygons;
        this.positionTrajectoryGenerator = new MultipleWaypointsPositionTrajectoryGenerator("pelvisOffset", 5, worldFrame, this.registry);
        this.proportionalGain.set(0.5);
        this.integralGain.set(1.5);
        this.maximumIntegralError.set(0.08);
        this.manualMode.addListener(new YoParameterChangedListener(){

            public void changed(YoParameter v) {
                PelvisICPBasedTranslationManager.this.initialize();
            }
        });
        String namePrefix = "PelvisXYTranslation";
        this.lastCommandId = new YoLong(namePrefix + "LastCommandId", this.registry);
        this.lastCommandId.set(0L);
        this.isReadyToHandleQueuedCommands = new YoBoolean(namePrefix + "IsReadyToHandleQueuedPelvisTrajectoryCommands", this.registry);
        this.numberOfQueuedCommands = new YoLong(namePrefix + "NumberOfQueuedCommands", this.registry);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
        parentRegistry.addChild(this.registry);
    }

    public void compute(RobotSide supportLeg) {
        this.tempPosition2d.setToZero(this.pelvisZUpFrame);
        this.tempPosition2d.changeFrame(worldFrame);
        this.currentPelvisPosition.set((FrameTuple2DReadOnly)this.tempPosition2d);
        if (this.isFrozen.getBooleanValue()) {
            double alpha = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.frozenOffsetDecayBreakFrequency.getValue(), (double)this.dt);
            this.icpOffsetForFreezing.scale(alpha);
            return;
        }
        if (supportLeg == null) {
            this.supportFrame = this.midFeetZUpFrame;
            this.supportPolygon = this.bipedSupportPolygons.getSupportPolygonInMidFeetZUp();
        } else {
            this.supportFrame = (ReferenceFrame)this.soleZUpFrames.get((Enum)supportLeg);
            this.supportPolygon = this.bipedSupportPolygons.getFootPolygonInSoleZUpFrame(supportLeg);
        }
        if (!this.isEnabled.getBooleanValue()) {
            this.desiredICPOffset.setToZero();
            return;
        }
        if (this.manualMode.getValue()) {
            return;
        }
        if (this.isRunning.getBooleanValue()) {
            if (!this.isTrajectoryStopped.getBooleanValue()) {
                double deltaTime = this.yoTime.getDoubleValue() - this.initialPelvisPositionTime.getDoubleValue();
                this.statusHelper.updateWithTimeInTrajectory(deltaTime);
                this.positionTrajectoryGenerator.compute(deltaTime);
                if (this.positionTrajectoryGenerator.isDone()) {
                    if (!this.commandQueue.isEmpty()) {
                        double firstTrajectoryPointTime = this.positionTrajectoryGenerator.getLastWaypointTime();
                        this.commandBeingProcessed.set((PelvisTrajectoryCommand)this.commandQueue.poll());
                        this.numberOfQueuedCommands.decrement();
                        this.initializeTrajectoryGenerator(this.commandBeingProcessed, firstTrajectoryPointTime);
                        this.positionTrajectoryGenerator.compute(deltaTime);
                        if (this.positionTrajectoryGenerator.isDone()) {
                            this.streamTimestampOffset.setToNaN();
                            this.streamTimestampSource.setToNaN();
                        }
                    } else {
                        this.streamTimestampOffset.setToNaN();
                        this.streamTimestampSource.setToNaN();
                    }
                }
            }
            this.tempPosition.setIncludingFrame((FrameTuple3DReadOnly)this.positionTrajectoryGenerator.getPosition());
            this.tempPosition.changeFrame(this.desiredPelvisPosition.getReferenceFrame());
            this.desiredPelvisPosition.set((FrameTuple3DReadOnly)this.tempPosition);
        }
        if (!this.isRunning.getBooleanValue()) {
            this.desiredICPOffset.setToZero();
            return;
        }
        this.computeDesiredICPOffset();
    }

    public boolean isEnabled() {
        return this.isEnabled.getBooleanValue();
    }

    public void goToHome() {
        this.freeze();
    }

    public void holdCurrentPosition() {
        this.initialPelvisPositionTime.set(this.yoTime.getDoubleValue());
        this.tempPosition.setToZero(this.pelvisZUpFrame);
        this.tempPosition.changeFrame(worldFrame);
        this.tempVelocity.setToZero(worldFrame);
        this.positionTrajectoryGenerator.clear();
        this.positionTrajectoryGenerator.changeFrame(worldFrame);
        this.positionTrajectoryGenerator.appendWaypoint(0.0, (FramePoint3DReadOnly)this.tempPosition, (FrameVector3DReadOnly)this.tempVelocity);
        this.positionTrajectoryGenerator.initialize();
        this.isTrajectoryStopped.set(false);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
        this.isRunning.set(true);
    }

    public void handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
        SelectionMatrix3D linearSelectionMatrix = se3Trajectory.getSelectionMatrix().getLinearPart();
        if (!linearSelectionMatrix.isXSelected() && !linearSelectionMatrix.isYSelected()) {
            return;
        }
        se3Trajectory.setSequenceId(command.getSequenceId());
        if (se3Trajectory.getExecutionMode() == ExecutionMode.OVERRIDE) {
            this.isReadyToHandleQueuedCommands.set(true);
            this.clearCommandQueue(se3Trajectory.getCommandId());
            this.initialPelvisPositionTime.set(this.yoTime.getDoubleValue());
            this.initializeTrajectoryGenerator(command, 0.0);
            this.streamTimestampOffset.setToNaN();
            this.streamTimestampSource.setToNaN();
            this.statusHelper.registerNewTrajectory(se3Trajectory);
            return;
        }
        if (se3Trajectory.getExecutionMode() == ExecutionMode.QUEUE) {
            boolean success = this.queuePelvisTrajectoryCommand(command);
            if (!success) {
                this.isReadyToHandleQueuedCommands.set(false);
                this.clearCommandQueue(0L);
                this.holdCurrentPosition();
            } else {
                this.statusHelper.registerNewTrajectory(se3Trajectory);
            }
            this.streamTimestampOffset.setToNaN();
            this.streamTimestampSource.setToNaN();
            return;
        }
        if (se3Trajectory.getExecutionMode() == ExecutionMode.STREAM) {
            double timeOffset = 0.0;
            if (se3Trajectory.getTimestamp() <= 0L) {
                this.streamTimestampOffset.setToNaN();
                this.streamTimestampSource.setToNaN();
            } else {
                double senderTime = Conversions.nanosecondsToSeconds((long)se3Trajectory.getTimestamp());
                if (!this.streamTimestampSource.isNaN() && senderTime < this.streamTimestampSource.getValue()) {
                    return;
                }
                this.streamTimestampSource.set(senderTime);
                timeOffset = this.yoTime.getValue() - senderTime;
                if (Double.isNaN(this.streamTimestampOffset.getValue())) {
                    this.streamTimestampOffset.set(timeOffset);
                } else if (Math.abs(timeOffset - this.streamTimestampOffset.getValue()) > 0.5) {
                    this.streamTimestampOffset.set(timeOffset);
                } else {
                    this.streamTimestampOffset.set(Math.min(timeOffset, this.streamTimestampOffset.getValue()));
                }
            }
            this.isReadyToHandleQueuedCommands.set(true);
            this.clearCommandQueue(se3Trajectory.getCommandId());
            this.initialPelvisPositionTime.set(this.yoTime.getDoubleValue());
            if (se3Trajectory.getNumberOfTrajectoryPoints() != 1) {
                LogTools.warn((String)("When streaming, trajectories should contain only 1 trajectory point, was: " + se3Trajectory.getNumberOfTrajectoryPoints()));
                this.holdCurrentPosition();
                return;
            }
            FrameSE3TrajectoryPoint trajectoryPoint = se3Trajectory.getTrajectoryPoint(0);
            if (trajectoryPoint.getTime() != 0.0) {
                LogTools.warn((String)("When streaming, the trajectory point should have a time of zero, was: " + trajectoryPoint.getTime()));
                this.holdCurrentPosition();
                return;
            }
            this.trajectoryPointLocal.setIncludingFrame((FrameSE3TrajectoryPointBasics)trajectoryPoint);
            if (!this.streamTimestampOffset.isNaN()) {
                this.trajectoryPointLocal.setTime(this.streamTimestampOffset.getValue() - timeOffset);
            }
            this.positionTrajectoryGenerator.clear();
            this.positionTrajectoryGenerator.changeFrame(worldFrame);
            this.positionTrajectoryGenerator.appendWaypoint(this.trajectoryPointLocal);
            this.tempPosition.setIncludingFrame((FrameTuple3DReadOnly)this.trajectoryPointLocal.getLinearVelocity());
            this.tempPosition.scaleAdd(se3Trajectory.getStreamIntegrationDuration(), (FrameTuple3DReadOnly)trajectoryPoint.getPosition());
            this.positionTrajectoryGenerator.appendWaypoint(se3Trajectory.getStreamIntegrationDuration() + this.trajectoryPointLocal.getTime(), (FramePoint3DReadOnly)this.tempPosition, trajectoryPoint.getLinearVelocity());
            if (this.supportFrame != null) {
                this.positionTrajectoryGenerator.changeFrame(this.supportFrame);
            } else {
                this.positionTrajectoryGenerator.changeFrame(worldFrame);
            }
            this.positionTrajectoryGenerator.initialize();
            this.isTrajectoryStopped.set(false);
            this.isRunning.set(true);
            if (se3Trajectory.getExecutionMode() != ExecutionMode.STREAM) {
                this.statusHelper.registerNewTrajectory(se3Trajectory);
            }
            return;
        }
        LogTools.warn((String)("Unknown " + ExecutionMode.class.getSimpleName() + " value: " + se3Trajectory.getExecutionMode() + ". Command ignored."));
    }

    private boolean queuePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        if (!this.isReadyToHandleQueuedCommands.getBooleanValue()) {
            LogTools.warn((String)("The very first " + command.getClass().getSimpleName() + " of a series must be " + ExecutionMode.OVERRIDE + ". Aborting motion."));
            return false;
        }
        SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
        long previousCommandId = se3Trajectory.getPreviousCommandId();
        if (previousCommandId != 0L && this.lastCommandId.getLongValue() != 0L && this.lastCommandId.getLongValue() != previousCommandId) {
            LogTools.warn((String)("Previous command ID mismatch: previous ID from command = " + previousCommandId + ", last message ID received by the controller = " + this.lastCommandId.getLongValue() + ". Aborting motion."));
            return false;
        }
        if (se3Trajectory.getTrajectoryPoint(0).getTime() < 1.0E-5) {
            LogTools.warn((String)"Time of the first trajectory point of a queued command must be greater than zero. Aborting motion.");
            return false;
        }
        this.commandQueue.add((Object)command);
        this.numberOfQueuedCommands.increment();
        this.lastCommandId.set(se3Trajectory.getCommandId());
        return true;
    }

    private void initializeTrajectoryGenerator(PelvisTrajectoryCommand command, double firstTrajectoryPointTime) {
        SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
        se3Trajectory.addTimeOffset(firstTrajectoryPointTime);
        if (se3Trajectory.getTrajectoryPoint(0).getTime() > 1.0E-5) {
            if (this.isRunning.getBooleanValue()) {
                this.tempPosition.setIncludingFrame((FrameTuple3DReadOnly)this.positionTrajectoryGenerator.getPosition());
            } else {
                this.tempPosition.setToZero(this.pelvisZUpFrame);
            }
            this.tempPosition.changeFrame(worldFrame);
            this.tempVelocity.setToZero(worldFrame);
            this.positionTrajectoryGenerator.clear();
            this.positionTrajectoryGenerator.changeFrame(worldFrame);
            this.positionTrajectoryGenerator.appendWaypoint(0.0, (FramePoint3DReadOnly)this.tempPosition, (FrameVector3DReadOnly)this.tempVelocity);
        } else {
            this.positionTrajectoryGenerator.clear();
            this.positionTrajectoryGenerator.changeFrame(worldFrame);
        }
        int numberOfTrajectoryPoints = this.queueExceedingTrajectoryPointsIfNeeded(command);
        for (int trajectoryPointIndex = 0; trajectoryPointIndex < numberOfTrajectoryPoints; ++trajectoryPointIndex) {
            this.positionTrajectoryGenerator.appendWaypoint(se3Trajectory.getTrajectoryPoint(trajectoryPointIndex));
        }
        if (this.supportFrame != null) {
            this.positionTrajectoryGenerator.changeFrame(this.supportFrame);
        } else {
            this.positionTrajectoryGenerator.changeFrame(worldFrame);
        }
        this.positionTrajectoryGenerator.initialize();
        this.isTrajectoryStopped.set(false);
        this.isRunning.set(true);
    }

    private int queueExceedingTrajectoryPointsIfNeeded(PelvisTrajectoryCommand command) {
        int maximumNumberOfWaypoints;
        int numberOfTrajectoryPoints = command.getSE3Trajectory().getNumberOfTrajectoryPoints();
        if (numberOfTrajectoryPoints <= (maximumNumberOfWaypoints = this.positionTrajectoryGenerator.getMaximumNumberOfWaypoints() - this.positionTrajectoryGenerator.getCurrentNumberOfWaypoints())) {
            return numberOfTrajectoryPoints;
        }
        PelvisTrajectoryCommand commandForExcedent = (PelvisTrajectoryCommand)this.commandQueue.addFirst();
        this.numberOfQueuedCommands.increment();
        commandForExcedent.clear();
        commandForExcedent.getSE3Trajectory().setPropertiesOnly(command.getSE3Trajectory());
        for (int trajectoryPointIndex = maximumNumberOfWaypoints; trajectoryPointIndex < numberOfTrajectoryPoints; ++trajectoryPointIndex) {
            commandForExcedent.getSE3Trajectory().addTrajectoryPoint(command.getSE3Trajectory().getTrajectoryPoint(trajectoryPointIndex));
        }
        double timeOffsetToSubtract = command.getSE3Trajectory().getTrajectoryPoint(maximumNumberOfWaypoints - 1).getTime();
        commandForExcedent.getSE3Trajectory().subtractTimeOffset(timeOffsetToSubtract);
        return maximumNumberOfWaypoints;
    }

    private void clearCommandQueue(long lastCommandId) {
        this.commandQueue.clear();
        this.numberOfQueuedCommands.set(0L);
        this.lastCommandId.set(lastCommandId);
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        this.isTrajectoryStopped.set(command.isStopAllTrajectory());
    }

    private void computeDesiredICPOffset() {
        this.pelvisPositionError.set((FrameTuple2DReadOnly)this.desiredPelvisPosition);
        this.tempPosition2d.setToZero(this.pelvisZUpFrame);
        this.tempPosition2d.changeFrame(worldFrame);
        this.pelvisPositionError.sub((FrameTuple2DReadOnly)this.tempPosition2d);
        this.tempError2d.setIncludingFrame((FrameTuple2DReadOnly)this.pelvisPositionError);
        this.tempError2d.scale(this.controlDT);
        this.pelvisPositionCumulatedError.add((FrameTuple2DReadOnly)this.tempError2d);
        double cumulativeErrorMagnitude = this.pelvisPositionCumulatedError.length();
        if (cumulativeErrorMagnitude > this.maximumIntegralError.getDoubleValue()) {
            this.pelvisPositionCumulatedError.scale(this.maximumIntegralError.getDoubleValue() / cumulativeErrorMagnitude);
        }
        this.proportionalTerm.set((FrameTuple2DReadOnly)this.pelvisPositionError);
        this.proportionalTerm.scale(this.proportionalGain.getDoubleValue());
        this.integralTerm.set((FrameTuple2DReadOnly)this.pelvisPositionCumulatedError);
        this.integralTerm.scale(this.integralGain.getDoubleValue());
        this.desiredICPOffset.set((FrameTuple2DReadOnly)this.proportionalTerm);
        this.desiredICPOffset.add((FrameTuple2DReadOnly)this.integralTerm);
    }

    public void addICPOffset(FramePoint2D desiredICPToModify, FramePoint2D desiredCoMToModify, FramePoint2D desiredCoPToModify) {
        desiredICPToModify.changeFrame(this.supportPolygon.getReferenceFrame());
        desiredCoPToModify.changeFrame(this.supportPolygon.getReferenceFrame());
        desiredCoMToModify.changeFrame(this.supportPolygon.getReferenceFrame());
        this.originalICPToModify.setIncludingFrame((FrameTuple2DReadOnly)desiredICPToModify);
        if (!this.isEnabled.getBooleanValue() || !this.isRunning.getBooleanValue() && !this.manualMode.getValue()) {
            this.desiredICPOffset.setToZero();
            this.icpOffsetForFreezing.setToZero();
            desiredICPToModify.changeFrame(worldFrame);
            desiredCoMToModify.changeFrame(worldFrame);
            desiredCoPToModify.changeFrame(worldFrame);
            return;
        }
        if (this.manualMode.getValue()) {
            this.tempICPOffset.setIncludingFrame(this.supportFrame, this.userOffset.getX(), this.userOffset.getY());
        } else {
            this.tempICPOffset.setIncludingFrame((FrameTuple2DReadOnly)this.desiredICPOffset);
            this.tempICPOffset.changeFrame(this.supportFrame);
        }
        if (this.isFrozen.getBooleanValue()) {
            this.desiredICPOffset.setMatchingFrame((FrameTuple2DReadOnly)this.icpOffsetForFreezing);
            desiredICPToModify.changeFrame(this.icpOffsetForFreezing.getReferenceFrame());
            desiredCoPToModify.changeFrame(this.icpOffsetForFreezing.getReferenceFrame());
            desiredCoMToModify.changeFrame(this.icpOffsetForFreezing.getReferenceFrame());
            desiredICPToModify.add((FrameTuple2DReadOnly)this.icpOffsetForFreezing);
            desiredCoPToModify.add((FrameTuple2DReadOnly)this.icpOffsetForFreezing);
            desiredCoMToModify.add((FrameTuple2DReadOnly)this.icpOffsetForFreezing);
        } else {
            desiredICPToModify.add((FrameTuple2DReadOnly)this.tempICPOffset);
            desiredCoPToModify.add((FrameTuple2DReadOnly)this.tempICPOffset);
            desiredCoMToModify.add((FrameTuple2DReadOnly)this.tempICPOffset);
            this.convexPolygonShrinker.scaleConvexPolygon(this.supportPolygon, this.supportPolygonSafeMargin.getDoubleValue(), this.safeSupportPolygonToConstrainICPOffset);
            this.safeSupportPolygonToConstrainICPOffset.orthogonalProjection((FramePoint2DBasics)desiredICPToModify);
            this.safeSupportPolygonToConstrainICPOffset.orthogonalProjection((FramePoint2DBasics)desiredCoPToModify);
            this.icpOffsetForFreezing.setIncludingFrame((FrameTuple2DReadOnly)desiredICPToModify);
            this.icpOffsetForFreezing.sub((FrameTuple2DReadOnly)this.originalICPToModify);
        }
        desiredICPToModify.changeFrame(worldFrame);
        desiredCoMToModify.changeFrame(worldFrame);
        desiredCoPToModify.changeFrame(worldFrame);
    }

    public void disable() {
        this.isEnabled.set(false);
        this.isRunning.set(false);
        this.isFrozen.set(false);
        this.isTrajectoryStopped.set(false);
        this.pelvisPositionError.setToZero();
        this.pelvisPositionCumulatedError.setToZero();
        this.proportionalTerm.setToZero();
        this.integralTerm.setToZero();
        this.desiredICPOffset.setToZero();
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
    }

    public void enable() {
        if (this.isEnabled.getBooleanValue()) {
            return;
        }
        this.isEnabled.set(true);
        this.isFrozen.set(false);
        this.isTrajectoryStopped.set(false);
        this.initialize();
    }

    public void freeze() {
        this.isFrozen.set(true);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
    }

    private void initialize() {
        this.initialPelvisPositionTime.set(this.yoTime.getDoubleValue());
        this.tempPosition.setToZero(this.pelvisZUpFrame);
        this.tempPosition.changeFrame(worldFrame);
        this.tempVelocity.setToZero(worldFrame);
        this.positionTrajectoryGenerator.clear(worldFrame);
        this.positionTrajectoryGenerator.appendWaypoint(0.0, (FramePoint3DReadOnly)this.tempPosition, (FrameVector3DReadOnly)this.tempVelocity);
        this.positionTrajectoryGenerator.initialize();
        this.isTrajectoryStopped.set(false);
        this.streamTimestampOffset.setToNaN();
        this.streamTimestampSource.setToNaN();
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.statusHelper.pollStatusMessage((FramePoint2DReadOnly)this.desiredPelvisPosition, (FramePoint2DReadOnly)this.currentPelvisPosition);
    }
}

