/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import controller_msgs.msg.dds.JointspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TrajectoryStatusMessageHelper;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.OneDoFJointTrajectoryCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;

public class OneDoFJointTrajectoryStatusMessageHelper
extends TrajectoryStatusMessageHelper<JointspaceTrajectoryStatusMessage> {
    private final JointspaceTrajectoryStatusMessage statusMessage = new JointspaceTrajectoryStatusMessage();

    public OneDoFJointTrajectoryStatusMessageHelper(OneDoFJointReadOnly joint) {
        this.statusMessage.getJointNames().add(joint.getName());
        this.statusMessage.getActualJointPositions().add(Double.NaN);
        this.statusMessage.getDesiredJointPositions().add(Double.NaN);
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.statusMessage.getActualJointPositions().set(0, Double.NaN);
        this.statusMessage.getDesiredJointPositions().set(0, Double.NaN);
    }

    public void registerNewTrajectory(OneDoFJointTrajectoryCommand command, ExecutionMode executionMode) {
        if (executionMode == ExecutionMode.OVERRIDE) {
            this.clear();
            this.registerNewTrajectory(command.getSequenceId(), 0.0, command.getTrajectoryTime());
        } else {
            this.registerNewTrajectory(command.getSequenceId(), command.getTrajectoryPoint(0).getTime(), command.getTrajectoryTime());
        }
    }

    public JointspaceTrajectoryStatusMessage pollStatusMessage(double qCurrent, double qDesired) {
        TrajectoryStatusMessageHelper.TrajectoryStatus currentStatus = this.pollStatus();
        if (currentStatus == null) {
            return null;
        }
        this.statusMessage.setSequenceId(currentStatus.getSequenceID());
        this.statusMessage.setTimestamp(currentStatus.getTimeInTrajectory());
        this.statusMessage.setTrajectoryExecutionStatus(currentStatus.getStatus().toByte());
        this.statusMessage.getActualJointPositions().set(0, qCurrent);
        this.statusMessage.getDesiredJointPositions().set(0, qDesired);
        return this.statusMessage;
    }
}

