/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.sensors.ForceSensorData;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ForceSensorToJointTorqueProjector
implements RobotController {
    private final ForceSensorData forceSensorData;
    private final YoRegistry registry;
    private final FrameVector3D tempFrameVector = new FrameVector3D();
    private final Wrench tempWrench = new Wrench();
    private final ArrayList<ImmutablePair<FrameVector3D, YoDouble>> yoTorqueInJoints;
    private final int numberOfJointFromSensor = 2;

    public ForceSensorToJointTorqueProjector(String namePrefix, ForceSensorData forceSensorData, RigidBodyBasics sensorLinkBody) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.forceSensorData = forceSensorData;
        this.yoTorqueInJoints = new ArrayList();
        RigidBodyBasics currentBody = sensorLinkBody;
        for (int i = 0; i < 2; ++i) {
            FrameVector3D jAxis = new FrameVector3D((FrameTuple3DReadOnly)((OneDoFJointBasics)currentBody.getParentJoint()).getJointAxis());
            this.yoTorqueInJoints.add((ImmutablePair<FrameVector3D, YoDouble>)new ImmutablePair((Object)jAxis, (Object)new YoDouble("NegGRFWrenchIn" + currentBody.getParentJoint().getName(), this.registry)));
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
    }

    public void initialize() {
        this.doControl();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return this.getClass().getName();
    }

    public void doControl() {
        this.forceSensorData.getWrench(this.tempWrench);
        for (int i = 0; i < this.yoTorqueInJoints.size(); ++i) {
            ImmutablePair<FrameVector3D, YoDouble> pair = this.yoTorqueInJoints.get(i);
            FrameVector3D jointAxis = (FrameVector3D)pair.getLeft();
            YoDouble torqueAboutJointAxis = (YoDouble)pair.getRight();
            this.tempWrench.changeFrame(jointAxis.getReferenceFrame());
            this.tempFrameVector.setToZero(this.tempWrench.getReferenceFrame());
            this.tempFrameVector.set((FrameTuple3DReadOnly)this.tempWrench.getAngularPart());
            torqueAboutJointAxis.set(-this.tempFrameVector.dot((FrameVector3DReadOnly)jointAxis));
        }
    }
}

