/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.interfaces.SpatialForceBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;

public class CenterOfPressureResolver {
    private final SpatialForce wrenchResolvedOnPlane = new SpatialForce();
    private final Vector3D torqueAtZeroInPlaneFrame = new Vector3D();
    private final Vector3D forceInPlaneFrame = new Vector3D();

    public double resolveCenterOfPressureAndNormalTorque(FramePoint2DBasics centerOfPressureToPack, SpatialForceReadOnly spatialForceVector, ReferenceFrame centerOfPressurePlaneFrame) {
        centerOfPressureToPack.setReferenceFrame(centerOfPressurePlaneFrame);
        return this.resolveCenterOfPressureAndNormalTorque((FixedFramePoint2DBasics)centerOfPressureToPack, spatialForceVector, centerOfPressurePlaneFrame);
    }

    public double resolveCenterOfPressureAndNormalTorque(FixedFramePoint2DBasics centerOfPressureToPack, SpatialForceReadOnly spatialForceVector, ReferenceFrame centerOfPressurePlaneFrame) {
        double normalTorqueAtCenterOfPressure;
        this.wrenchResolvedOnPlane.setIncludingFrame((SpatialVectorReadOnly)spatialForceVector);
        this.wrenchResolvedOnPlane.changeFrame(centerOfPressurePlaneFrame);
        this.torqueAtZeroInPlaneFrame.set((Tuple3DReadOnly)this.wrenchResolvedOnPlane.getAngularPart());
        this.forceInPlaneFrame.set((Tuple3DReadOnly)this.wrenchResolvedOnPlane.getLinearPart());
        double fz = this.forceInPlaneFrame.getZ();
        double vector12x = Double.NaN;
        double vector12y = Double.NaN;
        if (fz > 1.0E-7) {
            vector12x = -1.0 / fz * this.torqueAtZeroInPlaneFrame.getY();
            vector12y = 1.0 / fz * this.torqueAtZeroInPlaneFrame.getX();
            normalTorqueAtCenterOfPressure = this.torqueAtZeroInPlaneFrame.getZ() - vector12x * this.forceInPlaneFrame.getY() + vector12y * this.forceInPlaneFrame.getX();
        } else {
            normalTorqueAtCenterOfPressure = this.torqueAtZeroInPlaneFrame.getZ();
        }
        centerOfPressureToPack.set(centerOfPressurePlaneFrame, vector12x, vector12y);
        return normalTorqueAtCenterOfPressure;
    }

    public double resolveCenterOfPressureAndNormalTorque(FramePoint3D centerOfPressureToPack, SpatialForceBasics spatialForceVector, ReferenceFrame centerOfPressurePlaneFrame) {
        double normalTorqueAtCenterOfPressure;
        this.wrenchResolvedOnPlane.setIncludingFrame((SpatialVectorReadOnly)spatialForceVector);
        this.wrenchResolvedOnPlane.changeFrame(centerOfPressurePlaneFrame);
        this.torqueAtZeroInPlaneFrame.set((Tuple3DReadOnly)this.wrenchResolvedOnPlane.getAngularPart());
        this.forceInPlaneFrame.set((Tuple3DReadOnly)this.wrenchResolvedOnPlane.getLinearPart());
        double fz = this.forceInPlaneFrame.getZ();
        double vector12x = Double.NaN;
        double vector12y = Double.NaN;
        if (fz > 1.0E-7) {
            vector12x = -1.0 / fz * this.torqueAtZeroInPlaneFrame.getY();
            vector12y = 1.0 / fz * this.torqueAtZeroInPlaneFrame.getX();
            normalTorqueAtCenterOfPressure = this.torqueAtZeroInPlaneFrame.getZ() - vector12x * this.forceInPlaneFrame.getY() + vector12y * this.forceInPlaneFrame.getX();
        } else {
            normalTorqueAtCenterOfPressure = this.torqueAtZeroInPlaneFrame.getZ();
        }
        centerOfPressureToPack.setIncludingFrame(centerOfPressurePlaneFrame, vector12x, vector12y, 0.0);
        return normalTorqueAtCenterOfPressure;
    }
}

