/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ExternalTorqueEstimatorInterface;
import us.ihmc.commonWalkingControlModules.contact.particleFilter.ForceEstimatorDynamicMatrixUpdater;
import us.ihmc.euclid.Axis3D;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ExternalTorqueEstimator
implements ExternalTorqueEstimatorInterface {
    static final double defaultEstimatorGain = 0.7;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoBoolean requestInitialize = new YoBoolean("requestInitialize", this.registry);
    private final YoDouble estimationGain = new YoDouble("estimationGain", this.registry);
    private final double dt;
    private final JointBasics[] joints;
    private final int dofs;
    private final DMatrixRMaj tau;
    private final DMatrixRMaj qd;
    private final DMatrixRMaj currentIntegrandValue;
    private final DMatrixRMaj currentIntegratedValue;
    private final DMatrixRMaj estimatedExternalTorque;
    private final DMatrixRMaj hqd0;
    private final DMatrixRMaj hqd;
    private final DMatrixRMaj massMatrix;
    private final DMatrixRMaj massMatrixPrev;
    private final DMatrixRMaj massMatrixDot;
    private final DMatrixRMaj coriolisGravityTerm;
    private final ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater;
    private final YoDouble[] yoObservedExternalJointTorque;
    private final YoDouble[] yoSimulatedTorqueSensingError;
    private boolean firstTick = true;

    public ExternalTorqueEstimator(JointBasics[] joints, double dt, ForceEstimatorDynamicMatrixUpdater dynamicMatrixUpdater, YoRegistry parentRegistry) {
        this.joints = joints;
        this.dt = dt;
        this.estimationGain.set(0.7);
        this.dynamicMatrixUpdater = dynamicMatrixUpdater;
        this.dofs = Arrays.stream(joints).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        this.currentIntegrandValue = new DMatrixRMaj(this.dofs, 1);
        this.currentIntegratedValue = new DMatrixRMaj(this.dofs, 1);
        this.estimatedExternalTorque = new DMatrixRMaj(this.dofs, 1);
        this.hqd = new DMatrixRMaj(this.dofs, 1);
        this.massMatrix = new DMatrixRMaj(this.dofs, this.dofs);
        this.massMatrixPrev = new DMatrixRMaj(this.dofs, this.dofs);
        this.massMatrixDot = new DMatrixRMaj(this.dofs, this.dofs);
        this.coriolisGravityTerm = new DMatrixRMaj(this.dofs, 1);
        this.tau = new DMatrixRMaj(this.dofs, 1);
        this.qd = new DMatrixRMaj(this.dofs, 1);
        this.hqd0 = new DMatrixRMaj(this.dofs, 1);
        this.yoObservedExternalJointTorque = new YoDouble[this.dofs];
        this.yoSimulatedTorqueSensingError = new YoDouble[this.dofs];
        boolean hasFloatingBase = joints[0] instanceof FloatingJointBasics;
        for (int i = 0; i < this.dofs; ++i) {
            String nameSuffix = i < 6 && hasFloatingBase ? (i < 3 ? "Ang" : "Lin") + Axis3D.values[i % 3] : joints[i + (hasFloatingBase ? -5 : 0)].getName();
            this.yoObservedExternalJointTorque[i] = new YoDouble("estimatedExternalTau_" + nameSuffix, this.registry);
            this.yoSimulatedTorqueSensingError[i] = new YoDouble("simulatedTauSensorError_" + nameSuffix, this.registry);
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public void initialize() {
        this.firstTick = true;
        CommonOps_DDRM.fill((DMatrixD1)this.estimatedExternalTorque, (double)0.0);
        CommonOps_DDRM.fill((DMatrixD1)this.currentIntegratedValue, (double)0.0);
    }

    public void doControl() {
        if (this.requestInitialize.getValue()) {
            this.initialize();
            this.requestInitialize.set(false);
        }
        try {
            this.computeForceEstimate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeForceEstimate() {
        int i;
        this.massMatrixPrev.set((DMatrixD1)this.massMatrix);
        this.dynamicMatrixUpdater.update(this.massMatrix, this.coriolisGravityTerm, this.tau);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])this.joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)this.qd);
        if (this.firstTick) {
            CommonOps_DDRM.mult((DMatrix1Row)this.massMatrix, (DMatrix1Row)this.qd, (DMatrix1Row)this.hqd0);
            this.firstTick = false;
        } else {
            CommonOps_DDRM.subtract((DMatrixD1)this.massMatrix, (DMatrixD1)this.massMatrixPrev, (DMatrixD1)this.massMatrixDot);
            CommonOps_DDRM.scale((double)(1.0 / this.dt), (DMatrixD1)this.massMatrixDot);
        }
        for (i = 0; i < this.dofs; ++i) {
            this.tau.set(i, 0, this.tau.get(i, 0) - this.yoSimulatedTorqueSensingError[i].getValue());
        }
        this.currentIntegrandValue.set((DMatrixD1)this.tau);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.currentIntegrandValue, (DMatrixD1)this.coriolisGravityTerm);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.massMatrixDot, (DMatrix1Row)this.qd, (DMatrix1Row)this.currentIntegrandValue);
        CommonOps_DDRM.addEquals((DMatrixD1)this.currentIntegrandValue, (DMatrixD1)this.estimatedExternalTorque);
        CommonOps_DDRM.addEquals((DMatrixD1)this.currentIntegratedValue, (double)this.dt, (DMatrixD1)this.currentIntegrandValue);
        CommonOps_DDRM.mult((DMatrix1Row)this.massMatrix, (DMatrix1Row)this.qd, (DMatrix1Row)this.hqd);
        CommonOps_DDRM.subtract((DMatrixD1)this.hqd, (DMatrixD1)this.hqd0, (DMatrixD1)this.estimatedExternalTorque);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.estimatedExternalTorque, (DMatrixD1)this.currentIntegratedValue);
        CommonOps_DDRM.scale((double)this.estimationGain.getDoubleValue(), (DMatrixD1)this.estimatedExternalTorque);
        for (i = 0; i < this.dofs; ++i) {
            this.yoObservedExternalJointTorque[i].set(this.estimatedExternalTorque.get(i, 0));
        }
    }

    @Override
    public DMatrixRMaj getEstimatedExternalTorque() {
        return this.estimatedExternalTorque;
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    @Override
    public void requestInitialize() {
        this.requestInitialize.set(true);
    }

    @Override
    public void setEstimatorGain(double estimatorGain) {
        this.estimationGain.set(estimatorGain);
    }
}

