/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact.particleFilter;

import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class ExternalForceEstimationTools {
    public static int[] createIndexMap(GeometricJacobian jacobian, JointBasics[] joints) {
        int[] indexMap = new int[jacobian.getJacobianMatrix().getNumCols()];
        JointBasics[] jointPath = jacobian.getJointsInOrder();
        ToIntFunction<JointBasics> jointIndexFunction = joint -> IntStream.range(0, joints.length).filter(i -> joint == joints[i]).findFirst().orElseThrow(() -> new RuntimeException("Could not find joint"));
        IntUnaryOperator indexOffset = i -> IntStream.range(0, i).map(j -> joints[j].getDegreesOfFreedom()).sum();
        int mappedIndex = 0;
        for (int jointIndex = 0; jointIndex < jointPath.length; ++jointIndex) {
            JointBasics joint2 = jointPath[jointIndex];
            int offset = indexOffset.applyAsInt(jointIndexFunction.applyAsInt(joint2));
            for (int i2 = 0; i2 < joint2.getDegreesOfFreedom(); ++i2) {
                indexMap[mappedIndex++] = offset + i2;
            }
        }
        return indexMap;
    }

    public static void transformToSphericalCoordinates(Tuple3DReadOnly cartesianCoordinates, Tuple3DBasics sphericalCoordinates) {
        double r = EuclidCoreTools.norm((double)cartesianCoordinates.getX(), (double)cartesianCoordinates.getY(), (double)cartesianCoordinates.getZ());
        double theta = Math.atan2(cartesianCoordinates.getY(), cartesianCoordinates.getX());
        double phi = Math.acos(cartesianCoordinates.getZ() / r);
        sphericalCoordinates.set(r, theta, phi);
    }

    public static void transformToCartesianCoordinates(Tuple3DReadOnly sphericalCoordinates, Tuple3DBasics cartesianCoordinates) {
        double r = sphericalCoordinates.getX();
        double theta = sphericalCoordinates.getY();
        double phi = sphericalCoordinates.getZ();
        double x = r * Math.cos(theta) * Math.sin(phi);
        double y = r * Math.sin(theta) * Math.sin(phi);
        double z = r * Math.cos(phi);
        cartesianCoordinates.set(x, y, z);
    }
}

