/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.contact;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Comparator;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.tools.lists.ArraySorter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoLowestNPointsPlaneContactState
extends YoPlaneContactState {
    private final YoDouble numberOfContactsToActivate;
    private final YoContactPoint[] sortedContactPoints;
    private final ContactPointComparator contactPointComparator = new ContactPointComparator();
    private final TObjectIntHashMap<YoContactPoint> contactPointIndexLookup = new TObjectIntHashMap();

    public YoLowestNPointsPlaneContactState(String namePrefix, RigidBodyBasics rigidBody, ReferenceFrame planeFrame, List<FramePoint2D> contactFramePoints, double numberOfContactsToActivate, double coefficientOfFriction, YoRegistry parentRegistry) {
        super(namePrefix, rigidBody, planeFrame, contactFramePoints, coefficientOfFriction, parentRegistry);
        this.numberOfContactsToActivate = new YoDouble("numberOfContactsToActivate", this.registry);
        this.numberOfContactsToActivate.set(numberOfContactsToActivate);
        this.sortedContactPoints = new YoContactPoint[contactFramePoints.size()];
        List<YoContactPoint> contactPoints = this.getContactPoints();
        for (int i = 0; i < contactPoints.size(); ++i) {
            YoContactPoint yoContactPoint;
            this.sortedContactPoints[i] = yoContactPoint = contactPoints.get(i);
            this.contactPointIndexLookup.put((Object)yoContactPoint, i);
        }
        this.sortContactPointsByZHeightInWorld();
    }

    @Override
    public void setFullyConstrained() {
        super.clear();
        this.sortContactPointsByZHeightInWorld();
        int i = 0;
        while ((double)i < this.numberOfContactsToActivate.getDoubleValue()) {
            YoContactPoint yoContactPoint = this.sortedContactPoints[i];
            this.setContactPointInContact(this.contactPointIndexLookup.get((Object)yoContactPoint), true);
            ++i;
        }
        this.updateInContact();
    }

    private void sortContactPointsByZHeightInWorld() {
        ArraySorter.sort((Object[])this.sortedContactPoints, (Comparator)this.contactPointComparator);
    }

    private class ContactPointComparator
    implements Comparator<YoContactPoint> {
        private final FramePoint3D p1 = new FramePoint3D();
        private final FramePoint3D p2 = new FramePoint3D();

        private ContactPointComparator() {
        }

        @Override
        public int compare(YoContactPoint cp1, YoContactPoint cp2) {
            this.p1.setIncludingFrame((FrameTuple3DReadOnly)cp1);
            this.p2.setIncludingFrame((FrameTuple3DReadOnly)cp2);
            this.p1.changeFrame(ReferenceFrame.getWorldFrame());
            this.p2.changeFrame(ReferenceFrame.getWorldFrame());
            if (this.p1.getZ() < this.p2.getZ()) {
                return -1;
            }
            if (this.p1.getZ() > this.p2.getZ()) {
                return 1;
            }
            return 0;
        }
    }
}

