/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.configurations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GroupParameter<T> {
    private final T parameter;
    private final String groupName;
    private final List<String> memberNames;

    public GroupParameter(String groupAndMemberName) {
        this(groupAndMemberName, groupAndMemberName);
    }

    public GroupParameter(String groupName, String memberName) {
        this(groupName, Collections.singletonList(memberName));
    }

    public GroupParameter(String groupName, String ... memberNames) {
        this(groupName, Arrays.asList(memberNames));
    }

    public GroupParameter(String groupName, List<String> memberNames) {
        this(groupName, null, memberNames);
    }

    public GroupParameter(String groupAndMemberName, T parameter) {
        this(groupAndMemberName, parameter, groupAndMemberName);
    }

    public GroupParameter(String groupName, T parameter, String memberName) {
        this(groupName, parameter, Collections.singletonList(memberName));
    }

    public GroupParameter(String groupName, T parameter, String ... memberNames) {
        this(groupName, parameter, Arrays.asList(memberNames));
    }

    public GroupParameter(String groupName, T parameter, List<String> memberNames) {
        this.groupName = groupName;
        this.parameter = parameter;
        this.memberNames = memberNames;
    }

    public boolean hasParameter() {
        return this.parameter != null;
    }

    public T getParameter() {
        return this.parameter;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getMemberNames() {
        return this.memberNames;
    }
}

