/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.configurations;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public interface AnkleIKSolver {
    public void computeAngles(QuaternionReadOnly var1, DMatrixRMaj var2);

    public void computeVelocities(Vector3DReadOnly var1, DMatrixRMaj var2, DMatrixRMaj var3);

    public int getNumberOfJoints();

    public static class PitchRollAnkleWithSolePlaneConstraintSolver
    implements AnkleIKSolver {
        private final RotationMatrix rotationMatrix = new RotationMatrix();

        @Override
        public void computeAngles(QuaternionReadOnly footOrientation, DMatrixRMaj result) {
            this.rotationMatrix.set((Orientation3DReadOnly)footOrientation);
            double q0 = Math.atan2(this.rotationMatrix.getM02(), this.rotationMatrix.getM22());
            double q1 = Math.asin(-this.rotationMatrix.getM12());
            result.reshape(this.getNumberOfJoints(), 1);
            result.set(0, q0);
            result.set(1, q1);
        }

        @Override
        public void computeVelocities(Vector3DReadOnly footVelocity, DMatrixRMaj jointAngles, DMatrixRMaj result) {
            double qd0 = footVelocity.getY();
            double q0 = jointAngles.get(0);
            double qd1 = footVelocity.getX() * Math.cos(q0) - footVelocity.getZ() * Math.sin(q0);
            result.reshape(this.getNumberOfJoints(), 1);
            result.set(0, qd0);
            result.set(1, qd1);
        }

        @Override
        public int getNumberOfJoints() {
            return 2;
        }
    }
}

