/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.humanoidRobotics.footstep.FootstepUtils;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ReachableFootholdsCalculator {
    private static final int numberOfVertices = 5;
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private final PoseReferenceFrame rotatedSoleFrame = new PoseReferenceFrame("rotatedSoleFrame", ReferenceFrame.getWorldFrame());
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble lengthLimit;
    private final YoDouble lengthBackLimit;
    private final YoDouble innerLimit;
    private final YoDouble outerLimit;

    public ReachableFootholdsCalculator(double maxStepLength, double maxBackwardStepLength, double minStepWidth, double maxStepWidth, SideDependentList<? extends ReferenceFrame> soleZUpFrames, YoRegistry parentRegistry) {
        this.soleZUpFrames = soleZUpFrames;
        this.lengthLimit = new YoDouble("MaxReachabilityLength", this.registry);
        this.lengthBackLimit = new YoDouble("MaxReachabilityBackwardLength", this.registry);
        this.innerLimit = new YoDouble("MinReachabilityWidth", this.registry);
        this.outerLimit = new YoDouble("MaxReachabilityWidth", this.registry);
        this.lengthLimit.set(maxStepLength);
        this.lengthBackLimit.set(maxBackwardStepLength);
        this.innerLimit.set(minStepWidth);
        this.outerLimit.set(maxStepWidth);
        parentRegistry.addChild(this.registry);
    }

    public void calculateReachableRegion(RobotSide swingSide, FramePoint3DReadOnly stancePosition, FrameQuaternionReadOnly stanceOrientation, FrameConvexPolygon2DBasics reachableRegionToPack) {
        this.rotatedSoleFrame.setPoseAndUpdate(stancePosition, (FrameOrientation3DReadOnly)stanceOrientation);
        this.calculateReachableRegion(swingSide, reachableRegionToPack);
    }

    private void calculateReachableRegion(RobotSide swingSide, FrameConvexPolygon2DBasics reachableRegionToPack) {
        double sign = swingSide.negateIfRightSide(1.0);
        reachableRegionToPack.clear((ReferenceFrame)this.rotatedSoleFrame);
        double xRadius = 0.5 * (this.lengthLimit.getValue() + this.lengthBackLimit.getValue());
        double yRadius = this.outerLimit.getValue() - this.innerLimit.getValue();
        double centerX = this.lengthLimit.getValue() - xRadius;
        double centerY = this.innerLimit.getValue();
        for (int vertexIdx = 0; vertexIdx < 5; ++vertexIdx) {
            double angle = Math.PI * (double)vertexIdx / 4.0;
            double x = centerX + xRadius * Math.cos(angle);
            double y = centerY + yRadius * Math.sin(angle);
            reachableRegionToPack.addVertex(x, sign * y);
        }
        reachableRegionToPack.update();
        reachableRegionToPack.changeFrameAndProjectToXYPlane(FootstepUtils.worldFrame);
    }
}

