/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.captureRegion.FootstepAdjustor;
import us.ihmc.commonWalkingControlModules.captureRegion.OneStepCaptureRegionCalculator;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class PushRecoveryControlModule {
    private static final boolean ENABLE = false;
    private static final double MINIMUM_TIME_TO_REPLAN = 0.1;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final YoBoolean enablePushRecovery;
    private final YoBoolean recovering;
    private final YoBoolean recoveringFromDoubleSupportFall;
    private final YoBoolean footstepWasProjectedInCaptureRegion;
    private final SideDependentList<YoDouble> distanceICPToFeet = new SideDependentList();
    private final YoBoolean isICPOutside;
    private final YoBoolean isICPErrorTooLarge;
    private final YoDouble icpErrorThreshold;
    private final YoEnum<RobotSide> closestFootToICP;
    private final YoEnum<RobotSide> swingSideForDoubleSupportRecovery;
    private final GlitchFilteredYoBoolean isRobotBackToSafeState;
    private final YoBoolean isCaptureRegionEmpty;
    private final FootstepAdjustor footstepAdjustor;
    private final OneStepCaptureRegionCalculator captureRegionCalculator;
    private final BipedSupportPolygons bipedSupportPolygon;
    private final SideDependentList<? extends ContactablePlaneBody> feet;
    private final ReferenceFrame midFeetZUp;
    private final SideDependentList<MovingReferenceFrame> soleFrames;
    private final FrameConvexPolygon2D footPolygon = new FrameConvexPolygon2D();
    private final double controlDT;
    private double omega0;
    private final FramePoint2D desiredCapturePoint2d = new FramePoint2D();
    private final FramePoint2D capturePoint2d = new FramePoint2D();
    private final FramePoint3D projectedCapturePoint = new FramePoint3D();
    private final FramePoint2D projectedCapturePoint2d = new FramePoint2D();

    public PushRecoveryControlModule(BipedSupportPolygons bipedSupportPolygons, HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        this.controlDT = controllerToolbox.getControlDT();
        this.bipedSupportPolygon = bipedSupportPolygons;
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        this.feet = controllerToolbox.getContactableFeet();
        this.midFeetZUp = referenceFrames.getMidFeetZUpFrame();
        this.soleFrames = referenceFrames.getSoleFrames();
        this.enablePushRecovery = new YoBoolean("enablePushRecovery", this.registry);
        this.enablePushRecovery.set(false);
        this.yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        this.captureRegionCalculator = new OneStepCaptureRegionCalculator(referenceFrames, walkingControllerParameters, this.registry, this.yoGraphicsListRegistry);
        this.footstepAdjustor = new FootstepAdjustor(this.feet, this.registry, this.yoGraphicsListRegistry);
        this.footstepWasProjectedInCaptureRegion = new YoBoolean("footstepWasProjectedInCaptureRegion", this.registry);
        this.recovering = new YoBoolean("recovering", this.registry);
        this.recoveringFromDoubleSupportFall = new YoBoolean("recoveringFromDoubleSupportFall", this.registry);
        this.isICPOutside = new YoBoolean("isICPOutside", this.registry);
        this.isICPErrorTooLarge = new YoBoolean("isICPErrorTooLarge", this.registry);
        this.icpErrorThreshold = new YoDouble("icpErrorThreshold", this.registry);
        this.icpErrorThreshold.set(0.05);
        this.closestFootToICP = new YoEnum("ClosestFootToICP", this.registry, RobotSide.class, true);
        this.swingSideForDoubleSupportRecovery = new YoEnum("swingSideForDoubleSupportRecovery", this.registry, RobotSide.class, true);
        this.swingSideForDoubleSupportRecovery.set(null);
        this.isRobotBackToSafeState = new GlitchFilteredYoBoolean("isRobotBackToSafeState", this.registry, 100);
        this.isCaptureRegionEmpty = new YoBoolean("isCaptureRegionEmpty", this.registry);
        for (RobotSide robotSide : RobotSide.values) {
            String side = robotSide.getCamelCaseNameForMiddleOfExpression();
            YoDouble distanceICPToFoot = new YoDouble("DistanceICPTo" + side + "Foot", this.registry);
            this.distanceICPToFeet.put((Enum)robotSide, (Object)distanceICPToFoot);
        }
        this.footPolygon.setIncludingFrame(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)((ContactablePlaneBody)this.feet.get((Enum)RobotSide.LEFT)).getContactPoints2d()));
        parentRegistry.addChild(this.registry);
        this.reset();
    }

    public FrameConvexPolygon2D getCaptureRegion() {
        return this.captureRegionCalculator.getCaptureRegion();
    }

    public RobotSide isRobotFallingFromDoubleSupport() {
        return (RobotSide)this.swingSideForDoubleSupportRecovery.getEnumValue();
    }

    public void initializeParametersForDoubleSupportPushRecovery() {
        this.recoveringFromDoubleSupportFall.set(true);
    }

    public void updateForDoubleSupport(FramePoint2DReadOnly desiredCapturePoint2d, FramePoint2DReadOnly capturePoint2d, double omega0) {
        if (!this.isEnabled()) {
            return;
        }
        this.omega0 = omega0;
        this.capturePoint2d.setIncludingFrame((FrameTuple2DReadOnly)capturePoint2d);
        this.desiredCapturePoint2d.setIncludingFrame((FrameTuple2DReadOnly)desiredCapturePoint2d);
        FrameConvexPolygon2DReadOnly supportPolygonInMidFeetZUp = this.bipedSupportPolygon.getSupportPolygonInMidFeetZUp();
        this.closestFootToICP.set(null);
        this.swingSideForDoubleSupportRecovery.set(null);
        for (RobotSide robotSide : RobotSide.values) {
            ((YoDouble)this.distanceICPToFeet.get((Enum)robotSide)).set(Double.NaN);
        }
        this.capturePoint2d.changeFrame(this.midFeetZUp);
        this.desiredCapturePoint2d.changeFrame(this.midFeetZUp);
        this.isICPErrorTooLarge.set(this.desiredCapturePoint2d.distance((FramePoint2DReadOnly)this.capturePoint2d) > this.icpErrorThreshold.getDoubleValue());
        this.isICPOutside.set(!supportPolygonInMidFeetZUp.isPointInside((FramePoint2DReadOnly)this.capturePoint2d));
        if (!this.isICPOutside.getBooleanValue() || !this.isICPErrorTooLarge.getBooleanValue()) {
            this.isRobotBackToSafeState.update(true);
            return;
        }
        this.projectedCapturePoint.setIncludingFrame((FrameTuple2DReadOnly)this.capturePoint2d, 0.0);
        for (RobotSide robotSide : RobotSide.values) {
            ReferenceFrame soleFrame = (ReferenceFrame)this.soleFrames.get((Enum)robotSide);
            this.projectedCapturePoint.changeFrame(soleFrame);
            this.footPolygon.setIncludingFrame((FrameVertex2DSupplier)this.bipedSupportPolygon.getFootPolygonInSoleFrame(robotSide));
            this.projectedCapturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.projectedCapturePoint);
            ((YoDouble)this.distanceICPToFeet.get((Enum)robotSide)).set(this.projectedCapturePoint2d.distance(this.footPolygon.getCentroid()));
            this.isRobotBackToSafeState.set(false);
        }
        boolean isLeftFootCloser = ((YoDouble)this.distanceICPToFeet.get((Enum)RobotSide.LEFT)).getDoubleValue() <= ((YoDouble)this.distanceICPToFeet.get((Enum)RobotSide.RIGHT)).getDoubleValue();
        this.closestFootToICP.set((Enum)(isLeftFootCloser ? RobotSide.LEFT : RobotSide.RIGHT));
        this.swingSideForDoubleSupportRecovery.set((Enum)((RobotSide)this.closestFootToICP.getEnumValue()).getOppositeSide());
    }

    public void updateForSingleSupport(FramePoint2DReadOnly desiredCapturePoint2d, FramePoint2DReadOnly capturePoint2d, double omega0) {
        if (!this.isEnabled()) {
            return;
        }
        this.omega0 = omega0;
        this.capturePoint2d.setIncludingFrame((FrameTuple2DReadOnly)capturePoint2d);
        this.desiredCapturePoint2d.setIncludingFrame((FrameTuple2DReadOnly)desiredCapturePoint2d);
        this.isICPErrorTooLarge.set(this.desiredCapturePoint2d.distance((FramePoint2DReadOnly)this.capturePoint2d) > this.icpErrorThreshold.getDoubleValue());
    }

    public double computePreferredSwingTimeForRecovering(double swingTimeRemaining, RobotSide swingSide) {
        double preferredSwingTime;
        RobotSide supportSide = swingSide.getOppositeSide();
        this.footPolygon.setIncludingFrame((FrameVertex2DSupplier)this.bipedSupportPolygon.getFootPolygonInSoleZUpFrame(supportSide));
        this.captureRegionCalculator.calculateCaptureRegion(swingSide, preferredSwingTime, (FramePoint2DReadOnly)this.capturePoint2d, this.omega0, (FrameConvexPolygon2DReadOnly)this.footPolygon);
        double captureRegionArea = this.captureRegionCalculator.getCaptureRegionArea();
        if (swingTimeRemaining <= this.controlDT) {
            return swingTimeRemaining;
        }
        for (preferredSwingTime = swingTimeRemaining; preferredSwingTime >= 0.0; preferredSwingTime -= swingTimeRemaining / 10.0) {
            this.captureRegionCalculator.calculateCaptureRegion(swingSide, preferredSwingTime, (FramePoint2DReadOnly)this.capturePoint2d, this.omega0, (FrameConvexPolygon2DReadOnly)this.footPolygon);
            captureRegionArea = this.captureRegionCalculator.getCaptureRegionArea();
            if (!Double.isNaN(captureRegionArea)) break;
        }
        return preferredSwingTime;
    }

    public boolean checkAndUpdateFootstep(double swingTimeRemaining, Footstep nextFootstep) {
        if (Double.isNaN(swingTimeRemaining)) {
            swingTimeRemaining = 1.0;
        }
        RobotSide swingSide = nextFootstep.getRobotSide();
        RobotSide supportSide = swingSide.getOppositeSide();
        this.footPolygon.setIncludingFrame((FrameVertex2DSupplier)this.bipedSupportPolygon.getFootPolygonInSoleZUpFrame(supportSide));
        double preferredSwingTimeForRecovering = this.computePreferredSwingTimeForRecovering(swingTimeRemaining, swingSide);
        this.captureRegionCalculator.calculateCaptureRegion(swingSide, preferredSwingTimeForRecovering, (FramePoint2DReadOnly)this.capturePoint2d, this.omega0, (FrameConvexPolygon2DReadOnly)this.footPolygon);
        if (!this.isICPErrorTooLarge.getBooleanValue()) {
            this.isRobotBackToSafeState.update(true);
            return false;
        }
        if (swingTimeRemaining < 0.1) {
            return false;
        }
        FramePoint2DReadOnly footCentroid = this.footPolygon.getCentroid();
        FrameConvexPolygon2D captureRegion = this.captureRegionCalculator.getCaptureRegion();
        this.isCaptureRegionEmpty.set(captureRegion.isEmpty());
        if (!this.recovering.getBooleanValue()) {
            boolean hasFootstepBeenAdjusted = this.footstepAdjustor.adjustFootstep(nextFootstep, footCentroid, (FrameConvexPolygon2DReadOnly)captureRegion);
            this.footstepWasProjectedInCaptureRegion.set(hasFootstepBeenAdjusted);
        } else {
            this.footstepWasProjectedInCaptureRegion.set(false);
        }
        if (this.footstepWasProjectedInCaptureRegion.getBooleanValue()) {
            this.isRobotBackToSafeState.set(false);
            this.recovering.set(true);
        }
        return this.footstepWasProjectedInCaptureRegion.getBooleanValue();
    }

    public void packFootstepForRecoveringFromDisturbance(RobotSide swingSide, double swingTimeRemaining, Footstep footstepToPack) {
        footstepToPack.clear();
        if (!this.enablePushRecovery.getBooleanValue()) {
            return;
        }
        this.packFootstepAtCurrentLocation(swingSide, footstepToPack);
        this.checkAndUpdateFootstep(swingTimeRemaining, footstepToPack);
    }

    public void reset() {
        this.footstepWasProjectedInCaptureRegion.set(false);
        this.recovering.set(false);
        this.captureRegionCalculator.hideCaptureRegion();
        this.recoveringFromDoubleSupportFall.set(false);
    }

    private void packFootstepAtCurrentLocation(RobotSide robotSide, Footstep footstepToPack) {
        footstepToPack.setRobotSide(robotSide);
        footstepToPack.setTrustHeight(true);
        footstepToPack.setIsAdjustable(false);
        footstepToPack.getFootstepPose().setToZero((ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        footstepToPack.getFootstepPose().changeFrame(worldFrame);
    }

    public boolean isEnabled() {
        return this.enablePushRecovery.getBooleanValue();
    }

    public void setIsEnabled(boolean enable) {
        this.enablePushRecovery.set(enable);
    }

    public boolean isRecoveringFromDoubleSupportFall() {
        return this.recoveringFromDoubleSupportFall.getBooleanValue();
    }

    public boolean isRecovering() {
        return this.isEnabled() && this.recovering.getBooleanValue();
    }

    public boolean isRobotBackToSafeState() {
        return this.isRobotBackToSafeState.getBooleanValue();
    }

    public boolean isCaptureRegionEmpty() {
        return this.isCaptureRegionEmpty.getBooleanValue();
    }
}

