/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.captureRegion.CaptureRegionMathTools;
import us.ihmc.commonWalkingControlModules.captureRegion.CaptureRegionVisualizer;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OneStepCaptureRegionCalculatorWithDelay {
    private final CaptureRegionMathTools captureRegionMath = new CaptureRegionMathTools();
    private static final boolean VISUALIZE = true;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int MAX_CAPTURE_REGION_POLYGON_POINTS = 20;
    private static final int KINEMATIC_LIMIT_POINTS = 8;
    private double reachableRegionCutoffAngle = 1.0;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final ExecutionTimer globalTimer = new ExecutionTimer(this.name + "Timer", this.registry);
    private CaptureRegionVisualizer captureRegionVisualizer = null;
    private final FrameConvexPolygon2D captureRegionPolygon = new FrameConvexPolygon2D(worldFrame);
    private final double footWidth;
    private final double kinematicStepRange;
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private final SideDependentList<FrameConvexPolygon2D> reachableRegions = new SideDependentList((Object)new FrameConvexPolygon2D(), (Object)new FrameConvexPolygon2D());
    private final RecyclingArrayList<FramePoint2D> visibleVertices = new RecyclingArrayList(20, FramePoint2D.class);
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private static final int APPROXIMATION_MULTILIER = 100;
    private final FrameConvexPolygon2D supportFootPolygon = new FrameConvexPolygon2D();
    private final FramePoint2D footCentroid = new FramePoint2D(worldFrame);
    private final FramePoint2D predictedICPAtTouchdown = new FramePoint2D(worldFrame);
    private final FramePoint2D predictedICPAfterTransfer = new FramePoint2D(worldFrame);
    private final FramePoint2D capturePoint = new FramePoint2D(worldFrame);
    private final FramePoint2D kinematicExtreme = new FramePoint2D(worldFrame);
    private final FramePoint2D additionalKinematicPoint = new FramePoint2D(worldFrame);
    private final FrameVector2D firstKinematicExtremeDirection = new FrameVector2D(worldFrame);
    private final FrameVector2D lastKinematicExtremeDirection = new FrameVector2D(worldFrame);
    private final FrameConvexPolygon2D unconstrainedCaptureRegion = new FrameConvexPolygon2D(worldFrame);

    public OneStepCaptureRegionCalculatorWithDelay(CommonHumanoidReferenceFrames referenceFrames, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters.getSteppingParameters().getFootWidth(), walkingControllerParameters.getSteppingParameters().getMaxStepLength(), (SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleZUpFrames(), "", parentRegistry, yoGraphicsListRegistry);
    }

    public OneStepCaptureRegionCalculatorWithDelay(CommonHumanoidReferenceFrames referenceFrames, WalkingControllerParameters walkingControllerParameters, String suffix, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters.getSteppingParameters().getFootWidth(), walkingControllerParameters.getSteppingParameters().getMaxStepLength(), (SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleZUpFrames(), suffix, parentRegistry, yoGraphicsListRegistry);
    }

    public OneStepCaptureRegionCalculatorWithDelay(SideDependentList<? extends ReferenceFrame> soleZUpFrames, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters.getSteppingParameters().getFootWidth(), walkingControllerParameters.getSteppingParameters().getMaxStepLength(), soleZUpFrames, "", parentRegistry, yoGraphicsListRegistry);
    }

    public OneStepCaptureRegionCalculatorWithDelay(SideDependentList<? extends ReferenceFrame> soleZUpFrames, WalkingControllerParameters walkingControllerParameters, String suffix, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters.getSteppingParameters().getFootWidth(), walkingControllerParameters.getSteppingParameters().getMaxStepLength(), soleZUpFrames, suffix, parentRegistry, yoGraphicsListRegistry);
    }

    public OneStepCaptureRegionCalculatorWithDelay(double footWidth, double kinematicStepRange, SideDependentList<? extends ReferenceFrame> soleZUpFrames, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(footWidth, kinematicStepRange, soleZUpFrames, "", parentRegistry, yoGraphicsListRegistry);
    }

    public OneStepCaptureRegionCalculatorWithDelay(double footWidth, double kinematicStepRange, SideDependentList<? extends ReferenceFrame> soleZUpFrames, String suffix, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.kinematicStepRange = kinematicStepRange;
        this.soleZUpFrames = soleZUpFrames;
        this.footWidth = footWidth;
        this.calculateReachableRegions(footWidth);
        parentRegistry.addChild(this.registry);
    }

    private void calculateReachableRegions(double footWidth) {
        for (RobotSide side : RobotSide.values) {
            FrameConvexPolygon2D reachableRegion = (FrameConvexPolygon2D)this.reachableRegions.get((Enum)side);
            reachableRegion.clear((ReferenceFrame)this.soleZUpFrames.get((Enum)side));
            double sign = side.negateIfLeftSide(1.0);
            for (int i = 0; i < 19; ++i) {
                double angle = sign * this.reachableRegionCutoffAngle * Math.PI * (double)i / 18.0;
                double x = this.kinematicStepRange * Math.cos(angle);
                double y = this.kinematicStepRange * Math.sin(angle);
                if (Math.abs(y) < footWidth / 2.0) {
                    y = sign * footWidth / 2.0;
                }
                reachableRegion.addVertex((ReferenceFrame)this.soleZUpFrames.get((Enum)side), x, y);
            }
            reachableRegion.addVertex((ReferenceFrame)this.soleZUpFrames.get((Enum)side), 0.0, sign * footWidth / 2.0);
            reachableRegion.update();
        }
    }

    public void calculateCaptureRegion(RobotSide swingSide, double swingTimeRemaining, double nextTransferDuration, FramePoint2DReadOnly currentICP, double omega0, FrameConvexPolygon2DReadOnly footPolygon) {
        int i;
        this.globalTimer.startMeasurement();
        ReferenceFrame supportSoleZUp = (ReferenceFrame)this.soleZUpFrames.get((Enum)swingSide.getOppositeSide());
        this.supportFootPolygon.setIncludingFrame((FrameVertex2DSupplier)footPolygon);
        this.supportFootPolygon.changeFrameAndProjectToXYPlane(supportSoleZUp);
        this.capturePoint.setIncludingFrame((FrameTuple2DReadOnly)currentICP);
        this.capturePoint.changeFrame(supportSoleZUp);
        this.footCentroid.setIncludingFrame((FrameTuple2DReadOnly)this.supportFootPolygon.getCentroid());
        this.firstKinematicExtremeDirection.setToZero(supportSoleZUp);
        this.lastKinematicExtremeDirection.setToZero(supportSoleZUp);
        this.predictedICPAtTouchdown.setToZero(supportSoleZUp);
        swingTimeRemaining = MathTools.clamp((double)swingTimeRemaining, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.unconstrainedCaptureRegion.clear(supportSoleZUp);
        this.captureRegionPolygon.clear(supportSoleZUp);
        boolean icpOutsideSupport = this.computeVisibleVerticesFromOutsideLeftToRightCopy((FrameConvexPolygon2DReadOnly)this.supportFootPolygon, (FramePoint2DReadOnly)this.capturePoint);
        FrameConvexPolygon2D reachableRegion = (FrameConvexPolygon2D)this.reachableRegions.get((Enum)swingSide.getOppositeSide());
        if (!icpOutsideSupport) {
            this.globalTimer.stopMeasurement();
            this.captureRegionPolygon.setIncludingFrame((FrameVertex2DSupplier)reachableRegion);
            this.updateVisualizer();
            return;
        }
        int lastVertexIndex = this.visibleVertices.size() - 1;
        for (i = 0; i < this.visibleVertices.size(); ++i) {
            FramePoint2D copExtreme = (FramePoint2D)this.visibleVertices.get(i);
            copExtreme.changeFrame(supportSoleZUp);
            CapturePointTools.computeDesiredCapturePointPosition(omega0, swingTimeRemaining, (FramePoint2DReadOnly)this.capturePoint, (FramePoint2DReadOnly)copExtreme, (FixedFramePoint2DBasics)this.predictedICPAtTouchdown);
            this.unconstrainedCaptureRegion.addVertexMatchingFrame((FramePoint2DReadOnly)this.predictedICPAtTouchdown, false);
            int intersections = EuclidCoreMissingTools.intersectionBetweenRay2DAndCircle((double)this.kinematicStepRange, (Point2DReadOnly)this.footCentroid, (Point2DReadOnly)copExtreme, (Point2DReadOnly)this.predictedICPAtTouchdown, (Point2DBasics)this.kinematicExtreme, null);
            if (intersections > 1) {
                throw new RuntimeException("The cop was outside of the reachable range.");
            }
            if (this.kinematicExtreme.containsNaN()) {
                this.globalTimer.stopMeasurement();
                this.captureRegionPolygon.update();
                return;
            }
            this.unconstrainedCaptureRegion.addVertexMatchingFrame((FramePoint2DReadOnly)this.kinematicExtreme, false);
            if (i == 0) {
                this.firstKinematicExtremeDirection.sub((FrameTuple2DReadOnly)this.kinematicExtreme, (FrameTuple2DReadOnly)this.footCentroid);
                continue;
            }
            if (i != lastVertexIndex) continue;
            this.lastKinematicExtremeDirection.sub((FrameTuple2DReadOnly)this.kinematicExtreme, (FrameTuple2DReadOnly)this.footCentroid);
        }
        for (i = 0; i < 7; ++i) {
            double alphaFromAToB = (double)(i + 1) / 9.0;
            this.captureRegionMath.getPointBetweenVectorsAtDistanceFromOriginCircular((FrameVector2DReadOnly)this.firstKinematicExtremeDirection, (FrameVector2DReadOnly)this.lastKinematicExtremeDirection, alphaFromAToB, 100.0 * this.kinematicStepRange, (FramePoint2DReadOnly)this.footCentroid, (FramePoint2DBasics)this.additionalKinematicPoint);
            this.unconstrainedCaptureRegion.addVertexMatchingFrame((FramePoint2DReadOnly)this.additionalKinematicPoint, false);
        }
        if (!this.unconstrainedCaptureRegion.isEmpty()) {
            this.unconstrainedCaptureRegion.update();
            this.unconstrainedCaptureRegion.checkReferenceFrameMatch((ReferenceFrameHolder)reachableRegion);
            this.captureRegionPolygon.clear(this.unconstrainedCaptureRegion.getReferenceFrame());
            this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.unconstrainedCaptureRegion, (ConvexPolygon2DReadOnly)reachableRegion, (ConvexPolygon2DBasics)this.captureRegionPolygon);
        }
        this.captureRegionPolygon.update();
        this.globalTimer.stopMeasurement();
        this.updateVisualizer();
    }

    private void updateVisualizer() {
        if (this.captureRegionVisualizer != null && this.captureRegionPolygon != null) {
            this.captureRegionVisualizer.update();
        } else {
            this.hideCaptureRegion();
        }
    }

    public void hideCaptureRegion() {
        if (this.captureRegionVisualizer != null) {
            this.captureRegionVisualizer.hide();
        }
    }

    public FrameConvexPolygon2D getCaptureRegion() {
        return this.captureRegionPolygon;
    }

    public void setReachableRegionCutoffAngle(double reachableRegionCutoffAngle) {
        this.reachableRegionCutoffAngle = reachableRegionCutoffAngle;
        this.calculateReachableRegions(this.footWidth);
    }

    public FrameConvexPolygon2D getReachableRegion(RobotSide robotSide) {
        return (FrameConvexPolygon2D)this.reachableRegions.get((Enum)robotSide);
    }

    public double getKinematicStepRange() {
        return this.kinematicStepRange;
    }

    public double getCaptureRegionArea() {
        this.captureRegionPolygon.update();
        return this.captureRegionPolygon.getArea();
    }

    public boolean computeVisibleVerticesFromOutsideLeftToRightCopy(FrameConvexPolygon2DReadOnly convexPolygon, FramePoint2DReadOnly observerFramePoint) {
        this.visibleVertices.clear();
        convexPolygon.checkReferenceFrameMatch((ReferenceFrameHolder)observerFramePoint);
        int lineOfSightStartIndex = convexPolygon.lineOfSightStartIndex(observerFramePoint);
        int lineOfSightEndIndex = convexPolygon.lineOfSightEndIndex(observerFramePoint);
        if (lineOfSightStartIndex == -1 || lineOfSightEndIndex == -1) {
            return false;
        }
        int index = lineOfSightEndIndex;
        do {
            ((FramePoint2D)this.visibleVertices.add()).setIncludingFrame((FrameTuple2DReadOnly)convexPolygon.getVertex(index));
        } while ((index = convexPolygon.getPreviousVertexIndex(index)) != lineOfSightStartIndex);
        ((FramePoint2D)this.visibleVertices.add()).setIncludingFrame((FrameTuple2DReadOnly)convexPolygon.getVertex(index));
        return true;
    }
}

