/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.captureRegion.AchievableCaptureRegionCalculatorWithDelay;
import us.ihmc.commonWalkingControlModules.captureRegion.ReachableFootholdsCalculator;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MultiStepPushRecoveryCalculator {
    private static final boolean VISUALIZE = true;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private final ReachableFootholdsCalculator reachableFootholdsCalculator;
    private final AchievableCaptureRegionCalculatorWithDelay captureRegionCalculator;
    private final ConvexPolygonTools polygonTools = new ConvexPolygonTools();
    private final FrameConvexPolygon2D reachableRegion = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D captureRegion = new FrameConvexPolygon2D();
    private final List<YoFramePoint2D> capturePointsAtTouchdown = new ArrayList<YoFramePoint2D>();
    private final List<YoFramePoint2D> recoveryStepLocations = new ArrayList<YoFramePoint2D>();
    private final List<YoFrameConvexPolygon2D> yoCaptureRegions = new ArrayList<YoFrameConvexPolygon2D>();
    private final List<YoFrameConvexPolygon2D> yoCaptureRegionsAtTouchdown = new ArrayList<YoFrameConvexPolygon2D>();
    private final List<YoFrameConvexPolygon2D> yoReachableRegions = new ArrayList<YoFrameConvexPolygon2D>();
    private final PoseReferenceFrame stanceFrame = new PoseReferenceFrame("StanceFrame", worldFrame);
    private final FramePose3D stancePose = new FramePose3D();
    private final FramePoint2D stancePosition = new FramePoint2D();
    private final FramePoint3D stepPosition = new FramePoint3D();
    private final ConvexPolygon2DReadOnly defaultFootPolygon;
    private final FramePoint2D icpAtStart = new FramePoint2D();
    private final FrameConvexPolygon2DBasics stancePolygon = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2DBasics intersectingRegion = new FrameConvexPolygon2D();
    private final RecyclingArrayList<Footstep> recoveryFootsteps = new RecyclingArrayList(Footstep::new);
    private final RecyclingArrayList<FootstepTiming> recoveryFootstepTimings = new RecyclingArrayList(FootstepTiming::new);
    private static final int maxRegionDepth = 3;
    private final int depth = 3;

    public MultiStepPushRecoveryCalculator(double kinematicsStepRange, double footWidth, SideDependentList<? extends ReferenceFrame> soleZUpFrames, ConvexPolygon2DReadOnly defaultFootPolygon, String suffix, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this.soleZUpFrames = soleZUpFrames;
        this.defaultFootPolygon = defaultFootPolygon;
        this.reachableFootholdsCalculator = new ReachableFootholdsCalculator(kinematicsStepRange, kinematicsStepRange, footWidth, kinematicsStepRange, soleZUpFrames, this.registry);
        this.captureRegionCalculator = new AchievableCaptureRegionCalculatorWithDelay();
        for (int i = 0; i < 3; ++i) {
            this.capturePointsAtTouchdown.add(new YoFramePoint2D("capturePointAtTouchdown" + i, worldFrame, this.registry));
            this.recoveryStepLocations.add(new YoFramePoint2D("recoveryStepLocation" + i, worldFrame, this.registry));
        }
        if (graphicsListRegistry != null) {
            String listName = this.getClass().getSimpleName();
            for (int i = 0; i < 3; ++i) {
                String captureName = "captureRegion" + i;
                YoFrameConvexPolygon2D yoCaptureRegionPolygon = new YoFrameConvexPolygon2D(captureName, suffix, worldFrame, 30, this.registry);
                this.yoCaptureRegions.add(yoCaptureRegionPolygon);
                YoFrameConvexPolygon2D yoCaptureRegionPolygonAtTouchdown = new YoFrameConvexPolygon2D(captureName + "AtTouchdown", suffix, worldFrame, 30, this.registry);
                this.yoCaptureRegionsAtTouchdown.add(yoCaptureRegionPolygonAtTouchdown);
                YoArtifactPolygon capturePolygonArtifact = new YoArtifactPolygon(captureName + suffix, yoCaptureRegionPolygon, Color.RED, false);
                YoArtifactPolygon capturePolygonAtTouchdownArtifact = new YoArtifactPolygon(captureName + "AtTouchdown" + suffix, yoCaptureRegionPolygonAtTouchdown, Color.RED, false, true);
                String reachableName = "reachableRegion" + i;
                YoFrameConvexPolygon2D yoReachableRegionPolygon = new YoFrameConvexPolygon2D(reachableName, suffix, worldFrame, 30, this.registry);
                this.yoReachableRegions.add(yoReachableRegionPolygon);
                YoArtifactPolygon reachablePolygonArtifact = new YoArtifactPolygon(reachableName + suffix, yoReachableRegionPolygon, Color.BLUE, false);
                YoGraphicPosition touchdownICPViz = new YoGraphicPosition("capturePointTouchdown" + i + suffix, this.capturePointsAtTouchdown.get(i), 0.01, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.SOLID_BALL);
                YoGraphicPosition footstepViz = new YoGraphicPosition("recoveryStepLocation" + i + suffix, this.recoveryStepLocations.get(i), 0.025, YoAppearance.Blue(), YoGraphicPosition.GraphicType.SOLID_BALL);
                graphicsListRegistry.registerArtifact(listName, (Artifact)capturePolygonArtifact);
                graphicsListRegistry.registerArtifact(listName, (Artifact)capturePolygonAtTouchdownArtifact);
                graphicsListRegistry.registerArtifact(listName, (Artifact)reachablePolygonArtifact);
                graphicsListRegistry.registerArtifact(listName, (Artifact)touchdownICPViz.createArtifact());
                graphicsListRegistry.registerArtifact(listName, (Artifact)footstepViz.createArtifact());
            }
        }
        parentRegistry.addChild(this.registry);
    }

    public void computeRecoverySteps(RobotSide swingSide, double swingTimeRemaining, double nextTransferDuration, FramePoint2DReadOnly currentICP, double omega0, FrameConvexPolygon2DReadOnly footPolygon) {
        int numberOfRecoverySteps = this.calculateRecoveryStepLocations(swingSide, swingTimeRemaining, nextTransferDuration, currentICP, omega0, footPolygon);
        this.recoveryFootsteps.clear();
        this.recoveryFootstepTimings.clear();
        for (int i = 0; i < numberOfRecoverySteps; ++i) {
            this.stepPosition.set((FrameTuple2DReadOnly)this.recoveryStepLocations.get(i), this.stancePose.getZ());
            Footstep recoveryFootstep = (Footstep)this.recoveryFootsteps.add();
            recoveryFootstep.setPose((FrameTuple3DReadOnly)this.stepPosition, (FrameQuaternionReadOnly)this.stancePose.getOrientation());
            recoveryFootstep.setRobotSide(swingSide);
            ((FootstepTiming)this.recoveryFootstepTimings.add()).setTimings(swingTimeRemaining, nextTransferDuration);
            swingSide = swingSide.getOppositeSide();
        }
    }

    public int getNumberOfRecoverySteps() {
        return this.recoveryFootsteps.size();
    }

    public Footstep getRecoveryStep(int stepIdx) {
        return (Footstep)this.recoveryFootsteps.get(stepIdx);
    }

    public FootstepTiming getRecoveryStepTiming(int stepIdx) {
        return (FootstepTiming)this.recoveryFootstepTimings.get(stepIdx);
    }

    public int calculateRecoveryStepLocations(RobotSide swingSide, double swingTimeRemaining, double nextTransferDuration, FramePoint2DReadOnly currentICP, double omega0, FrameConvexPolygon2DReadOnly footPolygon) {
        int depthIdx;
        this.icpAtStart.set((FrameTuple2DReadOnly)currentICP);
        this.stancePose.setToZero((ReferenceFrame)this.soleZUpFrames.get((Enum)swingSide.getOppositeSide()));
        this.stancePose.changeFrame(worldFrame);
        this.stancePolygon.setIncludingFrame((FrameVertex2DSupplier)footPolygon);
        int numberOfRecoverySteps = 0;
        for (depthIdx = 0; depthIdx < 3; ++depthIdx) {
            this.reachableFootholdsCalculator.calculateReachableRegion(swingSide, (FramePoint3DReadOnly)this.stancePose.getPosition(), (FrameQuaternionReadOnly)this.stancePose.getOrientation(), (FrameConvexPolygon2DBasics)this.reachableRegion);
            if (this.captureRegionCalculator.calculateCaptureRegion(swingTimeRemaining, nextTransferDuration, (FramePoint2DReadOnly)this.icpAtStart, omega0, (FramePose3DReadOnly)this.stancePose, (FrameConvexPolygon2DReadOnly)this.stancePolygon)) break;
            this.captureRegion.setIncludingFrame((FrameVertex2DSupplier)this.captureRegionCalculator.getUnconstrainedCaptureRegion());
            this.captureRegion.changeFrameAndProjectToXYPlane(worldFrame);
            this.yoCaptureRegionsAtTouchdown.get(depthIdx).setMatchingFrame((FrameVertex2DSupplier)this.captureRegionCalculator.getUnconstrainedCaptureRegionAtTouchdown(), false);
            this.yoCaptureRegions.get(depthIdx).set((FrameVertex2DSupplier)this.captureRegion);
            this.yoReachableRegions.get(depthIdx).set((FrameVertex2DSupplier)this.reachableRegion);
            this.stancePosition.set((FrameTuple3DReadOnly)this.stancePose.getPosition());
            ++numberOfRecoverySteps;
            if (this.polygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)this.captureRegion, (ConvexPolygon2DReadOnly)this.reachableRegion, (ConvexPolygon2DBasics)this.intersectingRegion)) {
                FramePoint2DReadOnly centerOfIntersection = this.intersectingRegion.getCentroid();
                EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)this.stancePosition, (Point2DReadOnly)centerOfIntersection, (List)this.intersectingRegion.getPolygonVerticesView(), (int)this.intersectingRegion.getNumberOfVertices(), (boolean)true, (Point2DBasics)((Point2DBasics)this.capturePointsAtTouchdown.get(depthIdx)), null);
                this.recoveryStepLocations.get(depthIdx).set((FrameTuple2DReadOnly)this.capturePointsAtTouchdown.get(depthIdx));
                ++depthIdx;
                break;
            }
            this.polygonTools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)this.reachableRegion, (ConvexPolygon2DReadOnly)this.captureRegion, (Point2DBasics)this.recoveryStepLocations.get(depthIdx), (Point2DBasics)this.capturePointsAtTouchdown.get(depthIdx));
            swingSide = swingSide.getOppositeSide();
            this.stancePose.getPosition().set((FrameTuple2DReadOnly)this.recoveryStepLocations.get(depthIdx));
            this.icpAtStart.set((FrameTuple2DReadOnly)this.capturePointsAtTouchdown.get(depthIdx));
            this.stanceFrame.setPoseAndUpdate((FramePose3DReadOnly)this.stancePose);
            this.stancePolygon.clear((ReferenceFrame)this.stanceFrame);
            this.stancePolygon.set((Vertex2DSupplier)this.defaultFootPolygon);
            this.stancePolygon.update();
            this.stancePolygon.scale(this.stancePolygon.getCentroid(), 0.5);
            this.stancePolygon.changeFrameAndProjectToXYPlane(worldFrame);
        }
        while (depthIdx < 3) {
            this.capturePointsAtTouchdown.get(depthIdx).setToNaN();
            this.recoveryStepLocations.get(depthIdx).setToNaN();
            this.yoReachableRegions.get(depthIdx).clearAndUpdate();
            this.yoCaptureRegionsAtTouchdown.get(depthIdx).clearAndUpdate();
            this.yoCaptureRegions.get(depthIdx).clearAndUpdate();
            ++depthIdx;
        }
        return numberOfRecoverySteps;
    }
}

