/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import java.awt.Color;
import java.util.function.Supplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CaptureRegionVisualizer {
    private static final String caption = "CaptureRegion";
    private static final Color color = Color.GREEN;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoFrameConvexPolygon2D yoCaptureRegionPolygon;
    private final FrameConvexPolygon2D captureRegionPolygon = new FrameConvexPolygon2D();
    private final Supplier<FrameConvexPolygon2DReadOnly> captureRegionProvider;

    public CaptureRegionVisualizer(Supplier<FrameConvexPolygon2DReadOnly> captureRegionProvider, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(captureRegionProvider, "", yoGraphicsListRegistry, parentRegistry);
    }

    public CaptureRegionVisualizer(Supplier<FrameConvexPolygon2DReadOnly> captureRegionProvider, String suffix, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.captureRegionProvider = captureRegionProvider;
        this.yoCaptureRegionPolygon = new YoFrameConvexPolygon2D(caption, suffix, worldFrame, 30, this.registry);
        YoArtifactPolygon polygonArtifact = new YoArtifactPolygon(caption + suffix, this.yoCaptureRegionPolygon, color, false);
        yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)polygonArtifact);
        parentRegistry.addChild(this.registry);
    }

    public void hide() {
        this.yoCaptureRegionPolygon.clear();
    }

    public void update() {
        this.captureRegionPolygon.setIncludingFrame((FrameVertex2DSupplier)this.captureRegionProvider.get());
        this.captureRegionPolygon.changeFrameAndProjectToXYPlane(worldFrame);
        if (this.yoCaptureRegionPolygon != null) {
            try {
                this.yoCaptureRegionPolygon.set((FrameVertex2DSupplier)this.captureRegionPolygon);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

