/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;

public class CaptureRegionMathTools {
    private final RigidBodyTransform rotation = new RigidBodyTransform();
    private final FrameVector3D rotatedFromA = new FrameVector3D();

    public void getPointBetweenVectorsAtDistanceFromOriginCircular(FrameVector2DReadOnly directionA, FrameVector2DReadOnly directionB, double alpha, double radius, FramePoint2DReadOnly centerOfCircle, FramePoint2DBasics pointToPack) {
        directionA.checkReferenceFrameMatch(directionB.getReferenceFrame());
        directionA.checkReferenceFrameMatch(centerOfCircle.getReferenceFrame());
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        double angleBetweenDirections = Math.abs(directionA.angle(directionB));
        double angleBetweenDirectionsToSetLine = -angleBetweenDirections * alpha;
        this.rotatedFromA.setIncludingFrame((FrameTuple2DReadOnly)directionA, 0.0);
        this.rotation.setRotationYawAndZeroTranslation(angleBetweenDirectionsToSetLine);
        this.rotatedFromA.applyTransform((Transform)this.rotation);
        this.rotatedFromA.scale(radius / this.rotatedFromA.length());
        pointToPack.setIncludingFrame((FrameTuple3DReadOnly)this.rotatedFromA);
        pointToPack.add((FrameTuple2DReadOnly)centerOfCircle);
    }
}

