/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class StepAdjustmentReachabilityConstraint {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int numberOfVertices = 5;
    private static final double SUFFICIENTLY_LARGE = 5.0;
    private final SideDependentList<List<YoFramePoint2D>> reachabilityVertices = new SideDependentList();
    private final SideDependentList<YoFrameConvexPolygon2D> reachabilityPolygons = new SideDependentList();
    private final SideDependentList<List<YoFramePoint2D>> adjustmentVertices = new SideDependentList();
    private final SideDependentList<PoseReferenceFrame> stepFrames = new SideDependentList();
    private final SideDependentList<YoFrameConvexPolygon2D> adjustmentPolygons = new SideDependentList();
    private final FixedFrameConvexPolygon2DBasics adjustmentPolygon = new FrameConvexPolygon2D(worldFrame);
    private final FixedFrameConvexPolygon2DBasics reachabilityPolygon = new FrameConvexPolygon2D(worldFrame);
    private final YoFrameConvexPolygon2D contractedReachabilityPolygon;
    private final DoubleProvider lengthLimit;
    private final DoubleProvider lengthBackLimit;
    private final DoubleProvider innerLimit;
    private final DoubleProvider outerLimit;
    private final DoubleProvider forwardAdjustmentLimit;
    private final DoubleProvider backwardAdjustmentLimit;
    private final DoubleProvider inwardAdjustmentLimit;
    private final DoubleProvider outwardAdjustmentLimit;
    private final ConvexPolygonTools polygonTools = new ConvexPolygonTools();

    public StepAdjustmentReachabilityConstraint(SideDependentList<? extends ReferenceFrame> soleZUpFrames, ICPOptimizationParameters icpOptimizationParameters, SteppingParameters steppingParameters, String yoNamePrefix, boolean visualize, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.lengthLimit = new DoubleParameter(yoNamePrefix + "MaxReachabilityLength", registry, steppingParameters.getMaxStepLength());
        this.lengthBackLimit = new DoubleParameter(yoNamePrefix + "MaxReachabilityBackwardLength", registry, steppingParameters.getMaxBackwardStepLength());
        this.innerLimit = new DoubleParameter(yoNamePrefix + "MinReachabilityWidth", registry, steppingParameters.getMinStepWidth());
        this.outerLimit = new DoubleParameter(yoNamePrefix + "MaxReachabilityWidth", registry, steppingParameters.getMaxStepWidth());
        this.forwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "ForwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentForward()));
        this.backwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "BackwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentBackward()));
        this.inwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "InwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentInward()));
        this.outwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "OutwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentOutward()));
        for (RobotSide robotSide : RobotSide.values) {
            ReferenceFrame supportSoleFrame = (ReferenceFrame)soleZUpFrames.get((Enum)robotSide);
            YoInteger yoNumberOfReachabilityVertices = new YoInteger(robotSide.getLowerCaseName() + "NumberOfReachabilityVertices", registry);
            yoNumberOfReachabilityVertices.set(5);
            String prefix = yoNamePrefix + robotSide.getSideNameFirstLetter();
            ArrayList<YoFramePoint2D> reachabilityVertices = new ArrayList<YoFramePoint2D>();
            for (int i = 0; i < yoNumberOfReachabilityVertices.getValue(); ++i) {
                YoFramePoint2D vertex = new YoFramePoint2D(prefix + "ReachabilityVertex" + i, supportSoleFrame, registry);
                reachabilityVertices.add(vertex);
            }
            YoFrameConvexPolygon2D reachabilityPolygon = new YoFrameConvexPolygon2D(reachabilityVertices, yoNumberOfReachabilityVertices, supportSoleFrame);
            this.reachabilityVertices.put((Enum)robotSide, reachabilityVertices);
            this.reachabilityPolygons.put((Enum)robotSide, (Object)reachabilityPolygon);
            PoseReferenceFrame adjustmentFrame = new PoseReferenceFrame(prefix + "AdjustmentFrame", worldFrame);
            YoInteger yoNumberOfAdjustmentVertices = new YoInteger(robotSide.getLowerCaseName() + "NumberOfAdjustmentVertices", registry);
            yoNumberOfAdjustmentVertices.set(4);
            ArrayList<YoFramePoint2D> adjustmentVertices = new ArrayList<YoFramePoint2D>();
            for (int i = 0; i < 4; ++i) {
                YoFramePoint2D adjustmentVertex = new YoFramePoint2D(prefix + "AdjustmentVertex" + i, (ReferenceFrame)adjustmentFrame, registry);
                adjustmentVertices.add(adjustmentVertex);
            }
            YoFrameConvexPolygon2D adjustmentPolygon = new YoFrameConvexPolygon2D(adjustmentVertices, yoNumberOfAdjustmentVertices, (ReferenceFrame)adjustmentFrame);
            this.stepFrames.put((Enum)robotSide, (Object)adjustmentFrame);
            this.adjustmentVertices.put((Enum)robotSide, adjustmentVertices);
            this.adjustmentPolygons.put((Enum)robotSide, (Object)adjustmentPolygon);
        }
        this.contractedReachabilityPolygon = new YoFrameConvexPolygon2D(yoNamePrefix + "ReachabilityRegion", "", worldFrame, 12, registry);
        if (yoGraphicsListRegistry != null) {
            YoArtifactPolygon reachabilityGraphic = new YoArtifactPolygon("ReachabilityRegionViz", this.contractedReachabilityPolygon, Color.BLUE, false);
            reachabilityGraphic.setVisible(visualize);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)reachabilityGraphic);
        }
    }

    public void reset() {
        this.contractedReachabilityPolygon.clear();
    }

    public FrameConvexPolygon2DReadOnly initializeReachabilityConstraint(RobotSide supportSide, FramePose3DReadOnly footstepPose) {
        FrameConvexPolygon2DReadOnly reachabilityPolygon = this.getReachabilityPolygon(supportSide);
        FrameConvexPolygon2DReadOnly adjustmentPolygon = this.getAdjustmentPolygon(supportSide.getOppositeSide(), footstepPose);
        this.contractedReachabilityPolygon.checkReferenceFrameMatch((ReferenceFrameHolder)reachabilityPolygon);
        this.contractedReachabilityPolygon.checkReferenceFrameMatch((ReferenceFrameHolder)adjustmentPolygon);
        if (this.polygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)reachabilityPolygon, (ConvexPolygon2DReadOnly)adjustmentPolygon, (ConvexPolygon2DBasics)this.contractedReachabilityPolygon)) {
            return this.contractedReachabilityPolygon;
        }
        this.contractedReachabilityPolygon.clear();
        this.contractedReachabilityPolygon.addVertex(footstepPose.getPosition());
        this.contractedReachabilityPolygon.update();
        return this.contractedReachabilityPolygon;
    }

    private FrameConvexPolygon2DReadOnly getReachabilityPolygon(RobotSide supportSide) {
        List vertices = (List)this.reachabilityVertices.get((Enum)supportSide);
        YoFrameConvexPolygon2D polygon = (YoFrameConvexPolygon2D)this.reachabilityPolygons.get((Enum)supportSide);
        double xRadius = 0.5 * (this.lengthLimit.getValue() + this.lengthBackLimit.getValue());
        double yRadius = this.outerLimit.getValue() - this.innerLimit.getValue();
        double centerX = this.lengthLimit.getValue() - xRadius;
        double centerY = this.innerLimit.getValue();
        for (int vertexIdx = 0; vertexIdx < vertices.size(); ++vertexIdx) {
            double angle = Math.PI * (double)vertexIdx / (double)(vertices.size() - 1);
            double x = centerX + xRadius * Math.cos(angle);
            double y = centerY + yRadius * Math.sin(angle);
            ((YoFramePoint2D)vertices.get(vertexIdx)).set(x, supportSide.negateIfLeftSide(y));
        }
        polygon.notifyVerticesChanged();
        polygon.update();
        this.reachabilityPolygon.setMatchingFrame((FrameVertex2DSupplier)polygon, false);
        return this.reachabilityPolygon;
    }

    private FrameConvexPolygon2DReadOnly getAdjustmentPolygon(RobotSide swingSide, FramePose3DReadOnly footstepPose) {
        ((PoseReferenceFrame)this.stepFrames.get((Enum)swingSide)).setPoseAndUpdate(footstepPose);
        List vertices = (List)this.adjustmentVertices.get((Enum)swingSide);
        YoFrameConvexPolygon2D polygon = (YoFrameConvexPolygon2D)this.adjustmentPolygons.get((Enum)swingSide);
        ((YoFramePoint2D)vertices.get(0)).set(this.forwardAdjustmentLimit.getValue(), swingSide.negateIfRightSide(this.outwardAdjustmentLimit.getValue()));
        ((YoFramePoint2D)vertices.get(1)).set(this.forwardAdjustmentLimit.getValue(), swingSide.negateIfLeftSide(this.inwardAdjustmentLimit.getValue()));
        ((YoFramePoint2D)vertices.get(2)).set(-this.backwardAdjustmentLimit.getValue(), swingSide.negateIfRightSide(this.outwardAdjustmentLimit.getValue()));
        ((YoFramePoint2D)vertices.get(3)).set(-this.backwardAdjustmentLimit.getValue(), swingSide.negateIfLeftSide(this.inwardAdjustmentLimit.getValue()));
        polygon.notifyVerticesChanged();
        polygon.update();
        this.adjustmentPolygon.setMatchingFrame((FrameVertex2DSupplier)polygon, false);
        return this.adjustmentPolygon;
    }

    public FrameConvexPolygon2DReadOnly getReachabilityConstraint() {
        return this.contractedReachabilityPolygon;
    }
}

