/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.EnvironmentConstraintHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.StepAdjustmentReachabilityConstraint;
import us.ihmc.commonWalkingControlModules.captureRegion.OneStepCaptureRegionCalculator;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.humanoidRobotics.footstep.SimpleFootstep;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class StepAdjustmentController {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final boolean VISUALIZE = true;
    private static final boolean CONTINUOUSLY_UPDATE_DESIRED_POSITION = true;
    private static final String yoNamePrefix = "controller";
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final BooleanProvider allowStepAdjustment;
    private final DoubleProvider footstepDeadband;
    private final DoubleProvider transferDurationSplitFraction;
    private final DoubleProvider minimumFootstepMultiplier;
    private final DoubleProvider minICPErrorForStepAdjustment;
    private final DoubleProvider maximumTimeFromTransfer;
    private final BooleanProvider useActualErrorInsteadOfResidual;
    private final YoBoolean useStepAdjustment = new YoBoolean("controllerUseStepAdjustment", this.registry);
    private final YoBoolean footstepIsAdjustable = new YoBoolean("controllerFootstepIsAdjustable", this.registry);
    private final YoBoolean hasPlanarRegionBeenAssigned = new YoBoolean("controllerHasPlanarRegionBeenAssigned", this.registry);
    private final YoDouble swingDuration = new YoDouble("controllerSwingDuration", this.registry);
    private final YoDouble nextTransferDuration = new YoDouble("controllerNextTransferDuration", this.registry);
    private final YoDouble footstepMultiplier = new YoDouble("controllerTotalFootstepMultiplier", this.registry);
    private final YoFramePose3D upcomingFootstep = new YoFramePose3D("controllerUpcomingFootstepPose", worldFrame, this.registry);
    private final YoEnum<RobotSide> upcomingFootstepSide = new YoEnum("controllerUpcomingFootstepSide", this.registry, RobotSide.class);
    private final RecyclingArrayList<Point2D> upcomingFootstepContactPoints = new RecyclingArrayList(Point2D.class);
    private final FramePoint3D referencePositionInControlPlane = new FramePoint3D();
    private final FramePoint3D tempPoint = new FramePoint3D();
    private final YoFrameVector2D footstepAdjustmentInControlPlane = new YoFrameVector2D("controllerfootstepAdjustmentInControlPlane", worldFrame, this.registry);
    private final YoFrameVector2D deadbandedAdjustment = new YoFrameVector2D("controllerDeadbandedAdjustment", worldFrame, this.registry);
    private final YoFramePose3D footstepSolution = new YoFramePose3D("controllerFootstepSolutionLocation", worldFrame, this.registry);
    private final YoFramePoint2D adjustedSolutionInControlPlane = new YoFramePoint2D("controlleradjustedSolutionInControlPlane", worldFrame, this.registry);
    private final YoBoolean isInSwing = new YoBoolean("controllerIsInSwing", this.registry);
    private final YoDouble initialTime = new YoDouble("controllerInitialTime", this.registry);
    private final YoDouble timeInCurrentState = new YoDouble("controllerTimeInCurrentState", this.registry);
    private final YoDouble timeRemainingInState = new YoDouble("controllerTimeRemainingInState", this.registry);
    private final YoDouble recursionTime = new YoDouble("controllerRecursionTime", this.registry);
    private final YoDouble recursionMultiplier = new YoDouble("controllerRecursionMultiplier", this.registry);
    private final YoBoolean swingSpeedUpEnabled = new YoBoolean("controllerSwingSpeedUpEnabled", this.registry);
    private final YoDouble speedUpTime = new YoDouble("controllerSpeedUpTime", this.registry);
    private final YoFrameVector2D icpError = new YoFrameVector2D("controllerICPError", "", worldFrame, this.registry);
    private final YoBoolean footstepWasAdjusted = new YoBoolean("controllerFootstepWasAdjusted", this.registry);
    private final StepAdjustmentReachabilityConstraint reachabilityConstraintHandler;
    private final OneStepCaptureRegionCalculator captureRegionCalculator;
    private final EnvironmentConstraintHandler environmentConstraintProvider;
    private final FrameConvexPolygon2D captureRegionInWorld = new FrameConvexPolygon2D();
    private final ICPControlPlane icpControlPlane;
    private final BipedSupportPolygons bipedSupportPolygons;

    public StepAdjustmentController(WalkingControllerParameters walkingControllerParameters, SideDependentList<? extends ReferenceFrame> soleZUpFrames, BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, SideDependentList<? extends ContactablePlaneBody> contactableFeet, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(walkingControllerParameters, walkingControllerParameters.getICPOptimizationParameters(), soleZUpFrames, bipedSupportPolygons, icpControlPolygons, contactableFeet, controlDT, parentRegistry, yoGraphicsListRegistry);
    }

    public StepAdjustmentController(WalkingControllerParameters walkingControllerParameters, ICPOptimizationParameters icpOptimizationParameters, SideDependentList<? extends ReferenceFrame> soleZUpFrames, BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, SideDependentList<? extends ContactablePlaneBody> contactableFeet, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.icpControlPlane = icpControlPolygons.getIcpControlPlane();
        this.bipedSupportPolygons = bipedSupportPolygons;
        this.allowStepAdjustment = new BooleanParameter("controllerAllowStepAdjustment", this.registry, icpOptimizationParameters.allowStepAdjustment());
        this.minimumFootstepMultiplier = new DoubleParameter("controllerMinimumFootstepMultiplier", this.registry, icpOptimizationParameters.getMinimumFootstepMultiplier());
        this.maximumTimeFromTransfer = new DoubleParameter("controllerMaximumTimeFromTransfer", this.registry, icpOptimizationParameters.maximumTimeFromTransferInFootstepMultiplier());
        this.minICPErrorForStepAdjustment = new DoubleParameter("controllerMinICPErrorForStepAdjustment", this.registry, icpOptimizationParameters.getMinICPErrorForStepAdjustment());
        this.transferDurationSplitFraction = new DoubleParameter("controllerTransferDurationSplitFraction", this.registry, icpOptimizationParameters.getTransferSplitFraction());
        this.footstepDeadband = new DoubleParameter("controllerFootstepDeadband", this.registry, icpOptimizationParameters.getAdjustmentDeadband());
        this.useActualErrorInsteadOfResidual = new BooleanParameter("useActualErrorInsteadOfResidual", this.registry, false);
        this.reachabilityConstraintHandler = new StepAdjustmentReachabilityConstraint(soleZUpFrames, icpOptimizationParameters, walkingControllerParameters.getSteppingParameters(), yoNamePrefix, true, this.registry, yoGraphicsListRegistry);
        this.captureRegionCalculator = new OneStepCaptureRegionCalculator(soleZUpFrames, walkingControllerParameters, yoNamePrefix, this.registry, yoGraphicsListRegistry);
        this.environmentConstraintProvider = new EnvironmentConstraintHandler(this.icpControlPlane, contactableFeet, yoNamePrefix, this.registry, yoGraphicsListRegistry);
        if (walkingControllerParameters != null) {
            this.swingSpeedUpEnabled.set(walkingControllerParameters.allowDisturbanceRecoveryBySpeedingUpSwing());
        }
        if (yoGraphicsListRegistry != null) {
            this.setupVisualizers(yoGraphicsListRegistry);
        }
        parentRegistry.addChild(this.registry);
    }

    private void setupVisualizers(YoGraphicsListRegistry yoGraphicsListRegistry) {
        ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
        YoGraphicPosition clippedFootstepSolution = new YoGraphicPosition("controllerFootstepSolution", this.footstepSolution.getPosition(), 0.005, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.BALL);
        artifactList.add((Artifact)clippedFootstepSolution.createArtifact());
        artifactList.setVisible(true);
        yoGraphicsListRegistry.registerArtifactList(artifactList);
    }

    public void reset() {
        this.reachabilityConstraintHandler.reset();
        this.isInSwing.set(false);
        this.upcomingFootstep.setToNaN();
        this.footstepSolution.setToNaN();
        this.footstepWasAdjusted.set(false);
        this.hasPlanarRegionBeenAssigned.set(false);
        this.captureRegionCalculator.hideCaptureRegion();
        this.environmentConstraintProvider.reset();
    }

    public void setFootstepToAdjust(SimpleFootstep footstep, double swingDuration, double nextTransferDuration) {
        FramePose3D footstepPose = footstep.getSoleFramePose();
        footstepPose.checkReferenceFrameMatch(worldFrame);
        if (!footstepPose.containsNaN()) {
            this.upcomingFootstep.set((FramePose3DReadOnly)footstepPose);
            this.upcomingFootstepSide.set((Enum)footstep.getRobotSide());
            this.upcomingFootstepContactPoints.clear();
            ConvexPolygon2DReadOnly foothold = footstep.getFoothold();
            for (int i = 0; i < foothold.getNumberOfVertices(); ++i) {
                ((Point2D)this.upcomingFootstepContactPoints.add()).set((Tuple2DReadOnly)foothold.getVertex(i));
            }
            this.footstepSolution.set((FramePose3DReadOnly)footstepPose);
            this.swingDuration.set(swingDuration);
            this.footstepIsAdjustable.set(footstep.getIsAdjustable());
            this.useStepAdjustment.set(this.allowStepAdjustment.getValue() && this.footstepIsAdjustable.getBooleanValue());
            this.nextTransferDuration.set(nextTransferDuration);
        } else {
            LogTools.warn((String)("Received bad footstep: " + footstep));
        }
    }

    public void submitRemainingTimeInSwingUnderDisturbance(double remainingTimeForSwing) {
        if (this.swingSpeedUpEnabled.getBooleanValue() && remainingTimeForSwing < this.timeRemainingInState.getDoubleValue()) {
            double speedUpTime = this.timeRemainingInState.getDoubleValue() - remainingTimeForSwing;
            this.speedUpTime.add(speedUpTime);
        }
    }

    public void setStepConstraintRegion(StepConstraintRegion stepConstraintRegion) {
        this.environmentConstraintProvider.setStepConstraintRegion(stepConstraintRegion);
    }

    public boolean hasStepConstraintRegion() {
        return this.environmentConstraintProvider.hasStepConstraintRegion();
    }

    public void initialize(double initialTime, RobotSide supportSide) {
        this.isInSwing.set(true);
        this.initialTime.set(initialTime);
        this.reachabilityConstraintHandler.initializeReachabilityConstraint(supportSide, (FramePose3DReadOnly)this.upcomingFootstep);
        this.speedUpTime.set(0.0);
        this.footstepSolution.set((FramePose3DReadOnly)this.upcomingFootstep);
    }

    public void compute(double currentTime, FramePoint2DReadOnly desiredICP, FramePoint2DReadOnly currentICP, FrameVector2DReadOnly residualICPError, double omega0) {
        if (!this.isInSwing.getBooleanValue()) {
            return;
        }
        this.computeTimeInCurrentState(currentTime);
        this.computeTimeRemainingInState();
        this.captureRegionCalculator.calculateCaptureRegion((RobotSide)this.upcomingFootstepSide.getEnumValue(), this.timeRemainingInState.getDoubleValue(), currentICP, omega0, this.bipedSupportPolygons.getFootPolygonInWorldFrame(((RobotSide)this.upcomingFootstepSide.getEnumValue()).getOppositeSide()));
        if (!this.useStepAdjustment.getBooleanValue()) {
            return;
        }
        this.icpError.sub((FrameTuple2DReadOnly)desiredICP, (FrameTuple2DReadOnly)currentICP);
        this.environmentConstraintProvider.setReachabilityRegion(this.reachabilityConstraintHandler.getReachabilityConstraint());
        if (!this.environmentConstraintProvider.validateConvexityOfPlanarRegion()) {
            return;
        }
        boolean errorAboveThreshold = this.icpError.lengthSquared() > MathTools.square((double)this.minICPErrorForStepAdjustment.getValue());
        boolean wasAdjusted = false;
        if (errorAboveThreshold) {
            wasAdjusted = this.adjustStepForError(residualICPError, omega0);
        }
        if (this.environmentConstraintProvider.hasStepConstraintRegion() && (wasAdjusted || !this.hasPlanarRegionBeenAssigned.getBooleanValue())) {
            wasAdjusted |= this.environmentConstraintProvider.applyEnvironmentConstraintToFootstep((RobotSide)this.upcomingFootstepSide.getEnumValue(), (FixedFramePose3DBasics)this.footstepSolution, (List<Point2D>)this.upcomingFootstepContactPoints);
            this.hasPlanarRegionBeenAssigned.set(this.environmentConstraintProvider.foundSolution());
        }
        this.footstepWasAdjusted.set(wasAdjusted);
        if (this.wasFootstepAdjusted()) {
            this.upcomingFootstep.set((FramePose3DReadOnly)this.footstepSolution);
        }
    }

    private boolean adjustStepForError(FrameVector2DReadOnly residualICPError, double omega0) {
        boolean adjusted;
        this.footstepMultiplier.set(this.computeFootstepAdjustmentMultiplier(omega0));
        if (this.useActualErrorInsteadOfResidual.getValue()) {
            this.footstepAdjustmentInControlPlane.set((FrameTuple2DReadOnly)this.icpError);
            this.footstepAdjustmentInControlPlane.negate();
        } else {
            this.footstepAdjustmentInControlPlane.set((FrameTuple2DReadOnly)residualICPError);
        }
        this.footstepAdjustmentInControlPlane.scale(1.0 / this.footstepMultiplier.getDoubleValue());
        if (this.footstepAdjustmentInControlPlane.length() < this.footstepDeadband.getValue()) {
            adjusted = false;
            this.deadbandedAdjustment.setToZero();
        } else {
            adjusted = true;
            this.deadbandedAdjustment.set((FrameTuple2DReadOnly)this.footstepAdjustmentInControlPlane);
        }
        this.icpControlPlane.projectPointOntoControlPlane(worldFrame, (FramePoint3DReadOnly)this.upcomingFootstep.getPosition(), this.referencePositionInControlPlane);
        this.adjustedSolutionInControlPlane.set((FrameTuple3DReadOnly)this.referencePositionInControlPlane);
        this.adjustedSolutionInControlPlane.add((FrameTuple2DReadOnly)this.deadbandedAdjustment);
        this.captureRegionInWorld.setIncludingFrame((FrameVertex2DSupplier)this.captureRegionCalculator.getCaptureRegion());
        this.captureRegionInWorld.changeFrameAndProjectToXYPlane(worldFrame);
        this.captureRegionInWorld.orthogonalProjection((FixedFramePoint2DBasics)this.adjustedSolutionInControlPlane);
        this.reachabilityConstraintHandler.getReachabilityConstraint().orthogonalProjection((FixedFramePoint2DBasics)this.adjustedSolutionInControlPlane);
        this.icpControlPlane.projectPointFromControlPlaneOntoSurface(worldFrame, (FramePoint2DReadOnly)this.adjustedSolutionInControlPlane, (FramePoint3DBasics)this.tempPoint, this.upcomingFootstep.getPosition().getZ());
        this.footstepSolution.getPosition().set((FrameTuple3DReadOnly)this.tempPoint);
        return adjusted;
    }

    public FramePose3DReadOnly getFootstepSolution() {
        return this.footstepSolution;
    }

    public boolean wasFootstepAdjusted() {
        return this.footstepWasAdjusted.getBooleanValue();
    }

    public boolean useStepAdjustment() {
        return this.useStepAdjustment.getBooleanValue();
    }

    private void computeTimeInCurrentState(double currentTime) {
        this.timeInCurrentState.set(currentTime - this.initialTime.getDoubleValue() + this.speedUpTime.getDoubleValue());
    }

    private void computeTimeRemainingInState() {
        this.timeRemainingInState.set(this.swingDuration.getDoubleValue() - this.timeInCurrentState.getDoubleValue());
    }

    private double computeFootstepAdjustmentMultiplier(double omega0) {
        double timeInTransferForShifting = Math.min(this.maximumTimeFromTransfer.getValue(), this.transferDurationSplitFraction.getValue() * this.nextTransferDuration.getDoubleValue());
        this.recursionTime.set(Math.max(this.timeRemainingInState.getDoubleValue(), 0.0) + timeInTransferForShifting);
        this.recursionMultiplier.set(Math.exp(-omega0 * this.recursionTime.getDoubleValue()));
        double finalRecursionMultiplier = Math.exp(-omega0 * timeInTransferForShifting);
        double minimumFootstepMultiplier = Math.min(this.minimumFootstepMultiplier.getValue(), finalRecursionMultiplier);
        return minimumFootstepMultiplier + (1.0 - minimumFootstepMultiplier / finalRecursionMultiplier) * this.recursionMultiplier.getDoubleValue();
    }
}

