/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation;

import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionTools;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.functional.IntDoubleConsumer;

public class SplitFractionFromAreaCalculator {
    private final ConvexPolygon2D previousPolygon = new ConvexPolygon2D();
    private final ConvexPolygon2D currentPolygon = new ConvexPolygon2D();
    private final SplitFractionCalculatorParametersReadOnly splitFractionParameters;
    private final SideDependentList<? extends ConvexPolygon2DReadOnly> defaultFootPolygons;
    private IntSupplier numberOfStepsProvider;
    private IntFunction<List<? extends Point2DReadOnly>> stepPolygonGetter;
    private IntFunction<RobotSide> stepSideProvider;
    private Supplier<List<? extends Point2DReadOnly>> firstSupportPolygonProvider;
    private DoubleSupplier finalTransferWeightDistributionProvider;
    private DoubleSupplier finalTransferSplitFractionProvider;
    private IntToDoubleFunction transferWeightDistributionProvider;
    private IntToDoubleFunction transferSplitFractionProvider;
    private DoubleConsumer finalTransferWeightDistributionConsumer;
    private DoubleConsumer finalTransferSplitFractionConsumer;
    private IntDoubleConsumer transferWeightDistributionConsumer;
    private IntDoubleConsumer transferSplitFractionConsumer;

    public SplitFractionFromAreaCalculator(SplitFractionCalculatorParametersReadOnly splitFractionParameters, SideDependentList<? extends ConvexPolygon2DReadOnly> defaultFootPolygons) {
        this.splitFractionParameters = splitFractionParameters;
        this.defaultFootPolygons = defaultFootPolygons;
    }

    public void setNumberOfStepsProvider(IntSupplier numberOfStepsProvider) {
        this.numberOfStepsProvider = numberOfStepsProvider;
    }

    public void setFinalTransferWeightDistributionProvider(DoubleSupplier finalTransferWeightDistributionProvider) {
        this.finalTransferWeightDistributionProvider = finalTransferWeightDistributionProvider;
    }

    public void setFinalTransferSplitFractionProvider(DoubleSupplier finalTransferSplitFractionProvider) {
        this.finalTransferSplitFractionProvider = finalTransferSplitFractionProvider;
    }

    public void setFinalTransferWeightDistributionConsumer(DoubleConsumer finalTransferWeightDistributionConsumer) {
        this.finalTransferWeightDistributionConsumer = finalTransferWeightDistributionConsumer;
    }

    public void setFinalTransferSplitFractionConsumer(DoubleConsumer finalTransferSplitFractionConsumer) {
        this.finalTransferSplitFractionConsumer = finalTransferSplitFractionConsumer;
    }

    public void setTransferWeightDistributionProvider(IntToDoubleFunction transferWeightDistributionProvider) {
        this.transferWeightDistributionProvider = transferWeightDistributionProvider;
    }

    public void setTransferSplitFractionProvider(IntToDoubleFunction transferSplitFractionProvider) {
        this.transferSplitFractionProvider = transferSplitFractionProvider;
    }

    public void setTransferWeightDistributionConsumer(IntDoubleConsumer transferWeightDistributionConsumer) {
        this.transferWeightDistributionConsumer = transferWeightDistributionConsumer;
    }

    public void setTransferSplitFractionConsumer(IntDoubleConsumer transferSplitFractionConsumer) {
        this.transferSplitFractionConsumer = transferSplitFractionConsumer;
    }

    public void setFirstSupportPolygonProvider(Supplier<List<? extends Point2DReadOnly>> firstSupportPolygonProvider) {
        this.firstSupportPolygonProvider = firstSupportPolygonProvider;
    }

    public void setStepPolygonGetter(IntFunction<List<? extends Point2DReadOnly>> stepPolygonGetter) {
        this.stepPolygonGetter = stepPolygonGetter;
    }

    public void setStepSideProvider(IntFunction<RobotSide> stepSideProvider) {
        this.stepSideProvider = stepSideProvider;
    }

    public void computeSplitFractionsFromArea() {
        if (this.numberOfStepsProvider.getAsInt() == 0 || !this.splitFractionParameters.calculateSplitFractionsFromArea()) {
            return;
        }
        double defaultTransferSplitFraction = this.splitFractionParameters.getDefaultTransferSplitFraction();
        double defaultWeightDistribution = 0.5;
        for (int stepNumber = 0; stepNumber < this.numberOfStepsProvider.getAsInt(); ++stepNumber) {
            double weightDistributionToSet;
            double splitFractionToSet;
            double currentWeightDistribution;
            double currentSplitFraction;
            double percentWidthOnCurrentFoot;
            int i;
            List<? extends Point2DReadOnly> stepPolygon;
            if (stepNumber == 0) {
                this.previousPolygon.clear();
                stepPolygon = this.firstSupportPolygonProvider.get();
                this.previousPolygon.clear();
                for (i = 0; i < stepPolygon.size(); ++i) {
                    this.previousPolygon.addVertex(stepPolygon.get(i));
                }
                this.previousPolygon.update();
            } else {
                stepPolygon = this.stepPolygonGetter.apply(stepNumber - 1);
                if (stepPolygon != null && !stepPolygon.isEmpty()) {
                    this.previousPolygon.clear();
                    for (int i2 = 0; i2 < stepPolygon.size(); ++i2) {
                        this.previousPolygon.addVertex(stepPolygon.get(i2));
                    }
                    this.previousPolygon.update();
                } else {
                    this.previousPolygon.set((Vertex2DSupplier)this.defaultFootPolygons.get((Enum)this.stepSideProvider.apply(stepNumber - 1)));
                }
            }
            stepPolygon = this.stepPolygonGetter.apply(stepNumber);
            if (stepPolygon != null && !stepPolygon.isEmpty()) {
                this.currentPolygon.clear();
                for (i = 0; i < stepPolygon.size(); ++i) {
                    this.currentPolygon.addVertex(stepPolygon.get(i));
                }
                this.currentPolygon.update();
            } else {
                this.previousPolygon.set((Vertex2DSupplier)this.defaultFootPolygons.get((Enum)this.stepSideProvider.apply(stepNumber)));
            }
            double currentArea = this.currentPolygon.getArea();
            double previousArea = this.previousPolygon.getArea();
            double totalArea = currentArea + previousArea;
            double currentWidth = this.currentPolygon.getBoundingBoxRangeY();
            double previousWidth = this.previousPolygon.getBoundingBoxRangeY();
            double totalWidth = currentWidth + previousWidth;
            double percentAreaOnCurrentFoot = totalArea > 0.0 ? currentArea / totalArea : 0.5;
            double d = percentWidthOnCurrentFoot = totalWidth > 0.0 ? currentWidth / totalWidth : 0.5;
            if (MathTools.epsilonEquals((double)percentAreaOnCurrentFoot, (double)0.5, (double)0.01) && MathTools.epsilonEquals((double)percentWidthOnCurrentFoot, (double)0.5, (double)0.02)) continue;
            double transferWeightDistributionFromArea = InterpolationTools.linearInterpolate((double)defaultWeightDistribution, (double)this.splitFractionParameters.getFractionLoadIfFootHasFullSupport(), (double)(2.0 * percentAreaOnCurrentFoot - 1.0));
            double transferWeightDistributionFromWidth = InterpolationTools.linearInterpolate((double)defaultWeightDistribution, (double)this.splitFractionParameters.getFractionLoadIfOtherFootHasNoWidth(), (double)(2.0 * percentWidthOnCurrentFoot - 1.0));
            double transferSplitFractionFromArea = InterpolationTools.linearInterpolate((double)defaultTransferSplitFraction, (double)(1.0 - this.splitFractionParameters.getFractionTimeOnFootIfFootHasFullSupport()), (double)(2.0 * percentAreaOnCurrentFoot - 1.0));
            double transferSplitFractionFromWidth = InterpolationTools.linearInterpolate((double)defaultTransferSplitFraction, (double)(1.0 - this.splitFractionParameters.getFractionTimeOnFootIfOtherFootHasNoWidth()), (double)(2.0 * percentWidthOnCurrentFoot - 1.0));
            double transferWeightDistribution = 0.5 * (transferWeightDistributionFromArea + transferWeightDistributionFromWidth);
            double transferSplitFraction = 0.5 * (transferSplitFractionFromArea + transferSplitFractionFromWidth);
            transferWeightDistribution = MathTools.clamp((double)transferWeightDistribution, (double)0.01, (double)0.99);
            transferSplitFraction = MathTools.clamp((double)transferSplitFraction, (double)0.01, (double)0.99);
            if (stepNumber == this.numberOfStepsProvider.getAsInt() - 1) {
                currentSplitFraction = this.finalTransferSplitFractionProvider.getAsDouble();
                currentWeightDistribution = this.finalTransferWeightDistributionProvider.getAsDouble();
                splitFractionToSet = SplitFractionTools.appendSplitFraction(transferSplitFraction, currentSplitFraction, defaultTransferSplitFraction);
                weightDistributionToSet = SplitFractionTools.appendWeightDistribution(transferWeightDistribution, currentWeightDistribution, defaultWeightDistribution);
                this.finalTransferSplitFractionConsumer.accept(splitFractionToSet);
                this.finalTransferWeightDistributionConsumer.accept(weightDistributionToSet);
                continue;
            }
            currentSplitFraction = this.transferSplitFractionProvider.applyAsDouble(stepNumber + 1);
            currentWeightDistribution = this.transferWeightDistributionProvider.applyAsDouble(stepNumber + 1);
            splitFractionToSet = SplitFractionTools.appendSplitFraction(transferSplitFraction, currentSplitFraction, defaultTransferSplitFraction);
            weightDistributionToSet = SplitFractionTools.appendWeightDistribution(transferWeightDistribution, currentWeightDistribution, defaultWeightDistribution);
            this.transferSplitFractionConsumer.accept(stepNumber + 1, splitFractionToSet);
            this.transferWeightDistributionConsumer.accept(stepNumber + 1, weightDistributionToSet);
        }
    }
}

