/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;

public class ICPQPInput {
    public DMatrixRMaj quadraticTerm;
    public DMatrixRMaj linearTerm;
    public DMatrixRMaj residualCost;
    private final DMatrixRMaj tempMatrix;
    private final DMatrixRMaj tempScalar = new DMatrixRMaj(1, 1);

    public ICPQPInput(int size) {
        this.quadraticTerm = new DMatrixRMaj(size, size);
        this.linearTerm = new DMatrixRMaj(size, 1);
        this.residualCost = new DMatrixRMaj(1, 1);
        this.tempMatrix = new DMatrixRMaj(size, 1);
    }

    public void reshape(int size) {
        this.quadraticTerm.reshape(size, size);
        this.linearTerm.reshape(size, 1);
    }

    public void reset() {
        this.quadraticTerm.zero();
        this.linearTerm.zero();
        this.residualCost.zero();
    }

    public double computeCost(DMatrixRMaj x) {
        if (x.getNumRows() != this.quadraticTerm.getNumRows()) {
            throw new RuntimeException("x.getNumRows() != quadraticTerms.getNumRows()");
        }
        this.tempMatrix.reshape(x.getNumRows(), 1);
        this.tempMatrix.zero();
        this.tempScalar.zero();
        CommonOps_DDRM.mult((DMatrix1Row)this.quadraticTerm, (DMatrix1Row)x, (DMatrix1Row)this.tempMatrix);
        CommonOps_DDRM.multAddTransA((double)0.5, (DMatrix1Row)x, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.tempScalar);
        CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)this.linearTerm, (DMatrix1Row)x, (DMatrix1Row)this.tempScalar);
        CommonOps_DDRM.addEquals((DMatrixD1)this.tempScalar, (DMatrixD1)this.residualCost);
        return this.tempScalar.get(0);
    }

    public boolean equals(ICPQPInput other) {
        return this.equals(other, 1.0E-7);
    }

    public boolean equals(ICPQPInput other, double tol) {
        return MatrixFeatures_DDRM.isEquals((DMatrixD1)this.quadraticTerm, (DMatrixD1)other.quadraticTerm, (double)tol) && MatrixFeatures_DDRM.isEquals((DMatrixD1)this.linearTerm, (DMatrixD1)other.linearTerm, (double)tol) && MatrixFeatures_DDRM.isEquals((DMatrixD1)this.residualCost, (DMatrixD1)other.residualCost, (double)tol);
    }
}

