/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class ICPQPIndexHandler {
    private static final String prefix = "indexHandler";
    private int numberOfFootstepsToConsider = 0;
    private int numberOfFreeVariables = 0;
    private int numberOfFootstepVariables = 0;
    private int footstepStartingIndex;
    private int copFeedbackIndex;
    private int cmpFeedbackIndex;
    private final YoBoolean useStepAdjustment;
    private final YoBoolean hasCMPFeedbackTask;
    private final YoBoolean useAngularMomentum;

    public ICPQPIndexHandler(YoRegistry registry) {
        this.useStepAdjustment = new YoBoolean("indexHandlerUseStepAdjustment", registry);
        this.hasCMPFeedbackTask = new YoBoolean("indexHandlerHasCMPFeedbackTask", registry);
        this.useAngularMomentum = new YoBoolean("indexHandlerUseAngularMomentum", registry);
        this.hasCMPFeedbackTask.set(false);
        this.useAngularMomentum.set(false);
    }

    public void resetFootsteps() {
        this.useStepAdjustment.set(false);
        this.numberOfFootstepsToConsider = 0;
    }

    public void registerFootstep() {
        this.useStepAdjustment.set(true);
        ++this.numberOfFootstepsToConsider;
    }

    public int getNumberOfFootstepsToConsider() {
        return this.numberOfFootstepsToConsider;
    }

    public boolean useStepAdjustment() {
        return this.useStepAdjustment.getBooleanValue();
    }

    public void setHasCMPFeedbackTask(boolean hasCMPFeedbackTask) {
        this.hasCMPFeedbackTask.set(hasCMPFeedbackTask);
    }

    public void setUseAngularMomentum(boolean useAngularMomentum) {
        this.useAngularMomentum.set(useAngularMomentum);
    }

    public boolean hasCMPFeedbackTask() {
        return this.hasCMPFeedbackTask.getBooleanValue();
    }

    public boolean useAngularMomentum() {
        return this.useAngularMomentum.getBooleanValue();
    }

    public void computeProblemSize() {
        this.copFeedbackIndex = 0;
        this.cmpFeedbackIndex = this.copFeedbackIndex + 2;
        this.footstepStartingIndex = this.hasCMPFeedbackTask.getBooleanValue() ? this.cmpFeedbackIndex + 2 : this.copFeedbackIndex + 2;
        this.numberOfFootstepVariables = 2 * this.numberOfFootstepsToConsider;
        this.numberOfFreeVariables = 2;
        if (this.useStepAdjustment.getBooleanValue()) {
            this.numberOfFreeVariables += this.numberOfFootstepVariables;
        }
        if (this.hasCMPFeedbackTask.getBooleanValue()) {
            this.numberOfFreeVariables += 2;
        }
    }

    public int getFootstepStartIndex() {
        return this.footstepStartingIndex;
    }

    public int getFootstepIndex(int footstepIndex) {
        return this.footstepStartingIndex + 2 * footstepIndex;
    }

    public int getCoPFeedbackIndex() {
        return this.copFeedbackIndex;
    }

    public int getCMPFeedbackIndex() {
        return this.cmpFeedbackIndex;
    }

    public int getNumberOfFootstepVariables() {
        return this.numberOfFootstepVariables;
    }

    public int getNumberOfFreeVariables() {
        return this.numberOfFreeVariables;
    }
}

