/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPInequalityInput;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPIndexHandler;

public class ICPQPConstraintCalculator {
    private final ICPQPIndexHandler indexHandler;

    public ICPQPConstraintCalculator(ICPQPIndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public void calculateMaxFeedbackMagnitudeConstraint(ICPInequalityInput inputToPack, double maxXMagnitude, double maxYMagnitude) {
        this.calculateMaxFeedbackMagnitudeConstraint(inputToPack, -maxXMagnitude, maxXMagnitude, -maxYMagnitude, maxYMagnitude);
    }

    public void calculateMaxFeedbackMagnitudeConstraint(ICPInequalityInput inputToPack, double minXMagnitude, double maxXMagnitude, double minYMagnitude, double maxYMagnitude) {
        inputToPack.reset();
        int size = 0;
        boolean hasXMax = Double.isFinite(maxXMagnitude);
        boolean hasXMin = Double.isFinite(minXMagnitude);
        boolean hasYMax = Double.isFinite(maxYMagnitude);
        boolean hasYMin = Double.isFinite(minYMagnitude);
        if (hasXMax) {
            ++size;
        }
        if (hasXMin) {
            ++size;
        }
        if (hasYMax) {
            ++size;
        }
        if (hasYMin) {
            ++size;
        }
        inputToPack.reshape(size, this.indexHandler.getNumberOfFreeVariables());
        int offset = 0;
        if (hasXMax) {
            inputToPack.Aineq.set(offset, this.indexHandler.getCoPFeedbackIndex(), 1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                inputToPack.Aineq.set(offset, this.indexHandler.getCMPFeedbackIndex(), 1.0);
            }
            inputToPack.bineq.set(offset, maxXMagnitude);
            ++offset;
        }
        if (hasXMin) {
            inputToPack.Aineq.set(offset, this.indexHandler.getCoPFeedbackIndex(), -1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                inputToPack.Aineq.set(offset, this.indexHandler.getCMPFeedbackIndex(), -1.0);
            }
            inputToPack.bineq.set(offset, -minXMagnitude);
            ++offset;
        }
        if (hasYMax) {
            inputToPack.Aineq.set(offset, this.indexHandler.getCoPFeedbackIndex() + 1, 1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                inputToPack.Aineq.set(offset, this.indexHandler.getCMPFeedbackIndex() + 1, 1.0);
            }
            inputToPack.bineq.set(offset, maxYMagnitude);
            ++offset;
        }
        if (hasYMin) {
            inputToPack.Aineq.set(offset, this.indexHandler.getCoPFeedbackIndex() + 1, -1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                inputToPack.Aineq.set(offset, this.indexHandler.getCMPFeedbackIndex() + 1, -1.0);
            }
            inputToPack.bineq.set(offset, -minYMagnitude);
        }
    }

    public void calculateMaxFeedbackRateConstraint(ICPInequalityInput inputToPack, double maxRate, DMatrixRMaj previousValue, double controlDT) {
        this.calculateMaxFeedbackRateConstraint(inputToPack, maxRate, maxRate, previousValue.get(0), previousValue.get(1), controlDT);
    }

    public void calculateMaxFeedbackRateConstraint(ICPInequalityInput inputToPack, double maxXRate, double maxYRate, double previousXValue, double previousYValue, double controlDT) {
        double maxXValue = previousXValue + controlDT * maxXRate;
        double minXValue = previousXValue - controlDT * maxXRate;
        double maxYValue = previousYValue + controlDT * maxYRate;
        double minYValue = previousYValue - controlDT * maxYRate;
        this.calculateMaxFeedbackMagnitudeConstraint(inputToPack, minXValue, maxXValue, minYValue, maxYValue);
    }
}

