/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPInequalityInput;
import us.ihmc.commonWalkingControlModules.polygonWiggling.PolygonWiggler;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.geometry.PlanarRegion;

public class ConstraintToConvexRegion
extends ICPInequalityInput {
    public final DMatrixRMaj positionOffset;
    private double deltaInside = 0.0;
    private final ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
    private final ConvexPolygon2D scaledConvexPolygon = new ConvexPolygon2D();
    private final ConvexPolygonScaler scaler = new ConvexPolygonScaler();

    public ConstraintToConvexRegion(int maximumNumberOfVertices) {
        super(maximumNumberOfVertices, maximumNumberOfVertices);
        this.positionOffset = new DMatrixRMaj(2, 1);
    }

    @Override
    public void reset() {
        super.reset();
        this.positionOffset.zero();
        this.convexPolygon.clear();
        this.scaledConvexPolygon.clear();
    }

    public void addVertex(FramePoint2DReadOnly vertex) {
        vertex.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.convexPolygon.addVertex((Point2DReadOnly)vertex);
    }

    public void addPolygon(ConvexPolygon2DReadOnly polygon) {
        this.convexPolygon.addVertices((Vertex2DSupplier)polygon);
    }

    public void addVertex(FramePoint3DReadOnly vertex) {
        vertex.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.convexPolygon.addVertex((Point3DReadOnly)vertex);
    }

    public boolean addPlanarRegion(PlanarRegion planarRegion, double deltaInside) {
        if (planarRegion == null) {
            return false;
        }
        this.convexPolygon.set(planarRegion.getConvexHull());
        this.deltaInside = deltaInside;
        return true;
    }

    public boolean addPlanarRegion(ConvexPolygon2DReadOnly convexPolygon, double deltaInside) {
        if (convexPolygon == null) {
            return false;
        }
        this.convexPolygon.set((Vertex2DSupplier)convexPolygon);
        this.deltaInside = deltaInside;
        return true;
    }

    public boolean addPlanarRegion(ConvexPolygon2DReadOnly convexPolygon) {
        if (convexPolygon == null) {
            return false;
        }
        this.convexPolygon.set((Vertex2DSupplier)convexPolygon);
        return true;
    }

    public void setPolygon() {
        this.convexPolygon.update();
    }

    public void setPositionOffset(DMatrixRMaj offset) {
        MatrixTools.setMatrixBlock((DMatrix)this.positionOffset, (int)0, (int)0, (DMatrix)offset, (int)0, (int)0, (int)2, (int)1, (double)1.0);
    }

    public void setDeltaInside(double deltaInside) {
        this.deltaInside = deltaInside;
    }

    public void formulateConstraint() {
        this.scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)this.convexPolygon, this.deltaInside, (ConvexPolygon2DBasics)this.scaledConvexPolygon);
        PolygonWiggler.convertToInequalityConstraints((ConvexPolygon2DReadOnly)this.scaledConvexPolygon, this.Aineq, this.bineq, 0.0);
        CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.Aineq, (DMatrix1Row)this.positionOffset, (DMatrix1Row)this.bineq);
    }

    public int getInequalityConstraintSize() {
        ConvexPolygon2D polygon = this.scaledConvexPolygon.isEmpty() ? this.convexPolygon : this.scaledConvexPolygon;
        int numberOfVertices = polygon.getNumberOfVertices();
        if (numberOfVertices > 2) {
            return numberOfVertices;
        }
        if (numberOfVertices > 0) {
            return 4;
        }
        return 0;
    }
}

